/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.preferences.gui;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.upb.inferenceengine.InferenceEngine;
import de.upb.inferenceengine.RuleCatalog;
import de.upb.inferenceengine.engines.GFRNEngine;
import de.upb.inferenceengine.preferences.InferenceEnginePreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class InferenceEnginePreferencesPanel
extends PreferencesPanel {
    private JRadioButton showAllAnnos;
    private JRadioButton hideAllAnnos;
    JRadioButton showSelAnnos;
    private JCheckBox debugCheckBox;
    private JCheckBox showClassificationBox;
    private JRadioButton jahnkeRadioButton;
    private JRadioButton heitbrederRadioButton;
    private JComboBox inferenceStrategyComboBox;
    private JTextField catalogsFolderTextField;
    private JTable enginesTable;
    EnginesTableModel enginesTableModel;

    public InferenceEnginePreferencesPanel() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(gridBag);
        JPanel optionsPanel = this.createOptionsPanel();
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        gridBag.setConstraints(optionsPanel, constraints);
        this.add(optionsPanel);
        JPanel folderPanel = this.createFolderPanel();
        gridBag.setConstraints(folderPanel, constraints);
        this.add(folderPanel);
        JPanel enginePanel = this.createEngineListPanel();
        constraints.weighty = 1.0;
        gridBag.setConstraints(enginePanel, constraints);
        this.add(enginePanel);
    }

    public String getPreferredTabName() {
        return "Pattern Recognition Inference";
    }

    public void setDefaults() {
        InferenceEnginePreferences.get().setDefaults();
        this.setPreferences();
    }

    public void setPreferences() {
        InferenceEnginePreferences options = InferenceEnginePreferences.get();
        if (options.isShowAllAnnotations()) {
            this.showAllAnnos.doClick();
        } else if (options.isHideAllAnnotations()) {
            this.hideAllAnnos.doClick();
        } else {
            this.showSelAnnos.doClick();
        }
        this.debugCheckBox.setSelected(options.isDebugMode());
        this.showClassificationBox.setSelected(options.isShowClassification());
        switch (options.getFTTStrategy()) {
            case 0: {
                this.jahnkeRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.heitbrederRadioButton.setSelected(true);
            }
        }
        Class strategyClass = options.getInferenceStrategy();
        int index = 0;
        boolean found = false;
        while (index < InferenceEnginePreferences.INFERENCE_STRATEGIES.length && !found) {
            if (strategyClass == InferenceEnginePreferences.INFERENCE_STRATEGIES[index]) {
                found = true;
                this.inferenceStrategyComboBox.setSelectedItem(InferenceEnginePreferences.INFERENCE_STRATEGY_NAMES[index]);
            }
            ++index;
        }
        this.catalogsFolderTextField.setText(options.getCatalogsFolder());
        this.enginesTableModel.update();
        this.enginesTable.updateUI();
        int row = 0;
        while (row < this.enginesTableModel.getRowCount()) {
            String key = (String)this.enginesTableModel.getValueAt(row, 0);
            boolean checked = options.isAnnotationVisible(key);
            this.enginesTableModel.setValueAt(checked, row, 1);
            int showBelief = options.getShowBeliefValue(key);
            this.enginesTableModel.setValueAt(new Integer(showBelief), row, 2);
            ++row;
        }
    }

    private JPanel createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Options"));
        panel.setLayout(new GridLayout(1, 2));
        JPanel showSelectionPanel = new JPanel();
        showSelectionPanel.setLayout(new GridLayout(4, 0));
        ButtonGroupListener buttonGroupListener = new ButtonGroupListener();
        this.showAllAnnos = new JRadioButton("Show all annotations");
        this.showAllAnnos.setMnemonic('a');
        this.showAllAnnos.setSelected(true);
        this.showAllAnnos.addActionListener(buttonGroupListener);
        showSelectionPanel.add(this.showAllAnnos);
        this.hideAllAnnos = new JRadioButton("Hide all annotations");
        this.hideAllAnnos.setMnemonic('h');
        this.hideAllAnnos.setSelected(false);
        this.hideAllAnnos.addActionListener(buttonGroupListener);
        showSelectionPanel.add(this.hideAllAnnos);
        this.showSelAnnos = new JRadioButton("Show selected annotations");
        this.showSelAnnos.setMnemonic('s');
        this.showSelAnnos.setSelected(false);
        this.showSelAnnos.addActionListener(buttonGroupListener);
        showSelectionPanel.add(this.showSelAnnos);
        ButtonGroup visibilityGroup = new ButtonGroup();
        visibilityGroup.add(this.showAllAnnos);
        visibilityGroup.add(this.hideAllAnnos);
        visibilityGroup.add(this.showSelAnnos);
        this.debugCheckBox = new JCheckBox("Debug Mode");
        showSelectionPanel.add(this.debugCheckBox);
        this.showClassificationBox = new JCheckBox("Show Classification");
        showSelectionPanel.add(this.showClassificationBox);
        panel.add(showSelectionPanel);
        JPanel strategyPanel = new JPanel();
        strategyPanel.setLayout(new GridLayout(4, 1));
        JPanel strategyRadioButtonPanel = new JPanel();
        strategyRadioButtonPanel.setLayout(new GridLayout(1, 2));
        JLabel strategyLabel = new JLabel("Strategy for Fuzzy Truth Token Calculation:");
        strategyPanel.add(strategyLabel);
        strategyPanel.add(strategyRadioButtonPanel);
        this.jahnkeRadioButton = new JRadioButton("Jahnke");
        this.jahnkeRadioButton.setMnemonic('j');
        this.jahnkeRadioButton.setSelected(true);
        strategyRadioButtonPanel.add(this.jahnkeRadioButton);
        this.heitbrederRadioButton = new JRadioButton("Heitbreder");
        this.heitbrederRadioButton.setMnemonic('b');
        this.heitbrederRadioButton.setSelected(false);
        strategyRadioButtonPanel.add(this.heitbrederRadioButton);
        ButtonGroup strategyGroup = new ButtonGroup();
        strategyGroup.add(this.jahnkeRadioButton);
        strategyGroup.add(this.heitbrederRadioButton);
        JLabel inferenceStrategyLabel = new JLabel("Strategy for the Inference Algorithm:");
        strategyPanel.add(inferenceStrategyLabel);
        this.inferenceStrategyComboBox = new JComboBox<String>(InferenceEnginePreferences.INFERENCE_STRATEGY_NAMES);
        this.inferenceStrategyComboBox.setSelectedIndex(0);
        strategyPanel.add(this.inferenceStrategyComboBox);
        panel.add(strategyPanel);
        return panel;
    }

    private JPanel createFolderPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Folder"));
        panel.setLayout(gridBagLayout);
        JLabel workspaceLabel = new JLabel("Catalogs:");
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel.add((Component)workspaceLabel, constraints);
        this.catalogsFolderTextField = new JTextField();
        this.catalogsFolderTextField.setToolTipText("This folder will be used for loading/saving of pattern recoginition engines catalogs.");
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        panel.add((Component)this.catalogsFolderTextField, constraints);
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new BrowseButtonListener(this.catalogsFolderTextField, 1));
        constraints.insets = new Insets(0, 3, 3, 0);
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.gridx = 3;
        panel.add((Component)browseButton, constraints);
        return panel;
    }

    private JPanel createEngineListPanel() {
        this.enginesTableModel = new EnginesTableModel();
        this.enginesTable = new JTable(this.enginesTableModel);
        this.initColumnSizes(this.enginesTable);
        JScrollPane scrollPane = new JScrollPane(this.enginesTable);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(new TitledBorder("Annotations"));
        panel.add(scrollPane);
        return panel;
    }

    private void initColumnSizes(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setResizable(false);
        int i = 1;
        while (i < table.getColumnCount()) {
            column = columnModel.getColumn(i);
            TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
            Component comp = renderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            column.setMaxWidth(comp.getPreferredSize().width + 10);
            column.setMinWidth(comp.getPreferredSize().width + 10);
            column.setResizable(false);
            ++i;
        }
    }

    public void okPressed() {
        InferenceEnginePreferences options = InferenceEnginePreferences.get();
        options.setShowAllAnnotations(this.showAllAnnos.isSelected());
        options.setHideAllAnnotations(this.hideAllAnnos.isSelected());
        options.setShowSelAnnotations(this.showSelAnnos.isSelected());
        options.setDebugMode(this.debugCheckBox.isSelected());
        options.setShowClassification(this.showClassificationBox.isSelected());
        if (this.jahnkeRadioButton.isSelected()) {
            options.setFTTStrategy(0);
        } else if (this.heitbrederRadioButton.isSelected()) {
            options.setFTTStrategy(1);
        }
        options.setInferenceStrategy(InferenceEnginePreferences.INFERENCE_STRATEGIES[this.inferenceStrategyComboBox.getSelectedIndex()]);
        options.setCatalogsFolder(this.catalogsFolderTextField.getText());
        int row = 0;
        while (row < this.enginesTableModel.getRowCount()) {
            String key = (String)this.enginesTableModel.getValueAt(row, 0);
            Boolean checked = (Boolean)this.enginesTableModel.getValueAt(row, 1);
            options.setAnnotationVisible(key, checked);
            Integer showBelief = (Integer)this.enginesTableModel.getValueAt(row, 2);
            options.setShowBeliefValue(key, showBelief);
            ++row;
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        private int selectionMode;
        private JTextField targetTextField;

        public BrowseButtonListener(JTextField targetTextField, int selectionMode) {
            this.targetTextField = targetTextField;
            this.selectionMode = selectionMode;
        }

        public void actionPerformed(ActionEvent e) {
            File file = new File(System.getProperty("user.dir"), "*.*");
            JFileChooser fileChooser = new JFileChooser(file);
            fileChooser.setFileSelectionMode(this.selectionMode);
            if (fileChooser.showOpenDialog(FrameMain.get().getFrame()) == 0 && (file = fileChooser.getSelectedFile()).exists()) {
                this.targetTextField.setText(file.getPath());
            }
        }
    }

    private class ButtonGroupListener
    implements ActionListener {
        ButtonGroupListener() {
        }

        public void actionPerformed(ActionEvent e) {
            InferenceEnginePreferencesPanel.this.enginesTableModel.setSelectable(InferenceEnginePreferencesPanel.this.showSelAnnos.isSelected());
        }
    }

    private static class EnginesTableModel
    extends AbstractTableModel {
        private static final int COLUMN_COUNT = 3;
        private int rowCount;
        private Object[][] values;
        private boolean selectable;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        public EnginesTableModel() {
            this.update();
        }

        public void update() {
            TreeSet treeSet = new TreeSet(new EngineComparator());
            Iterator catalogIter = InferenceEngine.get().iteratorOfCatalogs();
            while (catalogIter.hasNext()) {
                RuleCatalog ruleCatalog = (RuleCatalog)catalogIter.next();
                Iterator engineIter = ruleCatalog.iteratorOfEngines();
                while (engineIter.hasNext()) {
                    treeSet.add(engineIter.next());
                }
            }
            this.rowCount = treeSet.size();
            this.values = new Object[this.rowCount][3];
            Iterator treeIter = treeSet.iterator();
            int row = 0;
            while (treeIter.hasNext()) {
                this.values[row][0] = ((GFRNEngine)treeIter.next()).getName();
                ++row;
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Annotation";
                }
                case 1: {
                    return "Visible";
                }
                case 2: {
                    return "Visibility threshold";
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            return this.values[row][col];
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.values[row][col] = (Boolean)value;
            } else if (col == 2) {
                try {
                    Integer i = (Integer)value;
                    if (i >= 0 && i <= 100) {
                        this.values[row][col] = i;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                case 1: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
                case 2: {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return clazz;
                }
            }
            return null;
        }

        public void setSelectable(boolean selectable) {
            this.selectable = selectable;
        }

        public boolean isCellEditable(int row, int col) {
            boolean result = false;
            switch (col) {
                case 0: {
                    result = false;
                    break;
                }
                case 1: {
                    result = this.selectable;
                    break;
                }
                case 2: {
                    result = this.selectable;
                }
            }
            return result;
        }
    }

    private static class EngineComparator
    implements Comparator {
        EngineComparator() {
        }

        public int compare(Object o1, Object o2) {
            GFRNEngine engine1 = (GFRNEngine)o1;
            GFRNEngine engine2 = (GFRNEngine)o2;
            return engine1.getName().compareTo(engine2.getName());
        }
    }
}

