/*
 * Decompiled with CFR 0.152.
 */
package de.upb.inferenceengine.visitors;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.asg.ASGVisitor;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.ASTNode;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.upb.javaast.methodast.BinaryExpressionNode;
import de.upb.javaast.methodast.BlockNode;
import de.upb.javaast.methodast.CaseNode;
import de.upb.javaast.methodast.CatchBlockNode;
import de.upb.javaast.methodast.ForNode;
import de.upb.javaast.methodast.IfNode;
import de.upb.javaast.methodast.InstanceOfExpressionNode;
import de.upb.javaast.methodast.LoopNode;
import de.upb.javaast.methodast.MethodCallNode;
import de.upb.javaast.methodast.PrimaryExpressionNode;
import de.upb.javaast.methodast.ReturnNode;
import de.upb.javaast.methodast.RootBlockNode;
import de.upb.javaast.methodast.StatementExpressionNode;
import de.upb.javaast.methodast.SwitchNode;
import de.upb.javaast.methodast.TryNode;
import de.upb.javaast.methodast.TypeCastNode;
import de.upb.javaast.methodast.TypeNode;
import de.upb.javaast.methodast.VariableDeclarationNode;
import de.upb.javaast.methodast.VariableIdentifierDeclarationNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class ASTPathVisitor
extends ASGVisitor
implements Iterator {
    private Class targetClass;
    private HashSet tabooClasses;
    private LinkedList queue = new LinkedList();
    private ASGElement currentMatchingNode;

    public ASTPathVisitor(ASGElement startNode, Class targetClass) {
        this.queue.add(startNode);
        this.targetClass = targetClass;
    }

    public ASTPathVisitor(ASGElement startNode, Class targetClass, Class[] tabooClasses) {
        this.addToQueue(startNode);
        this.targetClass = targetClass;
        this.tabooClasses = new HashSet(tabooClasses.length);
        int i = 0;
        while (i < tabooClasses.length) {
            this.tabooClasses.add(tabooClasses[i]);
            ++i;
        }
    }

    public boolean hasNext() {
        if (this.currentMatchingNode == null) {
            while (this.currentMatchingNode == null && this.queue.size() > 0) {
                ASGElement tmp = (ASGElement)this.queue.removeFirst();
                this.visit((FElement)tmp);
            }
        }
        return this.currentMatchingNode != null;
    }

    public Object next() {
        if (this.hasNext()) {
            ASGElement tmpMatchingNode = this.currentMatchingNode;
            this.currentMatchingNode = null;
            return tmpMatchingNode;
        }
        throw new NoSuchElementException("ASTPathVisitor: No further matching element found on path.");
    }

    public void remove() {
        throw new UnsupportedOperationException("ASTPathVisitor: This iterator only implements read access.");
    }

    public void visitUMLMethod(UMLMethod umlMethod) {
        this.addToQueue(umlMethod.getASTRootNode());
    }

    private void addToQueue(Object elem) {
        this.queue.add(elem);
    }

    public void visitASTNode(ASTNode astNode) {
        if (this.targetClass.isInstance(astNode)) {
            this.currentMatchingNode = astNode;
        }
    }

    public void visitRootBlockNode(RootBlockNode rootBlockNode) {
        this.visitASTNode((ASTNode)rootBlockNode);
        if (rootBlockNode.getBlock() != null) {
            this.addToQueue(rootBlockNode.getBlock());
        }
    }

    public void visitBlockNode(BlockNode blockNode) {
        this.visitASTNode((ASTNode)blockNode);
        Iterator iter = blockNode.iteratorOfStatements();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
    }

    public void visitLoopNode(LoopNode loopNode) {
        this.visitASTNode((ASTNode)loopNode);
        if (loopNode.getLoopExpression() != null) {
            this.addToQueue(loopNode.getLoopExpression());
        }
        this.addToQueue(loopNode.getLoopBlock());
    }

    public void visitForNode(ForNode forNode) {
        this.visitLoopNode((LoopNode)forNode);
        Iterator iter = forNode.iteratorOfInitStatements();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
        iter = forNode.iteratorOfUpdateExpressions();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
    }

    public void visitTryNode(TryNode tryNode) {
        this.visitASTNode((ASTNode)tryNode);
        this.addToQueue(tryNode.getTryBlock());
        Iterator iter = tryNode.iteratorOfCatchBlocks();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
        if (tryNode.getFinallyBlock() != null) {
            this.addToQueue(tryNode.getFinallyBlock());
        }
    }

    public void visitCatchBlockNode(CatchBlockNode catchBlockNode) {
        this.visitBlockNode((BlockNode)catchBlockNode);
        this.addToQueue(catchBlockNode.getExceptionDeclaration());
    }

    public void visitSwitchNode(SwitchNode switchNode) {
        this.visitASTNode((ASTNode)switchNode);
        this.addToQueue(switchNode.getSwitchExpression());
        Iterator iter = switchNode.iteratorOfCaseStatements();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
    }

    public void visitCaseNode(CaseNode caseNode) {
        this.visitASTNode((ASTNode)caseNode);
        if (caseNode.getCaseExpression() != null) {
            this.addToQueue(caseNode.getCaseExpression());
        }
        if (caseNode.getCaseBlock() != null) {
            this.addToQueue(caseNode.getCaseBlock());
        }
    }

    public void visitIfNode(IfNode ifNode) {
        this.visitASTNode((ASTNode)ifNode);
        this.addToQueue(ifNode.getExpression());
        this.addToQueue(ifNode.getIfBlock());
        if (ifNode.getElseBlock() != null) {
            this.addToQueue(ifNode.getElseBlock());
        }
    }

    public void visitVariableDeclarationNode(VariableDeclarationNode variableDeclarationNode) {
        this.visitASTNode((ASTNode)variableDeclarationNode);
        this.addToQueue(variableDeclarationNode.getType());
        Iterator iter = variableDeclarationNode.iteratorOfIdDeclarations();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
    }

    public void visitTypeNode(TypeNode typeNode) {
        this.visitASTNode((ASTNode)typeNode);
        Iterator iter = typeNode.iteratorOfIdentifiers();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
    }

    public void visitVariableIdentifierDeclarationNode(VariableIdentifierDeclarationNode varIdDeclNode) {
        this.visitASTNode((ASTNode)varIdDeclNode);
        this.addToQueue(varIdDeclNode.getIdentifier());
        if (varIdDeclNode.getInitialValue() != null) {
            this.addToQueue(varIdDeclNode.getInitialValue());
        }
    }

    public void visitReturnNode(ReturnNode returnNode) {
        this.visitASTNode((ASTNode)returnNode);
        if (returnNode.getReturnExpression() != null) {
            this.addToQueue(returnNode.getReturnExpression());
        }
    }

    public void visitStatementExpressionNode(StatementExpressionNode statementExpressionNode) {
        this.visitASTNode((ASTNode)statementExpressionNode);
        if (statementExpressionNode.getExpression() != null) {
            this.addToQueue(statementExpressionNode.getExpression());
        }
    }

    public void visitBinaryExpressionNode(BinaryExpressionNode binaryExpressionNode) {
        this.visitASTNode((ASTNode)binaryExpressionNode);
        if (binaryExpressionNode.getLeftExpression() != null) {
            this.addToQueue(binaryExpressionNode.getLeftExpression());
        }
        if (binaryExpressionNode.getRightExpression() != null) {
            this.addToQueue(binaryExpressionNode.getRightExpression());
        }
    }

    public void visitPrimaryExpressionNode(PrimaryExpressionNode primaryExpressionNode) {
        this.visitASTNode((ASTNode)primaryExpressionNode);
        if (primaryExpressionNode.getExpression() != null) {
            this.addToQueue(primaryExpressionNode.getExpression());
        }
        if (primaryExpressionNode.getIdentifier() != null) {
            this.addToQueue(primaryExpressionNode.getIdentifier());
        }
        if (primaryExpressionNode.getNextPrimaryExpression() != null) {
            this.addToQueue(primaryExpressionNode.getNextPrimaryExpression());
        }
    }

    public void visitInstanceOfExpressionNode(InstanceOfExpressionNode instanceOfExpressionNode) {
        this.visitASTNode((ASTNode)instanceOfExpressionNode);
        if (instanceOfExpressionNode.getExpression() != null) {
            this.addToQueue(instanceOfExpressionNode.getExpression());
        }
        if (instanceOfExpressionNode.getType() != null) {
            this.addToQueue(instanceOfExpressionNode.getType());
        }
    }

    public void visitMethodCallNode(MethodCallNode methodCallNode) {
        this.visitPrimaryExpressionNode((PrimaryExpressionNode)methodCallNode);
        Iterator iter = methodCallNode.iteratorOfArguments();
        while (iter.hasNext()) {
            this.addToQueue(iter.next());
        }
    }

    public void visitTypeCastNode(TypeCastNode typeCastNode) {
        this.visitPrimaryExpressionNode((PrimaryExpressionNode)typeCastNode);
        this.addToQueue(typeCastNode.getType());
    }
}

