/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.MutableObjectChange;
import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeAware;
import de.upb.tools.fca.FHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CopyManager {
    private LocalRepository repository;
    private LocalRepository.CoObRAsXMLReflect reflect;
    private Map copyObjects;
    private Set objectsToBeCopied;
    private CopyChangeCallbackInterface callbackInterface;

    public CopyManager(LocalRepository repository, Set objectsToBeCopied) {
        this.repository = repository;
        this.reflect = new LocalRepository.CoObRAsXMLReflect(repository);
        this.copyObjects = new FHashMap();
        this.objectsToBeCopied = objectsToBeCopied;
    }

    public Object getCopiedObject(Object oldObject) {
        if (this.objectsToBeCopied.contains(oldObject)) {
            ObjectChangeAware newObject = (ObjectChangeAware)this.copyObjects.get(oldObject);
            return newObject;
        }
        return oldObject;
    }

    public void copy(Set changesToBeCopied) {
        this.repository.removeAllFromUndone();
        this.createObjects();
        Iterator it = changesToBeCopied.iterator();
        while (it.hasNext()) {
            CopiedObjectChange copiedChange;
            ObjectChange change = (ObjectChange)it.next();
            if (change.getTypeOfChange() == 1) continue;
            if (this.callbackInterface != null) {
                MutableObjectChange mutableChange = new MutableObjectChange(change);
                this.callbackInterface.reviewCopiedChange(mutableChange);
                copiedChange = new CopiedObjectChange(mutableChange);
            } else {
                copiedChange = new CopiedObjectChange(change);
            }
            this.repository.addToUndone(copiedChange, false);
        }
        this.repository.redo(-2);
    }

    private void createObjects() {
        Iterator it = this.objectsToBeCopied.iterator();
        while (it.hasNext()) {
            Object oldObject = it.next();
            Object newObject = this.copyObjects.get(oldObject);
            if (newObject != null) continue;
            try {
                newObject = this.reflect.createObjectInstance(oldObject.getClass());
                this.copyObjects.put(oldObject, newObject);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to create objects for copying", e);
            }
        }
    }

    public void setCopyChangeCallback(CopyChangeCallbackInterface callbackInterface) {
        this.callbackInterface = callbackInterface;
    }

    class CopiedObjectChange
    extends ObjectChange {
        public CopiedObjectChange(ObjectChange change) {
            super(ObjectChange.peekCause(), (ObjectChangeAware)CopyManager.this.getCopiedObject(change.getAffectedObject()), change.getFieldName(), change.getTypeOfChange(), CopyManager.this.getCopiedObject(change.getOldValue()), CopyManager.this.getCopiedObject(change.getNewValue()), CopyManager.this.repository.getNewSequenceNumber(), change.getKey());
        }

        public CopiedObjectChange(MutableObjectChange change) {
            super(ObjectChange.peekCause(), (ObjectChangeAware)CopyManager.this.getCopiedObject(change.getAffectedObject()), change.getFieldName(), change.getTypeOfChange(), CopyManager.this.getCopiedObject(change.getOldValue()), CopyManager.this.getCopiedObject(change.getNewValue()), CopyManager.this.repository.getNewSequenceNumber(), CopyManager.this.getCopiedObject(change.getKey()));
        }
    }

    public static interface CopyChangeCallbackInterface {
        public void reviewCopiedChange(MutableObjectChange var1);
    }
}

