/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra;

import de.tu_bs.coobra.ObjectChangeAware;
import de.tu_bs.coobra.ObjectChangeCause;
import de.upb.tools.fca.FHashMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.Map;
import java.util.Stack;

public class ObjectChange
extends ObjectChangeCause
implements Comparable,
Cloneable {
    public static final int CHANGE_TYPE_UNDEFINED = 0;
    public static final int CHANGE_TYPE_ADD_OBJECT = 1;
    public static final int CHANGE_TYPE_REMOVE_OBJECT = 2;
    public static final int CHANGE_TYPE_ADD = 4;
    public static final int CHANGE_TYPE_REMOVE = 8;
    public static final int CHANGE_TYPE_ALTER = 12;
    public static final int CHANGE_TYPE_USER = 64;
    private static Map causeStacks;
    private Object affectedObject = null;
    private String fieldName = null;
    private Object key;
    private int typeOfChange = 0;
    private Object oldValue = null;
    private Object newValue = null;
    private BigInteger sequenceNumber;
    long timestamp;

    private static Stack getCauseStack() {
        if (causeStacks == null) {
            return null;
        }
        return (Stack)causeStacks.get(Thread.currentThread());
    }

    private static void setCauseStack(Stack newStackForThisThread) {
        if (newStackForThisThread != null) {
            if (causeStacks == null) {
                causeStacks = new FHashMap();
            }
            causeStacks.put(Thread.currentThread(), newStackForThisThread);
        } else if (causeStacks != null) {
            causeStacks.remove(Thread.currentThread());
        }
    }

    public static void pushCause(ObjectChangeCause newCause) {
        Stack<ObjectChangeCause> stack = ObjectChange.getCauseStack();
        if (stack == null) {
            stack = new Stack<ObjectChangeCause>();
            ObjectChange.setCauseStack(stack);
        }
        stack.push(newCause);
    }

    public static ObjectChangeCause popCause() {
        return ObjectChange.popCause_internal();
    }

    private static ObjectChangeCause popCause_internal() {
        Stack stack = ObjectChange.getCauseStack();
        if (stack == null) {
            return null;
        }
        if (!stack.isEmpty()) {
            return (ObjectChangeCause)stack.pop();
        }
        return null;
    }

    public static ObjectChangeCause popCause(ObjectChangeCause cause) throws CorruptedStackException {
        ObjectChangeCause poppedCause = ObjectChange.popCause_internal();
        if (poppedCause != cause) {
            throw new CorruptedStackException("Popped wrong cause: " + poppedCause + " instead of " + cause);
        }
        return cause;
    }

    public static ObjectChangeCause peekCause() {
        Stack stack = ObjectChange.getCauseStack();
        if (stack == null) {
            return null;
        }
        if (!stack.isEmpty()) {
            return (ObjectChangeCause)stack.peek();
        }
        return null;
    }

    ObjectChange() {
        super(false, ObjectChange.peekCause());
        this.sequenceNumber = BigInteger.ZERO.subtract(BigInteger.ONE);
    }

    ObjectChange(ObjectChangeCause cause, ObjectChangeAware affectedObject, String fieldName, int typeOfChange, Object oldValue, Object newValue, BigInteger sequenceNumber) {
        this(cause, affectedObject, fieldName, typeOfChange, oldValue, newValue, sequenceNumber, null);
    }

    ObjectChange(ObjectChangeCause cause, ObjectChangeAware affectedObject, String fieldName, int typeOfChange, Object oldValue, Object newValue, BigInteger sequenceNumber, Object key) {
        this(cause, affectedObject, fieldName, typeOfChange, oldValue, newValue, sequenceNumber, key, System.currentTimeMillis());
    }

    ObjectChange(ObjectChangeCause cause, ObjectChangeAware affectedObject, String fieldName, int typeOfChange, Object oldValue, Object newValue, BigInteger sequenceNumber, Object key, long timestamp) {
        super(cause != null ? cause.isUndoRedo() : false, cause);
        if (affectedObject == null) {
            throw new NullPointerException("affected object may not be null!");
        }
        this.affectedObject = affectedObject;
        this.fieldName = fieldName;
        this.key = key;
        this.typeOfChange = typeOfChange;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.timestamp = timestamp;
        this.sequenceNumber = sequenceNumber != null ? sequenceNumber : BigInteger.ZERO.subtract(BigInteger.ONE);
    }

    public void weaken() {
        if (!(this.affectedObject instanceof WeakReference)) {
            this.affectedObject = new WeakReference<ObjectChangeAware>(this.getAffectedObject());
            this.key = this.key instanceof ObjectChangeAware ? new WeakReference<Object>(this.getKey()) : this.key;
            this.oldValue = this.oldValue instanceof ObjectChangeAware ? new WeakReference<Object>(this.getOldValue()) : this.oldValue;
            this.newValue = this.newValue instanceof ObjectChangeAware ? new WeakReference<Object>(this.getNewValue()) : this.newValue;
        }
    }

    public void removeYou() {
        super.removeYou();
    }

    public Object getKey() {
        return this.key instanceof Reference ? ((Reference)this.key).get() : this.key;
    }

    public ObjectChangeAware getAffectedObject() {
        return this.affectedObject instanceof Reference ? (ObjectChangeAware)((Reference)this.affectedObject).get() : (ObjectChangeAware)this.affectedObject;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getTypeOfChange() {
        return this.typeOfChange;
    }

    public Object getOldValue() {
        return this.oldValue instanceof Reference ? ((Reference)this.oldValue).get() : this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue instanceof Reference ? ((Reference)this.newValue).get() : this.newValue;
    }

    public boolean hadNewValue() {
        return this.newValue != null && this.getNewValue() == null;
    }

    public boolean hadOldValue() {
        return this.oldValue != null && this.getOldValue() == null;
    }

    public boolean hadKey() {
        return this.key != null && this.getKey() == null;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject instanceof ObjectChange) {
            ObjectChange otherChange = (ObjectChange)otherObject;
            if (this.getTypeOfChange() != otherChange.getTypeOfChange()) {
                return false;
            }
            if (this.getCause() != null ? !this.getCause().equals(otherChange.getCause()) : otherChange.getCause() != null) {
                return false;
            }
            if (this.getAffectedObject() != otherChange.getAffectedObject()) {
                return false;
            }
            if (this.getFieldName() != null ? !this.getFieldName().equals(otherChange.getFieldName()) : otherChange.getFieldName() != null) {
                return false;
            }
            if (this.getNewValue() != null ? (this.getNewValue() instanceof ObjectChangeAware ? this.getNewValue() != otherChange.getNewValue() : !this.getNewValue().equals(otherChange.getNewValue())) : otherChange.getNewValue() != null) {
                return false;
            }
            return !(this.getOldValue() != null ? (this.getOldValue() instanceof ObjectChangeAware ? this.getOldValue() != otherChange.getOldValue() : !this.getOldValue().equals(otherChange.getOldValue())) : otherChange.getOldValue() != null);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        String text = "Change";
        text = text + "#" + this.getSequenceNumber();
        text = text + "(";
        text = this.getAffectedObject() != null ? text + this.getAffectedObject().getClass().getName() + "(" + this.getAffectedObject().getCoObRAId() + ": " + this.getAffectedObject().toString() + ")" : text + "null";
        switch (this.getTypeOfChange()) {
            case 12: {
                String oldV = "" + this.getOldValue();
                String newV = "" + this.getNewValue();
                if (oldV.length() > 30) {
                    oldV = oldV.substring(0, 30) + "...";
                }
                if (newV.length() > 30) {
                    newV = newV.substring(0, 30) + "...";
                }
                text = text + "." + this.getFieldName() + (this.getKey() != null ? "[" + this.getKey() + "]" : "") + " from '" + oldV + "' to '" + newV + "'";
                break;
            }
            case 4: {
                text = text + "." + this.getFieldName() + (this.getKey() != null ? "[" + this.getKey() + "]" : "") + " add '" + this.getNewValue() + "'";
                break;
            }
            case 8: {
                text = text + "." + this.getFieldName() + (this.getKey() != null ? "[" + this.getKey() + "]" : "") + " remove '" + this.getOldValue() + "'";
                break;
            }
            case 1: {
                text = text + " added";
                break;
            }
            case 2: {
                text = text + " removed";
                break;
            }
            default: {
                text = text + " unknown change";
            }
        }
        if (this.getCause() != null) {
            text = text + ", cause: ";
            text = this.getCause() instanceof ObjectChange ? text + "Change#" + ((ObjectChange)this.getCause()).getSequenceNumber() : text + this.getCause().toString();
        }
        return text + ")";
    }

    public int compareTo(Object otherObject) throws ClassCastException {
        if (otherObject instanceof ObjectChange) {
            ObjectChange otherChange = (ObjectChange)otherObject;
            long cmp = otherChange.getSequenceNumber().compareTo(this.getSequenceNumber());
            return cmp < 0L ? -1 : (cmp > 0L ? 1 : 0);
        }
        throw new ClassCastException("Cannot compare ObjectChange with " + otherObject);
    }

    public BigInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    public static boolean isCause() {
        Stack stack = ObjectChange.getCauseStack();
        return stack != null ? !stack.isEmpty() : false;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    static class CorruptedStackException
    extends RuntimeException {
        public CorruptedStackException(String message) {
            super(message);
        }
    }
}

