/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra;

import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeAware;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ObjectChangeUtils {
    private static ObjectChangeUtils instance;
    public Comparator sortForCompactComparator;
    public Comparator reverseComparator = new ReverseComparator();

    protected ObjectChangeUtils() {
    }

    public static ObjectChangeUtils get() {
        if (instance == null) {
            instance = new ObjectChangeUtils();
        }
        return instance;
    }

    public static void set(ObjectChangeUtils instance) {
        ObjectChangeUtils.instance = instance;
    }

    public boolean valuesEqual(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (!(value1 instanceof ObjectChangeAware) && !(value2 instanceof ObjectChangeAware)) {
            if (value1 != null && value2 != null) {
                return value1.equals(value2);
            }
            return false;
        }
        return false;
    }

    protected Comparator getSortForCompactComparator() {
        if (this.sortForCompactComparator == null) {
            this.sortForCompactComparator = new SortForCompact();
        }
        return this.sortForCompactComparator;
    }

    public void compact(SortedSet changesSet) {
        if (changesSet != null) {
            TreeSet<ObjectChange> changes = new TreeSet<ObjectChange>(this.getSortForCompactComparator());
            Iterator iterator = changesSet.iterator();
            while (iterator.hasNext()) {
                ObjectChange change = (ObjectChange)iterator.next();
                if (change.getAffectedObject() == null) continue;
                changes.add(change);
            }
            changesSet.clear();
            TreeSet<ObjectChange> changesToObject = new TreeSet<ObjectChange>();
            ObjectChange formerChange = null;
            ObjectChangeAware formerObject = null;
            HashMap<Object, ObjectChange> addedValues = new HashMap<Object, ObjectChange>();
            int created = 0;
            HashSet<ObjectChangeAware> removedObjects = new HashSet<ObjectChangeAware>();
            Iterator it = changes.iterator();
            boolean onceAgain = it.hasNext();
            while (onceAgain) {
                ObjectChangeAware currentObject;
                ObjectChange change;
                if (it.hasNext()) {
                    change = (ObjectChange)it.next();
                } else {
                    change = null;
                    onceAgain = false;
                }
                boolean sameField = false;
                ObjectChangeAware objectChangeAware = currentObject = change != null ? change.getAffectedObject() : null;
                if (currentObject == formerObject) {
                    String fieldName = change.getFieldName();
                    if (formerChange != null && fieldName != null && formerChange.getFieldName() != null && fieldName.equals(formerChange.getFieldName()) && (change.getKey() == null && formerChange.getKey() == null || change.getKey() instanceof String && change.getKey().equals(formerChange.getKey()))) {
                        ObjectChange addChange;
                        sameField = true;
                        if (change.getTypeOfChange() == 12 && formerChange.getTypeOfChange() == 12) {
                            if (!this.valuesEqual(formerChange.getOldValue(), change.getNewValue())) {
                                ObjectChange oldChange = change;
                                change = new ObjectChange(change.getCause(), formerObject, fieldName, 12, formerChange.getOldValue(), change.getNewValue(), change.getSequenceNumber(), change.getKey());
                                oldChange.removeYou();
                                formerChange.removeYou();
                                formerChange = null;
                            } else {
                                change.removeYou();
                                formerChange.removeYou();
                                change = null;
                                formerChange = null;
                            }
                        } else if (change.getTypeOfChange() == 8 && (addChange = (ObjectChange)addedValues.get(change.getOldValue())) != null) {
                            addChange.removeYou();
                            if (formerChange == addChange) {
                                formerChange = null;
                            } else {
                                changesToObject.remove(addChange);
                            }
                            change.removeYou();
                            change = null;
                        }
                    }
                }
                if (formerChange != null && formerChange.getAffectedObject() == formerObject) {
                    changesToObject.add(formerChange);
                }
                if (!sameField) {
                    addedValues.clear();
                }
                if (currentObject != formerObject) {
                    if (formerObject != null) {
                        if (created >= 0) {
                            if (change != null && change.getAffectedObject() == formerObject) {
                                changesToObject.add(change);
                            }
                            changesSet.addAll(changesToObject);
                            formerChange = null;
                        } else {
                            removedObjects.add(formerObject);
                        }
                    }
                    formerObject = currentObject;
                    created = 0;
                    changesToObject.clear();
                }
                if (formerChange != null && formerChange.getAffectedObject() == formerObject) {
                    changesToObject.add(formerChange);
                }
                if (change != null) {
                    if (change.getTypeOfChange() == 2 && created == 1) {
                        created = -1;
                    } else if (change.getTypeOfChange() == 1) {
                        created = 1;
                    }
                    if (change.getTypeOfChange() == 4) {
                        addedValues.put(change.getNewValue(), change);
                    } else if (change.getTypeOfChange() == 8) {
                        addedValues.remove(change.getOldValue());
                    }
                }
                formerChange = change;
            }
            boolean useIteratorDotRemove = false;
            boolean finished = false;
            TreeSet<ObjectChange> changesWithRemovedKeys = new TreeSet<ObjectChange>();
            while (!finished) {
                try {
                    Iterator iterator2 = changesSet.iterator();
                    while (iterator2.hasNext()) {
                        boolean remove;
                        ObjectChange change = (ObjectChange)iterator2.next();
                        if (removedObjects.contains(change.getNewValue()) || removedObjects.contains(change.getOldValue())) {
                            remove = true;
                        } else if (removedObjects.contains(change.getKey())) {
                            remove = true;
                            changesWithRemovedKeys.add(new ObjectChange(change.getCause(), change.getAffectedObject(), change.getFieldName(), change.getTypeOfChange(), change.getOldValue(), change.getNewValue(), change.getSequenceNumber(), null));
                        } else {
                            remove = false;
                        }
                        if (!remove) continue;
                        if (useIteratorDotRemove) {
                            iterator2.remove();
                        } else {
                            changesSet.remove(change);
                        }
                        change.removeYou();
                    }
                    finished = true;
                }
                catch (ConcurrentModificationException e) {
                    useIteratorDotRemove = true;
                }
            }
            removedObjects.clear();
            changesSet.addAll(changesWithRemovedKeys);
        }
    }

    public static class ReverseComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return -((Comparable)o1).compareTo(o2);
        }
    }

    public static class SortForCompact
    implements Comparator {
        public int compare(Object o1, Object o2) {
            ObjectChange change1 = (ObjectChange)o1;
            ObjectChange change2 = (ObjectChange)o2;
            if (change1 == change2) {
                return 0;
            }
            if (change1.getAffectedObject() != change2.getAffectedObject()) {
                int cmp = change1.getAffectedObject().hashCode() - change2.getAffectedObject().hashCode();
                if (cmp != 0) {
                    return cmp;
                }
                String id1 = change1.getAffectedObject().getRepository().getIdForObject(change1.getAffectedObject());
                String id2 = change1.getAffectedObject().getRepository().getIdForObject(change2.getAffectedObject());
                int n = id1 != null ? (id2 == null ? 1 : id1.compareTo(id2)) : (cmp = id1 == id2 ? 0 : -1);
                if (cmp != 0) {
                    return cmp;
                }
                throw new RuntimeException("Two object are not the same but have equal ids!");
            }
            if (change1.getFieldName() != null && !change1.getFieldName().equals(change2.getFieldName())) {
                if (change2.getFieldName() == null) {
                    return 1;
                }
                return change1.getFieldName().compareTo(change2.getFieldName());
            }
            if (change1.getFieldName() == null && change2.getFieldName() != null) {
                if (change1.getFieldName() == null) {
                    return -1;
                }
                return -change2.getFieldName().compareTo(change1.getFieldName());
            }
            if (change1.getKey() != change2.getKey()) {
                if (change1.getKey() == null) {
                    return -1;
                }
                if (change2.getKey() == null) {
                    return 1;
                }
                if (!change1.getKey().equals(change2.getKey())) {
                    if (change1.getKey() instanceof String && change2.getKey() instanceof String) {
                        return ((String)change1.getKey()).compareTo((String)change2.getKey());
                    }
                    int cmp = change1.hashCode() - change2.hashCode();
                    if (cmp != 0) {
                        return cmp;
                    }
                    System.err.println("cannot handle keys in " + change1 + " and " + change2);
                    return 1;
                }
            }
            if (change1.getSequenceNumber() != change2.getSequenceNumber()) {
                return change1.getSequenceNumber().compareTo(change2.getSequenceNumber());
            }
            throw new RuntimeException("Two changes that are not the same have the same sequencenumber!");
        }
    }
}

