/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote;

import de.tu_bs.coobra.remote.ClientRepositoryHelper;
import de.tu_bs.coobra.remote.ClientRepositoryImpl;
import de.tu_bs.coobra.remote.ClientRepositoryOperations;
import de.tu_bs.coobra.remote.ServerRepository;
import de.tu_bs.coobra.remote.ServerRepositoryOperations;
import de.tu_bs.coobra.remote.errors.GeneralException;
import de.tu_bs.coobra.remote.lightweight.LightWeightServer;
import de.upb.tools.fca.FHashMap;
import java.io.IOException;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class RemoteRepository {
    private ServerRepositoryOperations serverRepository;
    private Map checkinListeners;
    private String[] orbArgs = null;

    public RemoteRepository(ServerRepositoryOperations serverRepository) {
        if (serverRepository == null) {
            throw new NullPointerException();
        }
        this.serverRepository = serverRepository;
    }

    public ServerRepositoryOperations getServerRepository() {
        return this.serverRepository;
    }

    public void addToCheckinListeners(ClientRepositoryOperations listener) {
        if (listener != null) {
            if (this.checkinListeners == null) {
                this.checkinListeners = new FHashMap();
            }
            if (!this.checkinListeners.containsKey(listener)) {
                if (this.serverRepository instanceof ServerRepository) {
                    if (!(listener instanceof ClientRepositoryImpl)) {
                        ClientRepositoryImpl client = new ClientRepositoryImpl(this.serverRepository);
                        try {
                            ORB orb = ORB.init((String[])this.orbArgs, null);
                            POA rootpoa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
                            rootpoa.the_POAManager().activate();
                            Object objref = rootpoa.servant_to_reference((Servant)client);
                            ClientRepositoryHelper.narrow(objref);
                            client.setCheckinListener(listener);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        this.checkinListeners.put(listener, client);
                    }
                } else {
                    int listenerID = this.serverRepository.addToCheckinListeners(listener);
                    this.checkinListeners.put(listener, new Integer(listenerID));
                }
            }
        }
    }

    public void removeFromCheckinListeners(ClientRepositoryOperations listener) {
        java.lang.Object client;
        if (this.checkinListeners != null && (client = this.checkinListeners.get(listener)) != null) {
            if (client instanceof ClientRepositoryImpl) {
                ((ClientRepositoryImpl)client).removeYou();
            } else {
                this.serverRepository.removeFromCheckinListeners((Integer)client);
            }
            this.checkinListeners.remove(listener);
        }
    }

    public String update(String lastKnownSequenceNumber) throws GeneralException, IOException {
        return this.serverRepository.update(lastKnownSequenceNumber);
    }

    public String checkin(String changes, String lastKnownSequenceNumber) throws GeneralException, IOException {
        return this.serverRepository.checkin(changes, lastKnownSequenceNumber);
    }

    public String getNewObjectId() {
        return this.serverRepository.getNewObjectId();
    }

    public String getServerIdentifier() {
        return this.serverRepository.getServerIdentifier();
    }

    public void rollback(String toSequenceNumber) throws GeneralException {
        if (!(this.serverRepository instanceof LightWeightServer)) {
            throw new UnsupportedOperationException("only lightweight servers support rollback at this time");
        }
        ((LightWeightServer)this.serverRepository).rollback(toSequenceNumber);
    }
}

