/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeAware;
import de.tu_bs.coobra.ObjectChangeAwareHelper;
import de.tu_bs.coobra.ObjectChangeCause;
import de.tu_bs.coobra.ObjectChangeStringCause;
import de.tu_bs.coobra.ObjectChangeUtils;
import de.tu_bs.coobra.errors.UndoRedoException;
import de.tu_bs.coobra.remote.ClientRepository;
import de.tu_bs.coobra.remote.ClientRepositoryOperations;
import de.tu_bs.coobra.remote.ServerRepository;
import de.tu_bs.coobra.remote.ServerRepositoryHelper;
import de.tu_bs.coobra.remote.ServerRepositoryPOA;
import de.tu_bs.coobra.remote.errors.GeneralException;
import de.tu_bs.coobra.remote.errors.RuntimeGeneralException;
import de.tu_bs.xmlreflect.XMLReflect;
import de.upb.tools.fca.FTreeMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class ServerRepositoryImpl
extends ServerRepositoryPOA {
    private LocalServerRepository repository;
    private ObjectChangeCause CHECKIN_CAUSE = ObjectChangeAwareHelper.CAUSE_UNDOREDO;
    private int nextListenerID = 0;
    private Map checkinListeners;
    private POA poa;

    public ServerRepositoryImpl() {
        this.repository = new LocalServerRepository();
    }

    public ServerRepositoryImpl(InputStream in) throws IOException, JDOMException {
        this.repository = new LocalServerRepository(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkin(String changes, String lastKnownSequenceNumber) throws GeneralException {
        try {
            Element xml;
            if (new BigInteger(lastKnownSequenceNumber).add(BigInteger.ONE).compareTo(this.repository.peekNextSequenceNumber()) > 0) {
                throw new RuntimeGeneralException("BADSEQUENCE", lastKnownSequenceNumber + " > " + this.repository.peekNextSequenceNumber().subtract(BigInteger.ONE));
            }
            if (!new BigInteger(lastKnownSequenceNumber).add(BigInteger.ONE).equals(this.repository.peekNextSequenceNumber())) {
                throw new RuntimeGeneralException("NOTUPDATED", lastKnownSequenceNumber + " < " + this.repository.peekNextSequenceNumber().subtract(BigInteger.ONE));
            }
            System.out.println("checkin xml with " + changes.length() + " characters\n");
            SAXBuilder sbuild = new SAXBuilder();
            try {
                Document doc = sbuild.build((Reader)new StringReader(changes));
                xml = doc.getRootElement();
            }
            catch (JDOMException e) {
                e.printStackTrace();
                throw new RuntimeGeneralException("BADFORMAT", e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeGeneralException("RESTOREEXCEPTION", e.getMessage());
            }
            this.repository.nextCheckinSequenceNumber = this.repository.peekNextSequenceNumber();
            TreeSet changesList = new TreeSet(ObjectChangeUtils.get().reverseComparator);
            ObjectChange.pushCause(this.CHECKIN_CAUSE);
            try {
                try {
                    this.repository.changesFromXml(xml, changesList, this.repository.new LocalRepository.CoObRAsXMLReflect());
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw new RuntimeGeneralException("RESTOREEXCEPTION", e.getMessage());
                }
            }
            finally {
                ObjectChange.popCause(this.CHECKIN_CAUSE);
            }
            ObjectChange.pushCause(LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
            try {
                this.repository.checkinCause = new ObjectChangeStringCause("checkin@" + this.repository.nextCheckinSequenceNumber);
                Iterator it = changesList.iterator();
                while (it.hasNext()) {
                    ObjectChange change = (ObjectChange)it.next();
                    try {
                        this.repository.redo(change, false);
                    }
                    catch (UndoRedoException e) {
                        System.err.println("Data Corrupted!");
                        e.printStackTrace();
                        throw new RuntimeGeneralException("BADSEMANTICS", e.getMessage());
                    }
                    this.repository.addToChanges(change);
                }
            }
            finally {
                ObjectChange.popCause(LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
            }
            this.repository.setNextSequenceNumber(this.repository.nextCheckinSequenceNumber);
            this.notifyCheckinListeners();
            return "" + this.repository.peekNextSequenceNumber().subtract(BigInteger.ONE);
        }
        catch (RuntimeGeneralException e) {
            e.getGeneralException().printStackTrace();
            throw e.getGeneralException();
        }
        catch (RuntimeException e) {
            System.err.println("Data Corrupted?!");
            e.printStackTrace();
            throw new RuntimeGeneralException("UNKNOWN", e.getMessage()).getGeneralException();
        }
    }

    public String getNewObjectId() {
        String id = this.repository.getNewObjectId();
        return id;
    }

    public String update(String lastKnownSequenceNumber) throws GeneralException {
        try {
            BigInteger sn = new BigInteger(lastKnownSequenceNumber).add(BigInteger.ONE);
            System.out.println("update from " + sn);
            LocalRepository.CoObRAsXMLReflect xr = this.repository.new LocalRepository.CoObRAsXMLReflect();
            Element changesXml = new Element("changes");
            throw new RuntimeException("not implemented");
        }
        catch (RuntimeGeneralException e) {
            e.getGeneralException().printStackTrace();
            throw e.getGeneralException();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeGeneralException("UNKNOWN", e.getMessage()).getGeneralException();
        }
    }

    public String getServerIdentifier() {
        return this.repository.getServerIdentifier();
    }

    public int addToCheckinListeners(ClientRepositoryOperations listener) {
        if (listener != null) {
            Integer key;
            if (this.checkinListeners == null) {
                this.checkinListeners = new FTreeMap();
            }
            int firstListenerID = this.nextListenerID;
            int id = this.nextListenerID++;
            while (this.checkinListeners.containsKey(key = new Integer(id))) {
                ++this.nextListenerID;
                if (this.nextListenerID >= Integer.MAX_VALUE) {
                    this.nextListenerID = 0;
                }
                if (this.nextListenerID != firstListenerID) continue;
                throw new RuntimeException("Too many listeners!");
            }
            this.checkinListeners.put(key, listener);
            return id;
        }
        return -1;
    }

    public void removeFromCheckinListeners(int additionID) {
        this.checkinListeners.remove(new Integer(additionID));
    }

    private void notifyCheckinListeners() {
        if (this.checkinListeners != null) {
            Iterator it = this.checkinListeners.keySet().iterator();
            while (it.hasNext()) {
                java.lang.Object key = it.next();
                ClientRepository l = (ClientRepository)this.checkinListeners.get(key);
                try {
                    l.notifyCheckin();
                }
                catch (Exception e) {
                    System.err.println("ERROR: While notifying client - client removed from listeners: " + e);
                    e.printStackTrace();
                    this.checkinListeners.remove(key);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            ServerRepositoryImpl.run()._orb().run();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace(System.out);
        }
    }

    public static ServerRepositoryImpl run(String nameServer, String nameServerPort, String repositoryName) throws Exception {
        return ServerRepositoryImpl.run(nameServer, nameServerPort, repositoryName, null);
    }

    public static ServerRepositoryImpl run(String nameServer, String nameServerPort, String repositoryName, String[] orbArgs) throws Exception {
        return ServerRepositoryImpl.run(nameServer, nameServerPort, repositoryName, orbArgs, null);
    }

    public static ServerRepositoryImpl run(String nameServer, String nameServerPort, String repositoryName, String[] orbArgs, InputStream in) throws Exception {
        NamingContextExt ncRef;
        Properties props = new Properties();
        if (nameServer == null) {
            nameServer = "localhost";
        }
        if (nameServerPort != null) {
            props.put("org.omg.CORBA.ORBInitRef", "NameService=corbaloc::" + nameServer + ":" + nameServerPort);
        }
        ORB orb = ORB.init((String[])orbArgs, (Properties)props);
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        ServerRepositoryImpl impl = in != null ? new ServerRepositoryImpl(in) : new ServerRepositoryImpl();
        impl.poa = poa;
        Object objref = poa.servant_to_reference((Servant)impl);
        ServerRepository ref = ServerRepositoryHelper.narrow(objref);
        try {
            Object objRef = orb.resolve_initial_references("NameService");
            ncRef = NamingContextExtHelper.narrow((Object)objRef);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to resolve NameService!", e);
        }
        NameComponent[] path = ncRef.to_name(repositoryName);
        ncRef.rebind(path, (Object)ref);
        System.out.println("Server " + repositoryName + " ready and waiting ...");
        return impl;
    }

    public static ServerRepositoryImpl run() throws Exception {
        return ServerRepositoryImpl.run(null);
    }

    public static ServerRepositoryImpl run(String[] orbArgs) throws Exception {
        return ServerRepositoryImpl.run(orbArgs, null);
    }

    public static ServerRepositoryImpl run(String[] orbArgs, InputStream in) throws Exception {
        ORB orb = ORB.init((String[])orbArgs, null);
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        ServerRepositoryImpl impl = in != null ? new ServerRepositoryImpl(in) : new ServerRepositoryImpl();
        impl.poa = poa;
        Object objref = poa.servant_to_reference((Servant)impl);
        ServerRepository ref = ServerRepositoryHelper.narrow(objref);
        System.out.println("Server ready and waiting ...");
        System.out.println(orb.object_to_string((Object)ref));
        new Thread(new ORBRunner(orb)).start();
        return impl;
    }

    public LocalRepository getLocalRepository() {
        return this.repository;
    }

    public void deactivate() {
        try {
            this.poa.deactivate_object(this.poa.servant_to_id((Servant)this));
        }
        catch (ServantNotActive e) {
            e.printStackTrace();
        }
        catch (ObjectNotActive e) {
            e.printStackTrace();
        }
        catch (WrongPolicy e) {
            e.printStackTrace();
        }
    }

    static class ORBRunner
    implements Runnable {
        ORB orb;

        ORBRunner(ORB orb) {
            this.orb = orb;
        }

        public void run() {
            this.orb.run();
        }
    }

    protected class LocalServerRepository
    extends LocalRepository {
        String generatedServerIdentifier;
        BigInteger nextCheckinSequenceNumber;
        ObjectChangeCause checkinCause;

        public boolean isServerRepository() {
            return true;
        }

        public LocalServerRepository() {
            this.nextCheckinSequenceNumber = BigInteger.ZERO;
        }

        public LocalServerRepository(InputStream in) throws IOException, JDOMException {
            super(in);
            this.nextCheckinSequenceNumber = BigInteger.ZERO;
            if (this.iteratorOfChangesBase().hasNext()) {
                throw new RuntimeException("Server may not have changes in the changes base!");
            }
        }

        protected String getNewObjectId() {
            if (this.isRestoring()) {
                throw new RuntimeException("Hey! They are object ids created on restore!");
            }
            String id = "server#" + this.nextObjectId;
            this.nextObjectId = this.nextObjectId.add(BigInteger.ONE);
            this.addToKnownIds(id, null);
            return id;
        }

        public String getServerIdentifier() {
            String id = super.getServerIdentifier();
            if (id == null) {
                id = this.generatedServerIdentifier;
            }
            if (id == null) {
                id = this.generatedServerIdentifier = Long.toHexString(new Random().nextLong());
            }
            return id;
        }

        protected ObjectChangeAware createObjectInstance(Class objectClass, String id, LocalRepository.CoObRAsXMLReflect xmlReflectForValues) {
            String className;
            if (id.startsWith("singleton#") && XMLReflect.getFromSingletons((Class)XMLReflect.getClassForStoredName((String)(className = id.substring("singleton#".length(), id.length())), (ClassLoader)this.getClassLoader())) == null) {
                throw new RuntimeGeneralException("NOSERVERID", id);
            }
            if (!this.hasInKnownIds(id) && !this.isRestoring()) {
                throw new RuntimeGeneralException("NOSERVERID", id);
            }
            if (this.isRestoring() && !id.startsWith("server")) {
                throw new RuntimeException("Unsupported ids in restored repository!");
            }
            return super.createObjectInstance(objectClass, id, xmlReflectForValues);
        }

        protected BigInteger getSequenceNumberForStoredChange(String numberString) {
            if (this.isRestoring()) {
                return super.getSequenceNumberForStoredChange(numberString);
            }
            BigInteger sn = this.nextCheckinSequenceNumber;
            this.nextCheckinSequenceNumber = this.nextCheckinSequenceNumber.add(BigInteger.ONE);
            return sn;
        }

        BigInteger peekNextSequenceNumber() {
            return this.nextSequenceNumber;
        }

        void setNextSequenceNumber(BigInteger nextSequenceNumber) {
            this.nextSequenceNumber = nextSequenceNumber;
        }

        protected ObjectChangeCause getCauseForStoredChange(Element causeXml, LocalRepository.CoObRAsXMLReflect xmlReflectForValues) {
            if (this.isRestoring()) {
                return super.getCauseForStoredChange(causeXml, xmlReflectForValues);
            }
            return this.checkinCause;
        }

        public void changesFromXml(Element xml, Collection changes, LocalRepository.CoObRAsXMLReflect xmlReflectForValues) {
            throw new RuntimeException("not yet implemented!");
        }

        public void redo(ObjectChange change, boolean checkOnly) {
            super.redo(change, checkOnly);
        }

        public void changesToXML(Writer writer, Iterator iteratorOfChanges, LocalRepository.CoObRAsXMLReflect xmlReflectForValues, boolean isBase, LocalRepository.ProgressHandler handler) throws IOException {
            super.changesToXML(writer, iteratorOfChanges, xmlReflectForValues, isBase, handler);
        }

        public void removeYou() {
            ServerRepositoryImpl.this.deactivate();
            super.removeYou();
        }
    }
}

