/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote.lightweight;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class LightWeightNameService {
    private ServerSocket serverSocket;
    public static final int DEFAULT_PORT = 1900;
    public static final String COMMAND_ANNOUNCE = "ANNOUNCE";
    public static final String COMMAND_QUERY = "QUERY";
    public static final String RESPONSE_FAILURE = "FAILURE";
    public static final String RESPONSE_SUCCESS = "SUCCESS";
    public static final String RESPONSE_DATA = "DATA";
    public static final String FAILURE_SERVICE_NOT_FOUND = "service not found";
    private Map services = new TreeMap();
    private ServerSocketListeneningThread serverThread = new ServerSocketListeneningThread();
    String filename;
    static Random random = new Random();

    public LightWeightNameService(int port) {
        try {
            this.serverSocket = new ServerSocket(port);
            this.serverThread.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightWeightNameService(int port, String filename) {
        this(port);
        this.filename = filename;
        try {
            this.restore();
        }
        catch (IOException e) {
            LightWeightNameService.error("Restore failed");
            e.printStackTrace();
            Map map = this.services;
            synchronized (map) {
                this.services.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        if (this.filename != null) {
            Map map = this.services;
            synchronized (map) {
                OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(this.filename));
                Iterator it = this.services.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String name = (String)entry.getKey();
                    ServiceInfo info = (ServiceInfo)entry.getValue();
                    writer.write("SERVICE\n");
                    writer.write(name + "\n");
                    writer.write(info.getHost() + "\n");
                    writer.write(info.getPort() + "\n");
                }
                ((Writer)writer).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restore() throws IOException {
        if (!new File(this.filename).exists()) return;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.filename)));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!"SERVICE".equals(line)) throw new RuntimeException("wrong file format: " + this.filename);
                String name = reader.readLine();
                String host = reader.readLine();
                String port = reader.readLine();
                if (name != null && host != null && port != null) {
                    ServiceInfo info = new ServiceInfo(host, port);
                    Map map = this.services;
                    synchronized (map) {
                        this.services.put(name, info);
                        continue;
                    }
                }
                LightWeightNameService.error("discarded incomplete dataset on restore!");
            }
            return;
        }
        finally {
            reader.close();
        }
    }

    public static void main(String[] args) {
        block10: {
            if (args.length == 0) {
                new LightWeightNameService(1900, "repository.names");
            } else if (args.length == 1) {
                try {
                    String nameserver;
                    String repositoryName = args[0];
                    int indexOfColon = repositoryName.indexOf(58);
                    if (indexOfColon > 0) {
                        nameserver = repositoryName.substring(0, indexOfColon);
                        repositoryName = repositoryName.substring(indexOfColon + 1);
                    } else {
                        nameserver = "localhost";
                    }
                    ServiceInfo info = LightWeightNameService.query(nameserver, 1900, repositoryName);
                    System.out.println(info.getHost() + ":" + info.getPort());
                    System.exit(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (RuntimeException e) {
                    if (FAILURE_SERVICE_NOT_FOUND.equals(e.getMessage())) {
                        System.err.println("not found");
                        System.exit(0);
                        break block10;
                    }
                    e.printStackTrace();
                    System.exit(1);
                }
            } else {
                System.err.println("parameters: [repository name to query]");
                System.exit(2);
            }
        }
    }

    public static void announce(String nameServerHost, int nameServerPort, String name, ServiceInfo serviceInfo) throws IOException {
        Socket socket = new Socket(nameServerHost, nameServerPort);
        socket.setSoTimeout(10000);
        OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream());
        writer.write("ANNOUNCE\n");
        writer.write(name + "\n");
        writer.write(serviceInfo.host + "\n");
        writer.write(serviceInfo.port + "\n");
        ((Writer)writer).flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String response = reader.readLine();
        if (!RESPONSE_SUCCESS.equals(response)) {
            throw new RuntimeException("Registering service failed: " + reader.readLine());
        }
    }

    public static ServiceInfo query(String nameServerHost, int nameServerPort, String name) throws IOException {
        Socket socket = new Socket(nameServerHost, nameServerPort);
        socket.setSoTimeout(10000);
        OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream());
        writer.write("QUERY\n");
        writer.write(name + "\n");
        ((Writer)writer).flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String response = reader.readLine();
        if (RESPONSE_DATA.equals(response)) {
            String host = reader.readLine();
            String port = reader.readLine();
            return new ServiceInfo(host, port);
        }
        throw new RuntimeException(reader.readLine());
    }

    public void shutdown() {
        this.serverThread.interrupt();
    }

    protected static void log(String message) {
        System.out.println(new Date() + ": " + message);
    }

    protected static void error(String message) {
        System.err.println(new Date() + ": " + message);
    }

    protected class ClientSocketProcessor
    extends Thread {
        Socket socket;

        public ClientSocketProcessor(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputStream in = this.socket.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                LightWeightNameService.log("reading command:");
                String command = reader.readLine();
                LightWeightNameService.log(command);
                if (LightWeightNameService.COMMAND_ANNOUNCE.equals(command) || LightWeightNameService.COMMAND_QUERY.equals(command)) {
                    LightWeightNameService.log("reading name:");
                    String name = reader.readLine();
                    LightWeightNameService.log(name);
                    if (name != null) {
                        if (LightWeightNameService.COMMAND_ANNOUNCE.equals(command)) {
                            LightWeightNameService.log("reading host:");
                            String host = reader.readLine();
                            LightWeightNameService.log(host);
                            LightWeightNameService.log("reading port:");
                            String port = reader.readLine();
                            LightWeightNameService.log(port);
                            ServiceInfo info = new ServiceInfo(host, port);
                            if (info.getHost() == null || info.getPort() == null) {
                                this.respond(LightWeightNameService.RESPONSE_FAILURE, "host and/or port missing");
                            } else if (!this.isAllowedToAnnounce(this.socket.getInetAddress().getHostAddress())) {
                                this.respond(LightWeightNameService.RESPONSE_FAILURE, "access denied");
                            } else {
                                Map map = LightWeightNameService.this.services;
                                synchronized (map) {
                                    Iterator it = LightWeightNameService.this.services.values().iterator();
                                    while (it.hasNext()) {
                                        ServiceInfo currentInfo = (ServiceInfo)it.next();
                                        if (!currentInfo.port.equals(info.port) || !currentInfo.host.equals(info.host)) continue;
                                        it.remove();
                                    }
                                    LightWeightNameService.this.services.put(name, info);
                                }
                                try {
                                    LightWeightNameService.this.store();
                                }
                                catch (IOException e) {
                                    LightWeightNameService.error("store failed:");
                                    e.printStackTrace();
                                }
                                this.respond(LightWeightNameService.RESPONSE_SUCCESS, null);
                            }
                        } else {
                            ServiceInfo info = (ServiceInfo)LightWeightNameService.this.services.get(name);
                            if (info != null) {
                                this.respond(LightWeightNameService.RESPONSE_DATA, info.getHost() + "\n" + info.getPort());
                            } else {
                                this.respond(LightWeightNameService.RESPONSE_FAILURE, LightWeightNameService.FAILURE_SERVICE_NOT_FOUND);
                            }
                        }
                    } else {
                        this.respond(LightWeightNameService.RESPONSE_FAILURE, "no name received");
                    }
                } else {
                    LightWeightNameService.error("Unknown command: '" + command + "' from " + this.socket.getInetAddress());
                    this.respond(LightWeightNameService.RESPONSE_FAILURE, "Unkown command: '" + command + "'");
                }
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (!this.socket.isClosed()) {
                        this.socket.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }

        private boolean isAllowedToAnnounce(String hostAddress) {
            boolean isLocalhost;
            boolean bl = isLocalhost = "127.0.0.1".equals(hostAddress) || this.socket.getLocalAddress().getHostAddress().equals(hostAddress);
            if (isLocalhost) {
                return true;
            }
            String subNet = this.socket.getLocalAddress().getHostAddress();
            subNet = subNet.substring(0, subNet.lastIndexOf(46));
            boolean isInMySubNet = hostAddress.startsWith(subNet);
            return isInMySubNet;
        }

        private void respond(String response, String data) throws IOException {
            OutputStreamWriter writer = new OutputStreamWriter(this.socket.getOutputStream());
            writer.write(response + "\n");
            if (data != null) {
                writer.write(data + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    public static class ServiceInfo {
        private String host;
        private String port;

        public ServiceInfo(String host, String port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }
    }

    private class ServerSocketListeneningThread
    extends Thread {
        private ServerSocketListeneningThread() {
        }

        public void run() {
            try {
                LightWeightNameService.this.serverSocket.setSoTimeout(1000);
                while (!this.isInterrupted()) {
                    try {
                        Socket socket = LightWeightNameService.this.serverSocket.accept();
                        LightWeightNameService.log("accepted connection");
                        LightWeightNameService.log("client: " + socket.getInetAddress().getHostAddress());
                        socket.setSoTimeout(30000);
                        this.process(socket);
                    }
                    catch (SocketTimeoutException e) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void process(Socket socket) {
            new ClientSocketProcessor(socket).start();
        }
    }
}

