/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote.lightweight;

import de.tu_bs.coobra.remote.ClientRepositoryOperations;
import de.tu_bs.coobra.remote.ServerRepositoryOperations;
import de.tu_bs.coobra.remote.errors.GeneralException;
import de.tu_bs.coobra.remote.lightweight.LightWeightNameService;
import de.tu_bs.coobra.remote.lightweight.LightWeightServerImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class LightWeightServer
implements ServerRepositoryOperations {
    private String login;
    private String password;
    private CheckinListenerThread checkinListenerThread;
    private int nextListenerID = 0;
    private Map checkinListeners;
    private String host;
    private int port;
    public static final int NUMBER_OF_IDS_TO_RETRIEVE_AT_ONCE = 100;
    private List serverIds;
    public static final int TIME_OUT = 60000;

    public LightWeightServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public LightWeightServer(String host, int port, String login, String password) {
        this(host, port);
        this.login(login, password);
    }

    public void login(String user, String password) {
        this.login = user;
        this.password = password;
    }

    private void sendLogin(Writer writer) throws IOException {
        if (this.login != null) {
            writer.write("LOGIN\n");
            writer.write(this.login + "\n");
            if (this.password != null) {
                writer.write(this.password + "\n");
            } else {
                writer.write("\n");
            }
        }
    }

    protected GZIPOutputStream getOutputStream(Socket socket) throws IOException {
        return new GZIPOutputStream(new LightWeightServerImpl.NotClosableOutputStream(socket.getOutputStream()));
    }

    private InputStream getInputStream(Socket socket) throws IOException {
        return this.getInputStream(socket, true);
    }

    private InputStream getInputStream(Socket socket, boolean decompress) throws IOException {
        if (decompress) {
            return new GZIPInputStream(socket.getInputStream());
        }
        return socket.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addToCheckinListeners(ClientRepositoryOperations listener) {
        if (listener != null) {
            if (this.checkinListenerThread == null || !this.checkinListenerThread.isAlive() || this.checkinListenerThread.isInterrupted()) {
                this.reconnect();
            }
            if (this.checkinListeners == null) {
                this.checkinListeners = new TreeMap();
            }
            int firstListenerID = this.nextListenerID;
            int id = this.nextListenerID++;
            Map map = this.checkinListeners;
            synchronized (map) {
                Integer key;
                while (this.checkinListeners.containsKey(key = new Integer(id))) {
                    ++this.nextListenerID;
                    if (this.nextListenerID >= Integer.MAX_VALUE) {
                        this.nextListenerID = 0;
                    }
                    if (this.nextListenerID != firstListenerID) continue;
                    throw new RuntimeException("Too many listeners!");
                }
                this.checkinListeners.put(key, listener);
            }
            return id;
        }
        return -1;
    }

    private void reconnect() {
        if (this.checkinListenerThread != null && this.checkinListenerThread.isAlive() && !this.checkinListenerThread.isInterrupted()) {
            this.checkinListenerThread.interrupt();
        }
        this.checkinListenerThread = new CheckinListenerThread();
        this.checkinListenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCheckinListeners(int additionID) {
        if (this.checkinListeners != null) {
            Map map = this.checkinListeners;
            synchronized (map) {
                this.checkinListeners.remove(new Integer(additionID));
                if (this.checkinListeners.isEmpty()) {
                    this.checkinListenerThread.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCheckinListeners(boolean disconnect) {
        if (this.checkinListeners != null) {
            Map map = this.checkinListeners;
            synchronized (map) {
                Iterator it = this.checkinListeners.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    ClientRepositoryOperations l = (ClientRepositoryOperations)this.checkinListeners.get(key);
                    try {
                        if (disconnect) {
                            l.notifyDisconnect();
                            continue;
                        }
                        l.notifyCheckin();
                    }
                    catch (Exception e) {
                        System.err.println("ERROR: While notifying client - client removed from listeners: " + e);
                        e.printStackTrace();
                        this.checkinListeners.remove(key);
                    }
                }
            }
        }
    }

    public String checkin(String changes, String lastKnownSequenceNumber) throws GeneralException, IOException {
        Socket socket = new Socket(this.host, this.port);
        OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(socket));
        this.sendLogin(writer);
        writer.write("CHECKIN\n");
        writer.write(lastKnownSequenceNumber.toString() + "\n");
        writer.write(changes);
        ((Writer)writer).close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(socket)));
        try {
            String response = reader.readLine();
            String message = reader.readLine();
            socket.close();
            if ("DATA".equals(response)) {
                String string = message;
                return string;
            }
            if ("UPDATEFIRST".equals(response)) {
                throw new GeneralException("NOTUPDATED");
            }
            throw new GeneralException(response + (message != null ? ": " + message : ""));
        }
        finally {
            reader.close();
        }
    }

    public void rollback(String toSequenceNumber) throws GeneralException {
        block4: {
            try {
                Socket socket = new Socket(this.host, this.port);
                OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(socket));
                this.sendLogin(writer);
                writer.write("ROLLBACKTO\n");
                writer.write(toSequenceNumber.toString() + "\n");
                ((Writer)writer).close();
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(socket)));
                String response = reader.readLine();
                String message = reader.readLine();
                socket.close();
                if ("DATA".equals(response)) {
                    if (!toSequenceNumber.equals(message)) {
                        throw new RuntimeException("Returned last known sequence number does not match rollback sequence number!");
                    }
                    break block4;
                }
                throw new GeneralException(response + (message != null ? ": " + message : ""));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean shutdown() throws GeneralException {
        try {
            Socket socket = new Socket(this.host, this.port);
            OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(socket));
            this.sendLogin(writer);
            writer.write("SHUTDOWN\n");
            ((Writer)writer).close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(socket)));
            String response = reader.readLine();
            String message = reader.readLine();
            socket.close();
            if ("SUCCESS".equals(response)) {
                return true;
            }
            if ("FAILURE".equals(response)) {
                throw new GeneralException(response + (message != null ? ": " + message : ""));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public synchronized String getNewObjectId() {
        block8: {
            if (this.serverIds == null) {
                this.serverIds = new LinkedList();
            }
            if (this.serverIds.isEmpty()) {
                try {
                    Socket socket = new Socket(this.host, this.port);
                    OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(socket));
                    this.sendLogin(writer);
                    writer.write("GETNEWOBJECTID\n");
                    writer.write("100\n");
                    ((Writer)writer).close();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(socket)));
                    String response = reader.readLine();
                    String message = reader.readLine();
                    socket.close();
                    if ("DATA".equals(response)) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.startsWith("server#")) {
                                this.serverIds.add(line);
                                continue;
                            }
                            System.err.println("received invalid server id: " + line);
                        }
                        break block8;
                    }
                    throw new RuntimeException("get new object id failed: " + message);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!this.serverIds.isEmpty()) {
            return (String)this.serverIds.remove(0);
        }
        throw new RuntimeException("get new object id failed: no ids received");
    }

    public String getServerIdentifier() {
        try {
            Socket socket = new Socket(this.host, this.port);
            socket.setSoTimeout(60000);
            OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(socket));
            this.sendLogin(writer);
            writer.write("GETSERVERID\n");
            ((Writer)writer).close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(socket)));
            String response = reader.readLine();
            String message = reader.readLine();
            socket.close();
            if ("DATA".equals(response)) {
                return message;
            }
            throw new RuntimeException("getting server identifier failed: " + message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String update(String lastKnownSequenceNumber) throws GeneralException, IOException {
        Socket socket = new Socket(this.host, this.port);
        socket.setSoTimeout(60000);
        OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(socket));
        this.sendLogin(writer);
        writer.write("UPDATE\n");
        writer.write(lastKnownSequenceNumber.toString() + "\n");
        ((Writer)writer).close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(socket)));
        String response = reader.readLine();
        if ("DATA".equals(response)) {
            int read;
            StringBuffer result = new StringBuffer();
            int BUFFER_SIZE = 1024;
            char[] buffer = new char[1024];
            while ((read = reader.read(buffer, 0, 1024)) > -1) {
                result.append(buffer, 0, read);
            }
            socket.close();
            return result.toString();
        }
        String message = reader.readLine();
        throw new GeneralException(response + (message != null ? ": " + message : ""));
    }

    public Reader updateAsReader(String lastKnownSequenceNumber) throws GeneralException, IOException {
        Socket socket = new Socket(this.host, this.port);
        socket.setSoTimeout(60000);
        OutputStreamWriter writer = new OutputStreamWriter(this.getOutputStream(socket));
        this.sendLogin(writer);
        writer.write("UPDATE\n");
        writer.write(lastKnownSequenceNumber.toString() + "\n");
        ((Writer)writer).close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream(socket)));
        String response = reader.readLine();
        if ("DATA".equals(response)) {
            return reader;
        }
        String message = reader.readLine();
        throw new GeneralException(response + (message != null ? ": " + message : ""));
    }

    public static void main(String[] args) {
        block8: {
            try {
                if (args.length == 1) {
                    block7: {
                        String nameserver;
                        String repositoryName = args[0];
                        int indexOfColon = repositoryName.indexOf(58);
                        if (indexOfColon > 0) {
                            nameserver = repositoryName.substring(0, indexOfColon);
                            repositoryName = repositoryName.substring(indexOfColon + 1);
                        } else {
                            nameserver = "localhost";
                        }
                        LightWeightNameService.ServiceInfo info = LightWeightNameService.query(nameserver, 1900, repositoryName);
                        String host = info.getHost();
                        int port = Integer.parseInt(info.getPort());
                        LightWeightServer serverPinger = new LightWeightServer(host, port, "guest", "guest");
                        try {
                            serverPinger.getServerIdentifier();
                        }
                        catch (RuntimeException e) {
                            if (e.getMessage().indexOf("access to repository denied for user ") > 0 || e.getMessage().indexOf("authentication failed") > 0) break block7;
                            throw e;
                        }
                    }
                    System.exit(0);
                    break block8;
                }
                System.err.println("Specify repository name as only parameter!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.exit(1);
    }

    private class CheckinListenerThread
    extends Thread {
        private CheckinListenerThread() {
        }

        public void run() {
            try {
                String response;
                Socket socket = new Socket(LightWeightServer.this.host, LightWeightServer.this.port);
                socket.setSoTimeout(60000);
                OutputStreamWriter writer = new OutputStreamWriter(LightWeightServer.this.getOutputStream(socket));
                LightWeightServer.this.sendLogin(writer);
                writer.write("LISTEN\n");
                ((Writer)writer).close();
                BufferedReader reader = new BufferedReader(new InputStreamReader(LightWeightServer.this.getInputStream(socket, false)));
                do {
                    try {
                        while ((response = reader.readLine()) != null) {
                            if ("NOTIFY".equals(response)) {
                                if (this.isInterrupted()) continue;
                                LightWeightServer.this.notifyCheckinListeners(false);
                                continue;
                            }
                            System.err.println("error while listening to checkins, response was: " + response);
                        }
                        System.out.println("listening connection was closed");
                        LightWeightServer.this.reconnect();
                    }
                    catch (SocketTimeoutException e) {
                        response = "waiting for checkin notify";
                    }
                } while (response != null && !this.isInterrupted());
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                LightWeightServer.this.notifyCheckinListeners(true);
            }
        }
    }
}

