/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote.lightweight;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ObjectChangeStringCause;
import de.tu_bs.coobra.remote.lightweight.LightWeightNameService;
import de.tu_bs.xmlreflect.Link;
import de.tu_bs.xmlreflect.util.SAXHandlerStack;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LightWeightServerImpl {
    public static final String COMMAND_CHECKIN = "CHECKIN";
    public static final String COMMAND_ROLLBACK_TO = "ROLLBACKTO";
    public static final String COMMAND_UPDATE = "UPDATE";
    public static final String COMMAND_SHUTDOWN = "SHUTDOWN";
    public static final String COMMAND_GET_SERVER_ID = "GETSERVERID";
    public static final String COMMAND_GET_NEW_OBJECT_ID = "GETNEWOBJECTID";
    public static final String COMMAND_LISTEN = "LISTEN";
    public static final String RESPONSE_SUCCESS = "SUCCESS";
    public static final String RESPONSE_FAILURE = "FAILURE";
    public static final String RESPONSE_DATA = "DATA";
    public static final String RESPONSE_UPDATEFIRST = "UPDATEFIRST";
    public static final String RESPONSE_NOTIFY = "NOTIFY";
    private ServerSocket serverSocket;
    private ServerSocketListeneningThread serverThread = new ServerSocketListeneningThread();
    public static final String ERROR_SEQ_BELOW_MINUS_ONE = "last known sequence number below -1";
    public static final String ERROR_SEQ_LOW = "last known sequence number too small";
    public static final String ERROR_SEQ_HIGH = "last known sequence number too large!";
    public static final String ERROR_SEQ_FORMAT = "last known sequence number not readable";
    public static final String ERROR_SEQ_NULL = "no last known sequence number received";
    public static final String ERROR_WRITE_FILE_PREFIX = "Write to file failed: ";
    public static final String ERROR_UNKNOWN_COMMAND_PREFIX = "Unkown command: ";
    public static final String ERROR_NULL_AFFECTED_OBJECT = "affected object may not be null!";
    public static final String ERROR_XML_UNHANDLED_PREFIX = "Unhandled xml tag: ";
    public static final String ERROR_ID_NOT_KNOWN_PREFIX = "id not known: ";
    public static final String ERROR_INVALID_ID_PREFIX = "invalid id: ";
    public static final String ERROR_ID_ALREADY_IN_USE_PREFIX = "id used more than once: ";
    public static final String ERROR_OPERATION_IN_PROGRESS = "operation in progress";
    private SAXHandlerStack handlerStack;
    private int readLocks = 0;
    private boolean writeLock = false;
    private Set objectIds = new TreeSet();
    private BigInteger nextObjectNumber = BigInteger.ZERO;
    private String serverIdentifier = Long.toHexString(new Random().nextLong());
    private BigInteger lastKnownSequenceNumber = BigInteger.ZERO.subtract(BigInteger.ONE);
    private TreeMap changes = new TreeMap();
    private Map listeningSockets = new HashMap();
    private String documentHeader;
    private Map causes = new HashMap();
    private int checkinNr = 0;
    private StringFromXML stringFromXML;
    private XMLOutputter xMLOutputter;
    private static ServerFactory serverFactory;
    public static final int DEFAULT_PORT_RANGE_START = 27400;
    public static final int DEFAULT_PORT_RANGE_LENGTH = 100;
    Writer storage;
    private String repositoryName;

    public String getServerIdentifier() {
        return this.serverIdentifier;
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestReadLock() throws LockNotAvailableException {
        LightWeightServerImpl lightWeightServerImpl = this;
        synchronized (lightWeightServerImpl) {
            if (!this.writeLock) {
                ++this.readLocks;
            } else {
                throw new LockNotAvailableException();
            }
        }
        LightWeightServerImpl.log("read lock captured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestWriteLock() throws LockNotAvailableException {
        LightWeightServerImpl lightWeightServerImpl = this;
        synchronized (lightWeightServerImpl) {
            if (this.writeLock || this.readLocks != 0) {
                throw new LockNotAvailableException();
            }
            this.writeLock = true;
        }
        LightWeightServerImpl.log("write lock captured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseReadLock() {
        LightWeightServerImpl lightWeightServerImpl = this;
        synchronized (lightWeightServerImpl) {
            if (this.readLocks > 0) {
                --this.readLocks;
            } else {
                LightWeightServerImpl.log("Error: releasing read lock that was not requested!");
            }
        }
        LightWeightServerImpl.log("read lock released");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseWriteLock() {
        LightWeightServerImpl lightWeightServerImpl = this;
        synchronized (lightWeightServerImpl) {
            if (this.writeLock) {
                this.writeLock = false;
            } else {
                LightWeightServerImpl.log("Error: releasing write lock that was not requested!");
            }
        }
        LightWeightServerImpl.log("write lock released");
    }

    public void setServerIdentifier(String serverIdentifier) {
        this.serverIdentifier = serverIdentifier;
    }

    protected void process(Socket socket) throws IOException {
        new ClientSocketProcessor(socket).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToListeningSockets(Socket socket, Writer writer) {
        Map map = this.listeningSockets;
        synchronized (map) {
            LightWeightServerImpl.log("adding listening client " + socket.getInetAddress().getHostAddress());
            this.listeningSockets.put(socket, writer);
        }
    }

    private void notifyListeningSockets() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet listeningSocketsEntries;
                Map map = LightWeightServerImpl.this.listeningSockets;
                synchronized (map) {
                    listeningSocketsEntries = new HashSet(LightWeightServerImpl.this.listeningSockets.entrySet());
                }
                Iterator it = listeningSocketsEntries.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    Socket socket = (Socket)entry.getKey();
                    Writer writer = (Writer)entry.getValue();
                    try {
                        if (!socket.isClosed()) {
                            LightWeightServerImpl.log("notifying client at " + socket.getInetAddress().getHostAddress());
                            writer.write("NOTIFY\n");
                            writer.flush();
                            continue;
                        }
                        LightWeightServerImpl.log("removing client " + socket.toString() + " as connection was closed");
                        Map map2 = LightWeightServerImpl.this.listeningSockets;
                        synchronized (map2) {
                            LightWeightServerImpl.this.listeningSockets.remove(socket);
                        }
                    }
                    catch (IOException e) {
                        LightWeightServerImpl.error("error notifying client (removed): " + e.getMessage());
                        e.printStackTrace();
                        it.remove();
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(BigInteger lastKnownSequenceNumber, Writer writer) throws IOException, LockNotAvailableException {
        this.requestReadLock();
        try {
            writer.write("DATA\n");
            writer.write(this.getDocumentHeader());
            writer.write("<changes last=\"" + this.lastKnownSequenceNumber + "\">\n");
            BigInteger i = lastKnownSequenceNumber.add(BigInteger.ONE);
            while (i.compareTo(this.lastKnownSequenceNumber) <= 0) {
                LWObjectChange change = (LWObjectChange)this.changes.get(i);
                if (change != null) {
                    writer.write(this.changeToXML(change));
                    writer.write("\n");
                }
                i = i.add(BigInteger.ONE);
            }
            writer.write("</changes>\n");
            writer.flush();
        }
        finally {
            this.releaseReadLock();
        }
    }

    private String getDocumentHeader() {
        if (this.documentHeader == null) {
            CharArrayWriter out = new CharArrayWriter();
            try {
                new XMLOutputter().output(new Document(new Element("changes")), (Writer)out);
                this.documentHeader = out.toString();
                out.close();
                this.documentHeader = this.documentHeader.substring(0, this.documentHeader.indexOf("<changes") - 1);
            }
            catch (Exception e) {
                this.documentHeader = "<!-- failed to get document header: " + e + "-->";
            }
        }
        return this.documentHeader;
    }

    private void rollback(BigInteger sequenceNumber) throws IOException {
        LightWeightServerImpl.log("discarding changes greater than seq# " + sequenceNumber);
        Iterator it = this.changes.keySet().iterator();
        this.removeKeysGreaterThan(sequenceNumber, it);
        this.lastKnownSequenceNumber = sequenceNumber;
        this.store("<rollback number=\"" + sequenceNumber.toString() + "\"/>");
    }

    private void removeKeysGreaterThan(BigInteger sequenceNumber, Iterator it) {
        while (it.hasNext()) {
            BigInteger key = (BigInteger)it.next();
            if (sequenceNumber.compareTo(key) >= 0) continue;
            it.remove();
        }
    }

    protected void checkin(BufferedReader reader, ClientSocketProcessor processor) throws IOException, LockNotAvailableException {
        this.read(reader, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(BufferedReader reader, ClientSocketProcessor processor) throws IOException, LockNotAvailableException {
        block15: {
            this.requestWriteLock();
            try {
                try {
                    if (processor != null) {
                        this.setCheckinNr(this.getCheckinNr() + 1);
                    }
                    XMLReader xmlReader = LocalRepository.createXMLReader();
                    this.handlerStack = new SAXHandlerStack();
                    xmlReader.setContentHandler((ContentHandler)this.handlerStack);
                    xmlReader.setErrorHandler((ErrorHandler)this.handlerStack);
                    xmlReader.setEntityResolver((EntityResolver)this.handlerStack);
                    ChangesFromXML changesFromXML = new ChangesFromXML(processor == null, processor != null ? processor.getConnectionInfo() : "");
                    this.handlerStack.setHandlerForNextElements((DefaultHandler)changesFromXML);
                    xmlReader.parse(new InputSource(new NotClosableReader(reader)));
                    LightWeightServerImpl.log("received xml");
                    if (processor != null) {
                        try {
                            this.store(changesFromXML.getChanges().values().iterator());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            processor.respond(RESPONSE_FAILURE, ERROR_WRITE_FILE_PREFIX + e);
                            this.shutdown();
                        }
                    }
                    if (!this.serverThread.isInterrupted() && changesFromXML.getChanges().size() > 0) {
                        this.changes.putAll(changesFromXML.getChanges());
                        this.lastKnownSequenceNumber = (BigInteger)changesFromXML.getChanges().lastKey();
                        if (processor != null) {
                            processor.respond(RESPONSE_DATA, this.lastKnownSequenceNumber.toString());
                            this.notifyListeningSockets();
                        }
                    }
                }
                catch (SAXException e) {
                    if (e instanceof SAXParseException) {
                        SAXParseException saxParseException = (SAXParseException)e;
                        System.err.println("Error parsing line " + saxParseException.getLineNumber() + " column " + saxParseException.getColumnNumber());
                    }
                    if (processor != null) {
                        e.printStackTrace();
                        processor.respond(RESPONSE_FAILURE, e.toString());
                        break block15;
                    }
                    throw new RuntimeException(e);
                }
                catch (RuntimeException e) {
                    if (processor != null) {
                        e.printStackTrace();
                        processor.respond(RESPONSE_FAILURE, e.toString());
                        break block15;
                    }
                    throw e;
                }
            }
            finally {
                this.releaseWriteLock();
            }
        }
    }

    private LightWeightServerImpl() {
    }

    public LightWeightServerImpl(int port) throws IOException {
        this();
        this.serverSocket = new ServerSocket(port);
        this.serverThread.start();
    }

    public LightWeightServerImpl(int port, String repositoryName) throws IOException {
        this();
        this.serverSocket = new ServerSocket(port);
        this.repositoryName = repositoryName;
        this.restore();
        LightWeightServerImpl.log("Starting server with identifier '" + this.serverIdentifier + "'");
        this.serverThread.start();
    }

    private String getNewObjectId(int numberOfIds) throws IOException {
        String ids = null;
        for (int i = 0; i < numberOfIds; ++i) {
            String id = "server#" + this.nextObjectNumber;
            this.nextObjectNumber = this.nextObjectNumber.add(BigInteger.ONE);
            ids = ids != null ? ids + "\n" + id : id;
        }
        this.store("<id next=\"" + this.nextObjectNumber + "\"/>");
        return ids;
    }

    private String createCauseString(int checkinNr, boolean asLink, String connectionInfo) {
        String cause;
        Integer key = new Integer(checkinNr);
        String string = cause = asLink ? (String)this.causes.get(key) : null;
        if (cause == null) {
            Element child;
            Element causeElement = new Element("cause");
            causeElement.setAttribute("type", ObjectChangeStringCause.class.getName());
            if (asLink) {
                child = new Element(Link.class.getName());
                child.setAttribute("targetID", "checkin#" + checkinNr);
            } else {
                child = new Element(ObjectChangeStringCause.class.getName());
                child.setAttribute("ID", "checkin#" + checkinNr);
                Element stringElement = new Element("string");
                stringElement.addContent("checkin#" + checkinNr + ": " + connectionInfo);
                Vector<Element> childList = new Vector<Element>(1);
                childList.add(stringElement);
                child.setContent(childList);
            }
            Vector<Element> childList = new Vector<Element>(1);
            childList.add(child);
            causeElement.setContent(childList);
            cause = this.getFromCauses(this.xmlToString(causeElement));
            if (asLink) {
                this.causes.put(key, cause);
            }
        }
        return cause;
    }

    private String getFromCauses(String cause) {
        String causeFromMap = (String)this.causes.get(cause);
        if (causeFromMap != null) {
            cause = causeFromMap;
        } else {
            this.causes.put(cause, cause);
        }
        return cause;
    }

    public int getCheckinNr() {
        return this.checkinNr;
    }

    public void setCheckinNr(int checkinNr) throws IOException {
        if (this.checkinNr != checkinNr) {
            this.checkinNr = checkinNr;
            this.store("<checkin nr=\"" + checkinNr + "\"/>");
        }
    }

    private StringFromXML getStringFromXMLHandler() {
        if (this.stringFromXML == null) {
            this.stringFromXML = new StringFromXML();
        } else {
            this.stringFromXML.clear();
        }
        return this.stringFromXML;
    }

    private String xmlToString(Element xml) {
        try {
            StringWriter xmlStringWriter = new StringWriter();
            this.getXMLOutputter().output(xml, (Writer)xmlStringWriter);
            xmlStringWriter.flush();
            return xmlStringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Whoops! StringWriter has thrown an IOException!");
        }
    }

    private XMLOutputter getXMLOutputter() {
        if (this.xMLOutputter == null) {
            this.xMLOutputter = new XMLOutputter();
            this.xMLOutputter.setEncoding("UTF-8");
            this.xMLOutputter.setNewlines(false);
            this.xMLOutputter.setIndent(null);
        }
        return this.xMLOutputter;
    }

    private void addToObjectIds(Set objectStrings, boolean isRestoreOperation) throws IOException {
        Iterator iterator = objectStrings.iterator();
        while (iterator.hasNext()) {
            String objectString = (String)iterator.next();
            this.addToObjectIds(objectString, isRestoreOperation);
        }
    }

    private void addToObjectIds(String objectString, boolean isRestoreOperation) throws IOException {
        this.objectIds.add(objectString);
        if (!isRestoreOperation) {
            this.store("<object id=\"" + objectString + "\"/>");
        }
    }

    private void checkObjectId(String objectString, boolean mustExist, Set temporaryObjectIds) {
        if (!objectString.startsWith("singleton#")) {
            if (objectString.startsWith("local#")) {
                throw new RuntimeException(ERROR_INVALID_ID_PREFIX + objectString);
            }
            boolean exists = this.objectIds.contains(objectString);
            if (!exists && temporaryObjectIds != null) {
                exists = temporaryObjectIds.contains(objectString);
            }
            if (mustExist && !exists) {
                LightWeightServerImpl.error(ERROR_ID_NOT_KNOWN_PREFIX + objectString);
            }
            if (!mustExist && exists) {
                throw new RuntimeException(ERROR_ID_ALREADY_IN_USE_PREFIX + objectString);
            }
        }
    }

    public static void main(String[] args) {
        LightWeightServerImpl.startServer(LightWeightServerImpl.getServerFactory(), args);
    }

    public static void startServer(ServerFactory factory, String[] args) {
        block9: {
            try {
                if (args.length > 0 && !args[0].equals("")) {
                    if (args.length == 1) {
                        try {
                            int port = Integer.parseInt(args[0]);
                            LightWeightServerImpl.log("starting server on port " + port);
                            new LightWeightServerImpl(port);
                            break block9;
                        }
                        catch (NumberFormatException e) {
                            String nameserver;
                            String repositoryName = args[0];
                            int indexOfColon = repositoryName.indexOf(58);
                            if (indexOfColon > 0) {
                                nameserver = repositoryName.substring(0, indexOfColon);
                                repositoryName = repositoryName.substring(indexOfColon + 1);
                            } else {
                                nameserver = "localhost";
                            }
                            LightWeightServerImpl.log("starting server with name '" + repositoryName + "' registering at " + nameserver);
                            File lockFile = new File(repositoryName + ".lock");
                            lockFile.createNewFile();
                            lockFile.deleteOnExit();
                            factory.startAndRegisterServer(nameserver, 1900, repositoryName);
                            return;
                        }
                    }
                    if (args.length != 2) {
                        System.err.println("unhandled parameters");
                    }
                    break block9;
                }
                int port = 7658;
                LightWeightServerImpl.log("starting server on port " + port);
                factory.startServer(port, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ServerFactory getServerFactory() {
        if (serverFactory == null) {
            serverFactory = new ServerFactory();
        }
        return serverFactory;
    }

    public void shutdown() {
        this.serverThread.interrupt();
    }

    private void initStore() throws IOException {
        if (this.storage == null) {
            if (this.getRepositoryName() != null) {
                File file = new File(this.getStorageFileName());
                if (!file.exists()) {
                    this.storage = new OutputStreamWriter(new FileOutputStream(file));
                    this.storage.write(this.getDocumentHeader());
                    this.storage.write("<changes><server id=\"" + this.getServerIdentifier() + "\"/>");
                } else {
                    this.storage = new OutputStreamWriter(new FileOutputStream(file, true));
                }
            } else {
                this.storage = new Writer(){

                    public void close() {
                    }

                    public void flush() {
                    }

                    public void write(char[] cbuf, int off, int len) {
                    }
                };
            }
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    private String getStorageFileName() {
        if (this.getRepositoryName() != null) {
            return this.getRepositoryName() + ".lcxsr";
        }
        return null;
    }

    private void store(String xml) throws IOException {
        this.initStore();
        this.storage.write(xml);
        this.storage.flush();
    }

    private void store(Iterator xmlIterator) throws IOException {
        this.initStore();
        while (xmlIterator.hasNext()) {
            LWObjectChange change = (LWObjectChange)xmlIterator.next();
            this.storage.write(this.changeToXML(change));
            this.storage.write("\n");
        }
        this.storage.flush();
    }

    private String changeToXML(LWObjectChange change) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<change");
        stringBuffer.append(" object=\"");
        stringBuffer.append(change.affectedObjectId);
        stringBuffer.append("\"");
        if (change.fieldName != null) {
            stringBuffer.append(" field=\"");
            stringBuffer.append(change.fieldName);
            stringBuffer.append("\"");
        }
        stringBuffer.append(" type=\"");
        stringBuffer.append(change.typeOfChange);
        stringBuffer.append("\"");
        if (change.root) {
            stringBuffer.append(" root=\"1\"");
        }
        stringBuffer.append(" number=\"");
        stringBuffer.append(change.sequenceNumber);
        stringBuffer.append("\"");
        stringBuffer.append(">");
        if (change.cause != null) {
            stringBuffer.append(change.cause);
        }
        if (change.newValue != null) {
            stringBuffer.append(change.newValue);
        }
        if (change.oldValue != null) {
            stringBuffer.append(change.oldValue);
        }
        if (change.key != null) {
            stringBuffer.append(change.key);
        }
        stringBuffer.append("</change>");
        return stringBuffer.toString();
    }

    private void restore() throws IOException {
        File file;
        if (this.getStorageFileName() != null && (file = new File(this.getStorageFileName())).exists()) {
            FileInputStream fileStream = new FileInputStream(file);
            byte[] endTag = "</changes>".getBytes();
            ByteArrayInputStream endStream = new ByteArrayInputStream(endTag);
            SequenceInputStream both = new SequenceInputStream(fileStream, endStream);
            BufferedReader reader = new BufferedReader(new InputStreamReader(both));
            try {
                this.read(reader, null);
            }
            catch (LockNotAvailableException e) {
                throw new RuntimeException(e);
            }
            reader.close();
        }
    }

    protected static void log(String message) {
        System.out.println(new Date() + ": " + message);
    }

    protected static void error(String message) {
        System.err.println(new Date() + ": " + message);
    }

    static class NotClosableOutputStream
    extends OutputStream {
        private OutputStream outputStream;

        public NotClosableOutputStream(OutputStream outputStream) {
            if (outputStream == null) {
                throw new NullPointerException("outputStream");
            }
            this.outputStream = outputStream;
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }
    }

    public static class ServerFactory {
        protected ServerFactory() {
        }

        public LightWeightServerImpl startAndRegisterServer(String nameServer, int nameServerPort, String repositoryName) throws IOException, UnknownHostException {
            int port = 27400;
            LightWeightServerImpl server = null;
            try {
                while (server == null) {
                    try {
                        server = this.startServer(port, repositoryName);
                    }
                    catch (BindException e) {
                        if (port < 27500) {
                            ++port;
                            continue;
                        }
                        throw e;
                    }
                }
                LightWeightNameService.ServiceInfo info = new LightWeightNameService.ServiceInfo(InetAddress.getLocalHost().getHostAddress(), "" + port);
                try {
                    LightWeightNameService.announce(nameServer, nameServerPort, repositoryName, info);
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to register named service", e);
                }
                return server;
            }
            catch (RuntimeException e) {
                if (server != null) {
                    server.shutdown();
                }
                throw e;
            }
            catch (IOException e) {
                if (server != null) {
                    server.shutdown();
                }
                throw e;
            }
        }

        public LightWeightServerImpl startServer(int port, String repositoryName) throws IOException {
            return new LightWeightServerImpl(port, repositoryName);
        }
    }

    private static class NotClosableReader
    extends Reader {
        Reader actualReader;

        public NotClosableReader(Reader actualReader) {
            if (actualReader == null) {
                throw new NullPointerException();
            }
            this.actualReader = actualReader;
        }

        public void mark(int readAheadLimit) throws IOException {
            LightWeightServerImpl.log("NotClosableReader: mark");
            this.actualReader.mark(readAheadLimit);
        }

        public boolean markSupported() {
            LightWeightServerImpl.log("NotClosableReader: markSupported");
            return this.actualReader.markSupported();
        }

        public boolean ready() throws IOException {
            LightWeightServerImpl.log("NotClosableReader: ready");
            return this.actualReader.ready();
        }

        public void reset() throws IOException {
            LightWeightServerImpl.log("NotClosableReader: reset");
            this.actualReader.reset();
        }

        public long skip(long n) throws IOException {
            LightWeightServerImpl.log("NotClosableReader: skip");
            return this.actualReader.skip(n);
        }

        public void close() throws IOException {
            LightWeightServerImpl.log("NotClosableReader: close");
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.actualReader.read(cbuf, off, len);
        }
    }

    private class ValuesFromXML
    extends DefaultHandler {
        String newValue;
        String oldValue;
        String key;
        String cause;
        private Map tmpObjectIds;
        private StringFromXML subElementHandler;

        public ValuesFromXML(Map tmpObjectIds) {
            this.tmpObjectIds = tmpObjectIds;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("newValue".equals(qName) || "oldValue".equals(qName) || "key".equals(qName) || "cause".equals(qName)) {
                String objectString = attributes.getValue(attributes.getIndex("object"));
                if (objectString != null) {
                    LightWeightServerImpl.this.checkObjectId(objectString, true, this.tmpObjectIds.keySet());
                }
                this.subElementHandler = LightWeightServerImpl.this.getStringFromXMLHandler();
                LightWeightServerImpl.this.handlerStack.setHandlerForNextElements((DefaultHandler)this.subElementHandler);
                this.subElementHandler.startElement(uri, localName, qName, attributes);
            } else {
                this.subElementHandler = null;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.subElementHandler != null) {
                this.subElementHandler.endElement(uri, localName, qName);
            }
            if ("newValue".equals(qName)) {
                this.newValue = this.subElementHandler.toString();
            } else if ("oldValue".equals(qName)) {
                this.oldValue = this.subElementHandler.toString();
            } else if ("key".equals(qName)) {
                this.key = this.subElementHandler.toString();
            } else if ("cause".equals(qName)) {
                this.cause = this.subElementHandler.toString();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.subElementHandler != null) {
                this.subElementHandler.characters(ch, start, length);
            }
        }
    }

    private class StringFromXML
    extends DefaultHandler {
        StringBuffer stringBuffer = new StringBuffer();

        private StringFromXML() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.stringBuffer.append("<");
            this.stringBuffer.append(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.stringBuffer.append(" ");
                this.stringBuffer.append(attributeName);
                this.stringBuffer.append("=\"");
                this.stringBuffer.append(value);
                this.stringBuffer.append("\"");
            }
            this.stringBuffer.append(">");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stringBuffer.append("</");
            this.stringBuffer.append(qName);
            this.stringBuffer.append(">");
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String text = new String(ch, start, length);
            text = LightWeightServerImpl.this.getXMLOutputter().escapeElementEntities(text);
            this.stringBuffer.append(text);
        }

        public void clear() {
            this.stringBuffer.setLength(0);
        }

        public String toString() {
            return this.stringBuffer.toString();
        }
    }

    private static class LWObjectChange {
        String affectedObjectId = null;
        String fieldName = null;
        String key;
        int typeOfChange;
        String oldValue;
        String newValue;
        BigInteger sequenceNumber;
        private String cause = null;
        private boolean root;

        private LWObjectChange() {
        }

        public String toString() {
            String text = "Change";
            text = text + "#" + this.sequenceNumber;
            text = text + "(" + this.affectedObjectId;
            switch (this.typeOfChange) {
                case 12: {
                    String oldV = "" + this.oldValue;
                    String newV = "" + this.newValue;
                    if (oldV.length() > 30) {
                        oldV = oldV.substring(0, 30) + "...";
                    }
                    if (newV.length() > 30) {
                        newV = newV.substring(0, 30) + "...";
                    }
                    text = text + "." + this.fieldName + (this.key != null ? "[" + this.key + "]" : "") + " from '" + oldV + "' to '" + newV + "'";
                    break;
                }
                case 4: {
                    text = text + "." + this.fieldName + (this.key != null ? "[" + this.key + "]" : "") + " add '" + this.newValue + "'";
                    break;
                }
                case 8: {
                    text = text + "." + this.fieldName + (this.key != null ? "[" + this.key + "]" : "") + " remove '" + this.oldValue + "'";
                    break;
                }
                case 1: {
                    text = text + " added";
                    break;
                }
                case 2: {
                    text = text + " removed";
                    break;
                }
                default: {
                    text = text + " unknown change";
                }
            }
            return text + ")";
        }
    }

    private class ChangeFromXML
    extends DefaultHandler {
        TreeMap changes = new TreeMap();
        boolean isFirstChange = true;
        Map tmpObjectIds = new TreeMap();
        BigInteger nextSequenceNumber = LightWeightServerImpl.access$200(LightWeightServerImpl.this).add(BigInteger.ONE);
        String connectionInfo;
        private String cause;
        private int type;
        private String number;
        private String objectString;
        private String field;
        private ValuesFromXML valueHandler;
        private boolean root;
        boolean restoreOperation;

        public ChangeFromXML(boolean restoreOperation, String connectionInfo) {
            this.restoreOperation = restoreOperation;
            this.connectionInfo = connectionInfo;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("change".equals(qName)) {
                if (!this.restoreOperation) {
                    this.number = "" + this.nextSequenceNumber;
                    this.nextSequenceNumber = this.nextSequenceNumber.add(BigInteger.ONE);
                } else {
                    this.number = attributes.getValue("number");
                }
                String typeString = attributes.getValue(attributes.getIndex("type"));
                try {
                    this.type = Integer.parseInt(typeString);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Not a number in type!", e);
                }
                String rootString = attributes.getValue(attributes.getIndex("root"));
                this.root = "1".equals(rootString);
                if (!this.restoreOperation) {
                    this.cause = LightWeightServerImpl.this.createCauseString(LightWeightServerImpl.this.getCheckinNr(), !this.isFirstChange, this.connectionInfo);
                }
                this.objectString = attributes.getValue(attributes.getIndex("object"));
                if (this.restoreOperation) {
                    if (this.type == 1) {
                        this.tmpObjectIds.put(this.objectString, this.objectString);
                    }
                } else if (this.type == 1) {
                    LightWeightServerImpl.this.checkObjectId(this.objectString, false, this.tmpObjectIds.keySet());
                    this.tmpObjectIds.put(this.objectString, this.objectString);
                } else {
                    LightWeightServerImpl.this.checkObjectId(this.objectString, true, this.tmpObjectIds.keySet());
                }
                if (this.objectString == null) {
                    throw new RuntimeException(LightWeightServerImpl.ERROR_NULL_AFFECTED_OBJECT);
                }
                this.field = attributes.getValue(attributes.getIndex("field"));
                this.valueHandler = new ValuesFromXML(this.tmpObjectIds);
                LightWeightServerImpl.this.handlerStack.setHandlerForNextElements((DefaultHandler)this.valueHandler);
                this.isFirstChange = false;
            } else if ("id".equals(qName) && this.restoreOperation) {
                LightWeightServerImpl.this.nextObjectNumber = new BigInteger(attributes.getValue(attributes.getIndex("next")));
            } else if ("object".equals(qName) && this.restoreOperation) {
                LightWeightServerImpl.this.objectIds.add(attributes.getValue(attributes.getIndex("id")));
            } else if ("server".equals(qName) && this.restoreOperation) {
                LightWeightServerImpl.this.setServerIdentifier(attributes.getValue(attributes.getIndex("id")));
            } else if ("checkin".equals(qName) && this.restoreOperation) {
                LightWeightServerImpl.this.checkinNr = new Integer(attributes.getValue(attributes.getIndex("nr")));
            } else if ("rollback".equals(qName) && this.restoreOperation) {
                BigInteger lastKnownSequenceNumber = new BigInteger(attributes.getValue(attributes.getIndex("number")));
                LightWeightServerImpl.this.removeKeysGreaterThan(lastKnownSequenceNumber, this.changes.keySet().iterator());
            } else {
                throw new RuntimeException(LightWeightServerImpl.ERROR_XML_UNHANDLED_PREFIX + qName);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("change".equals(qName)) {
                LWObjectChange change = new LWObjectChange();
                if (this.restoreOperation) {
                    this.cause = LightWeightServerImpl.this.getFromCauses(this.valueHandler.cause);
                }
                change.cause = this.cause;
                change.affectedObjectId = this.objectString;
                change.fieldName = this.field;
                change.oldValue = this.valueHandler.oldValue;
                change.newValue = this.valueHandler.newValue;
                change.key = this.valueHandler.key;
                change.typeOfChange = this.type;
                change.sequenceNumber = new BigInteger(this.number);
                change.root = this.root;
                if (this.tmpObjectIds.containsKey(this.objectString)) {
                    this.objectString = (String)this.tmpObjectIds.get(this.objectString);
                } else if (!LightWeightServerImpl.this.objectIds.contains(this.objectString)) {
                    LightWeightServerImpl.error("change discarded - unknown affected object: " + change.toString());
                    return;
                }
                this.changes.put(change.sequenceNumber, change);
            }
        }

        public void endDocument() throws SAXException {
        }
    }

    private class ChangesFromXML
    extends DefaultHandler {
        private ChangeFromXML handlerOfSubElements;

        public ChangesFromXML(boolean restoreOperation, String connectionInfo) {
            this.handlerOfSubElements = new ChangeFromXML(restoreOperation, connectionInfo);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            LightWeightServerImpl.this.handlerStack.setHandlerForNextElements((DefaultHandler)this.handlerOfSubElements);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                LightWeightServerImpl.this.addToObjectIds(this.handlerOfSubElements.tmpObjectIds.keySet(), this.handlerOfSubElements.restoreOperation);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public TreeMap getChanges() {
            return this.handlerOfSubElements.changes;
        }
    }

    protected class ClientSocketProcessor
    extends Thread {
        Socket socket;
        BufferedReader reader;
        Writer writer;
        private boolean connectionKeptAlive;

        public ClientSocketProcessor(Socket socket) {
            this.socket = socket;
            this.setConnectionKeptAlive(false);
        }

        public Writer getWriter() throws IOException {
            if (this.writer == null) {
                GZIPOutputStream out = new GZIPOutputStream(new NotClosableOutputStream(this.socket.getOutputStream()));
                this.writer = new OutputStreamWriter(out);
            }
            return this.writer;
        }

        public BufferedReader getReader() throws IOException {
            if (this.reader == null) {
                GZIPInputStream in = new GZIPInputStream(this.socket.getInputStream(), 1024);
                this.reader = new BufferedReader(new InputStreamReader(in), 1024);
            }
            return this.reader;
        }

        public void run() {
            try {
                LightWeightServerImpl.log("reading command:");
                String command = this.getReader().readLine();
                LightWeightServerImpl.log(command);
                this.execute(command);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void execute(String command) throws IOException {
            block42: {
                if (LightWeightServerImpl.COMMAND_CHECKIN.equals(command) || LightWeightServerImpl.COMMAND_UPDATE.equals(command) || LightWeightServerImpl.COMMAND_ROLLBACK_TO.equals(command)) {
                    LightWeightServerImpl.log("reading last known sequence number:");
                    String lastKnownSequenceNumberString = this.getReader().readLine();
                    LightWeightServerImpl.log(lastKnownSequenceNumberString);
                    if (lastKnownSequenceNumberString != null) {
                        try {
                            int cmp;
                            BigInteger lastKnownSequenceNumber = new BigInteger(lastKnownSequenceNumberString);
                            if (lastKnownSequenceNumber.add(BigInteger.ONE).compareTo(BigInteger.ZERO) < 0) {
                                this.respond(LightWeightServerImpl.RESPONSE_FAILURE, LightWeightServerImpl.ERROR_SEQ_BELOW_MINUS_ONE);
                            }
                            if ((cmp = lastKnownSequenceNumber.compareTo(LightWeightServerImpl.this.lastKnownSequenceNumber)) == 0) {
                                if (LightWeightServerImpl.COMMAND_UPDATE.equals(command)) {
                                    try {
                                        LightWeightServerImpl.this.update(lastKnownSequenceNumber, this.getWriter());
                                    }
                                    catch (LockNotAvailableException e) {
                                        this.respond(LightWeightServerImpl.ERROR_OPERATION_IN_PROGRESS, null);
                                    }
                                } else if (LightWeightServerImpl.COMMAND_CHECKIN.equals(command)) {
                                    try {
                                        LightWeightServerImpl.this.checkin(this.getReader(), this);
                                    }
                                    catch (LockNotAvailableException e) {
                                        this.respond(LightWeightServerImpl.ERROR_OPERATION_IN_PROGRESS, null);
                                    }
                                }
                                break block42;
                            }
                            if (cmp < 0) {
                                if (LightWeightServerImpl.COMMAND_UPDATE.equals(command)) {
                                    try {
                                        LightWeightServerImpl.this.update(lastKnownSequenceNumber, this.getWriter());
                                    }
                                    catch (LockNotAvailableException e) {
                                        this.respond(LightWeightServerImpl.ERROR_OPERATION_IN_PROGRESS, null);
                                    }
                                } else if (LightWeightServerImpl.COMMAND_CHECKIN.equals(command)) {
                                    this.respond(LightWeightServerImpl.RESPONSE_UPDATEFIRST, LightWeightServerImpl.ERROR_SEQ_LOW);
                                } else if (LightWeightServerImpl.COMMAND_ROLLBACK_TO.equals(command)) {
                                    LightWeightServerImpl.this.rollback(lastKnownSequenceNumber);
                                    this.respond(LightWeightServerImpl.RESPONSE_DATA, LightWeightServerImpl.this.lastKnownSequenceNumber.toString());
                                }
                                break block42;
                            }
                            this.respond(LightWeightServerImpl.RESPONSE_FAILURE, LightWeightServerImpl.ERROR_SEQ_HIGH);
                        }
                        catch (NumberFormatException e) {
                            this.respond(LightWeightServerImpl.RESPONSE_FAILURE, LightWeightServerImpl.ERROR_SEQ_FORMAT);
                        }
                    } else {
                        this.respond(LightWeightServerImpl.RESPONSE_FAILURE, LightWeightServerImpl.ERROR_SEQ_NULL);
                    }
                } else if (LightWeightServerImpl.COMMAND_GET_SERVER_ID.equals(command)) {
                    this.respond(LightWeightServerImpl.RESPONSE_DATA, LightWeightServerImpl.this.getServerIdentifier());
                } else if (LightWeightServerImpl.COMMAND_GET_NEW_OBJECT_ID.equals(command)) {
                    String ids;
                    int numberOfIds;
                    String numberOfIdsString = this.reader.readLine();
                    if (numberOfIdsString != null) {
                        try {
                            numberOfIds = Integer.parseInt(numberOfIdsString);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                            numberOfIds = 1;
                        }
                    } else {
                        numberOfIds = 1;
                    }
                    try {
                        ids = LightWeightServerImpl.this.getNewObjectId(numberOfIds);
                    }
                    catch (IOException e) {
                        ids = null;
                        e.printStackTrace();
                        this.respond(LightWeightServerImpl.RESPONSE_FAILURE, LightWeightServerImpl.ERROR_WRITE_FILE_PREFIX + e);
                        LightWeightServerImpl.this.shutdown();
                    }
                    if (ids != null) {
                        this.respond(LightWeightServerImpl.RESPONSE_DATA, ids);
                    }
                } else if (LightWeightServerImpl.COMMAND_LISTEN.equals(command)) {
                    this.setConnectionKeptAlive(true);
                    this.writer = new OutputStreamWriter(this.socket.getOutputStream());
                    LightWeightServerImpl.this.addToListeningSockets(this.socket, this.getWriter());
                } else if ("LOGIN".equals(command)) {
                    LightWeightServerImpl.log("ignoring login command from " + this.socket.getInetAddress());
                    this.getReader().readLine();
                    this.getReader().readLine();
                    this.run();
                } else if (LightWeightServerImpl.COMMAND_SHUTDOWN.equals(command)) {
                    try {
                        LightWeightServerImpl.this.requestWriteLock();
                        this.respond(LightWeightServerImpl.RESPONSE_SUCCESS, "\n");
                        LightWeightServerImpl.log("received shutdown command from " + this.socket.getInetAddress() + " ... shutting down myself...");
                        this.closeSocket();
                        System.exit(0);
                    }
                    catch (LockNotAvailableException e) {
                        this.respond(LightWeightServerImpl.RESPONSE_FAILURE, LightWeightServerImpl.ERROR_OPERATION_IN_PROGRESS);
                    }
                } else {
                    LightWeightServerImpl.error("Unknown command: '" + command + "' from " + this.socket.getInetAddress());
                    this.respond(LightWeightServerImpl.RESPONSE_FAILURE, LightWeightServerImpl.ERROR_UNKNOWN_COMMAND_PREFIX + command);
                }
            }
            this.closeSocket();
        }

        protected boolean isConnectionKeptAlive() {
            return this.connectionKeptAlive;
        }

        protected void setConnectionKeptAlive(boolean connectionKeptAlive) {
            this.connectionKeptAlive = connectionKeptAlive;
        }

        protected void closeSocket() throws IOException {
            if (!this.socket.isClosed() && !this.isConnectionKeptAlive()) {
                this.getWriter().close();
                this.socket.close();
            }
        }

        protected void respond(String response, String data) throws IOException {
            LightWeightServerImpl.log("response: " + response);
            if (LightWeightServerImpl.RESPONSE_FAILURE.equals(response)) {
                LightWeightServerImpl.error("data: " + data);
            }
            this.getWriter().write(response + "\n");
            if (data != null) {
                this.getWriter().write(data + "\n");
            }
            this.getWriter().flush();
            while (this.getReader().readLine() != null) {
            }
        }

        protected String getConnectionInfo() {
            return " from " + (this.socket.getInetAddress() != null ? this.socket.getInetAddress().getHostAddress() : null) + " on " + new Date().toString();
        }
    }

    private class ServerSocketListeneningThread
    extends Thread {
        private ServerSocketListeneningThread() {
        }

        public void run() {
            try {
                LightWeightServerImpl.this.serverSocket.setSoTimeout(1000);
                while (!this.isInterrupted()) {
                    try {
                        Socket socket = LightWeightServerImpl.this.serverSocket.accept();
                        socket.setSoTimeout(10000);
                        try {
                            LightWeightServerImpl.this.process(socket);
                        }
                        catch (Exception e) {
                            LightWeightServerImpl.error("Error handling client connection:");
                            e.printStackTrace();
                        }
                    }
                    catch (SocketTimeoutException e) {}
                }
                LightWeightServerImpl.log("shutting down server thread");
                LightWeightServerImpl.this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                LightWeightServerImpl.log("shutting down server due to " + e);
            }
        }
    }

    protected static class LockNotAvailableException
    extends Exception {
        protected LockNotAvailableException() {
        }
    }
}

