/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote.web;

import de.tu_bs.coobra.remote.web.BinaryProvider;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class DefaultBinaryProvider
implements BinaryProvider {
    File jarLocation;
    byte[] jarCache;
    private String additionalInfo;

    public DefaultBinaryProvider(File jarLocation, String additionalInfo) {
        this.jarLocation = jarLocation;
        this.additionalInfo = additionalInfo;
    }

    public DefaultBinaryProvider(String jarLocation, String additionalInfo) {
        this(new File(jarLocation), additionalInfo);
    }

    private byte[] getJarData(String clientSpecifiedServerName) throws IOException {
        if (this.jarCache == null) {
            JarFile file = new JarFile(this.jarLocation);
            ByteArrayOutputStream out = new ByteArrayOutputStream(file.size());
            JarOutputStream jarOut = new JarOutputStream((OutputStream)out, file.getManifest());
            byte[] buffer = new byte[4096];
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                int read;
                JarEntry entry = entries.nextElement();
                if (entry.getName().startsWith("META-INF/") || entry.isDirectory()) continue;
                JarEntry jarEntry = new JarEntry(entry);
                jarEntry.setCompressedSize(-1L);
                jarOut.putNextEntry(jarEntry);
                InputStream entryInputStream = file.getInputStream(entry);
                while ((read = entryInputStream.read(buffer)) != -1) {
                    jarOut.write(buffer, 0, read);
                }
            }
            String info = clientSpecifiedServerName + "\n" + this.getAdditionalInfo();
            if (info != null) {
                JarEntry entry = new JarEntry("info");
                entry.setSize(info.getBytes().length);
                jarOut.putNextEntry(entry);
                jarOut.write(info.getBytes());
            }
            jarOut.finish();
            jarOut.close();
            this.jarCache = out.toByteArray();
        }
        return this.jarCache;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        this.jarCache = null;
    }

    public byte[] retrieveBinary(String path, String clientSpecifiedServerName) {
        if ("/download.jar".equals(path)) {
            try {
                return this.getJarData(clientSpecifiedServerName);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAdditionalInfoFromJar(int line) {
        URL url = DefaultBinaryProvider.class.getResource("/info");
        if (url != null) {
            String string;
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                for (int i = 0; i < line; ++i) {
                    reader.readLine();
                }
                string = reader.readLine();
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            reader.close();
            return string;
        }
        return null;
    }
}

