/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.coobra.remote.web;

import de.tu_bs.coobra.remote.web.JarWebServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.URLDecoder;
import org.jibble.simplewebserver.RequestThread;
import org.jibble.simplewebserver.SimpleWebServer;

public class DynamicRequestThread
extends RequestThread {
    JarWebServer server;

    public DynamicRequestThread(Socket socket, File rootDir, JarWebServer server) {
        super(socket, rootDir);
        if (server == null) {
            throw new NullPointerException();
        }
        this.server = server;
    }

    protected String getVersion() {
        return "CoObRA WebServer http://www.se.eecs.uni-kassel.de/CoObRA/";
    }

    protected void handleRequest(String path, BufferedOutputStream out, String clientSpecifiedServerName) throws IOException {
        if (path.endsWith(".html") || path.endsWith("/")) {
            this.printHTML(path, out, clientSpecifiedServerName);
        } else {
            byte[] data = this.server.jarProvider.retrieveBinary(URLDecoder.decode(path, "UTF-8"), clientSpecifiedServerName);
            if (data != null) {
                String extension = SimpleWebServer.getExtension(path);
                String contentType = DynamicRequestThread.getContentType(extension);
                DynamicRequestThread.sendHeader(out, 200, contentType, data.length, System.currentTimeMillis());
                out.write(data);
            } else {
                super.handleRequest(path, out, clientSpecifiedServerName);
            }
        }
    }

    private void printHTML(String path, BufferedOutputStream out, String clientSpecifiedServerName) throws IOException {
        String html = this.server.htmlProvider.retrieveHTML(URLDecoder.decode(path, "UTF-8"));
        if (html != null) {
            DynamicRequestThread.sendHeader(out, 200, "text/html", -1L, System.currentTimeMillis());
            out.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n".getBytes());
            out.write(html.getBytes());
        } else {
            super.handleRequest(path, out, clientSpecifiedServerName);
        }
    }
}

