/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.simplewebserver;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import org.jibble.simplewebserver.RequestThread;

public class SimpleWebServer
extends Thread {
    public static final String VERSION = "SimpleWebServer  http://www.jibble.org/";
    public static final Hashtable MIME_TYPES = new Hashtable();
    private int port;
    private File rootDir;
    private boolean _running = true;

    public SimpleWebServer(File rootDir, int port) throws IOException {
        if (rootDir != null) {
            this.setRootDir(rootDir.getCanonicalFile());
            if (!this.getRootDir().isDirectory()) {
                throw new IOException("Not a directory.");
            }
        }
        this.port = port;
    }

    protected ServerSocket getServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    public void run() {
        try {
            ServerSocket serverSocket = this.getServerSocket(this.port);
            System.out.println("Listening on port " + serverSocket.getLocalPort());
            while (this._running) {
                Socket socket = serverSocket.accept();
                RequestThread requestThread = this.createThread(socket);
                requestThread.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected RequestThread createThread(Socket socket) {
        return new RequestThread(socket, this.getRootDir());
    }

    public static String getExtension(String filename) {
        String extension = "";
        int dotPos = filename.lastIndexOf(".");
        if (dotPos >= 0) {
            extension = filename.substring(dotPos);
        }
        return extension.toLowerCase();
    }

    public static void main(String[] args) {
        try {
            new SimpleWebServer(new File("./"), 80).start();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public File getRootDir() {
        return this.rootDir;
    }

    private void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    static {
        String image = "image/";
        MIME_TYPES.put(".gif", image + "gif");
        MIME_TYPES.put(".jpg", image + "jpeg");
        MIME_TYPES.put(".jpeg", image + "jpeg");
        MIME_TYPES.put(".png", image + "png");
        String text = "text/";
        MIME_TYPES.put(".html", text + "html");
        MIME_TYPES.put(".htm", text + "html");
        MIME_TYPES.put(".txt", text + "plain");
    }
}

