/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.MarginInfo;
import org.apache.batik.gvt.text.RegionInfo;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class SVGFlowTextElementBridge
extends SVGTextElementBridge
implements BatikExtConstants {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute PREFORMATTED = GVTAttributedCharacterIterator.TextAttribute.PREFORMATTED;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;

    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "flowText";
    }

    public Bridge getInstance() {
        return new SVGFlowTextElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        List list = this.getRegions(bridgeContext, element);
        AttributedString attributedString = this.getFlowDiv(bridgeContext, element);
        attributedString.addAttribute(FLOW_REGIONS, list, 0, 1);
        return attributedString;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addGlyphPositionAttributes(attributedString, element, bridgeContext);
            return;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element2;
                String string2;
                String string3 = node.getNamespaceURI();
                if ((this.getNamespaceURI().equals(string3) || "http://www.w3.org/2000/svg".equals(string3)) && (string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) {
                    super.addGlyphPositionAttributes(attributedString, element2, bridgeContext);
                    return;
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNamespaceURI();
                if ((this.getNamespaceURI().equals(string2) || "http://www.w3.org/2000/svg".equals(string2)) && ((string = node.getLocalName()).equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowLine") || string.equals("flowSpan") || string.equals("a") || string.equals("tref"))) {
                    this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void addNullPaintAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addNullPaintAttributes(attributedString, element, bridgeContext);
            return;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string2;
            if (node.getNodeType() == 1 && this.getNamespaceURI().equals(node.getNamespaceURI()) && (string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) {
                super.addNullPaintAttributes(attributedString, element2, bridgeContext);
                return;
            }
            node = node.getNextSibling();
        }
    }

    protected void addChildNullPaintAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNamespaceURI();
                if ((this.getNamespaceURI().equals(string2) || "http://www.w3.org/2000/svg".equals(string2)) && ((string = node.getLocalName()).equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowLine") || string.equals("flowSpan") || string.equals("a") || string.equals("tref"))) {
                    Element element2 = (Element)node;
                    this.addNullPaintAttributes(attributedString, element2, bridgeContext);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addPaintAttributes(attributedString, element, textNode, textPaintInfo, bridgeContext);
            return;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string2;
            if (node.getNodeType() == 1 && this.getNamespaceURI().equals(node.getNamespaceURI()) && (string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) {
                super.addPaintAttributes(attributedString, element2, textNode, textPaintInfo, bridgeContext);
                return;
            }
            node = node.getNextSibling();
        }
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                String string;
                String string2 = node.getNamespaceURI();
                if ((this.getNamespaceURI().equals(string2) || "http://www.w3.org/2000/svg".equals(string2)) && ((string = node.getLocalName()).equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowLine") || string.equals("flowSpan") || string.equals("a") || string.equals("tref"))) {
                    Element element2 = (Element)node;
                    TextPaintInfo textPaintInfo2 = this.getTextPaintInfo(element2, (GraphicsNode)textNode, textPaintInfo, bridgeContext);
                    this.addPaintAttributes(attributedString, element2, textNode, textPaintInfo2, bridgeContext);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected AttributedString getFlowDiv(BridgeContext bridgeContext, Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI()) {
                Element element2 = (Element)node;
                String string = node.getLocalName();
                if (string.equals("flowDiv")) {
                    return this.gatherFlowPara(bridgeContext, element2);
                }
            }
            node = node.getNextSibling();
        }
        return null;
    }

    protected AttributedString gatherFlowPara(BridgeContext bridgeContext, Element element) {
        int n;
        Object object;
        SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList arrayList3 = new ArrayList();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI()) {
                object = (Element)node;
                String string = object.getLocalName();
                if (string.equals("flowPara")) {
                    this.fillAttributedStringBuffer(bridgeContext, (Element)object, true, null, attributedStringBuffer, arrayList3);
                    arrayList2.add(object);
                    arrayList.add(new Integer(attributedStringBuffer.length()));
                } else if (string.equals("flowRegionBreak")) {
                    this.fillAttributedStringBuffer(bridgeContext, (Element)object, true, null, attributedStringBuffer, arrayList3);
                    arrayList2.add(object);
                    arrayList.add(new Integer(attributedStringBuffer.length()));
                }
            }
            node = node.getNextSibling();
        }
        object = attributedStringBuffer.toAttributedString();
        int n2 = 0;
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (n == n2) continue;
            ((AttributedString)object).addAttribute(FLOW_LINE_BREAK, new Object(), n2, n);
            n2 = n;
        }
        n = 0;
        LinkedList<MarginInfo> linkedList = null;
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            Element element2 = (Element)arrayList2.get(n3);
            int n4 = (Integer)arrayList.get(n3);
            if (n == n4) {
                if (linkedList == null) {
                    linkedList = new LinkedList<MarginInfo>();
                }
                linkedList.add(this.makeMarginInfo(element2));
            } else {
                ((AttributedString)object).addAttribute(FLOW_PARAGRAPH, this.makeMarginInfo(element2), n, n4);
                if (linkedList != null) {
                    ((AttributedString)object).addAttribute(FLOW_EMPTY_PARAGRAPH, linkedList, n, n4);
                    linkedList = null;
                }
            }
            ++n3;
            n = n4;
        }
        return object;
    }

    protected List getRegions(BridgeContext bridgeContext, Element element) {
        LinkedList linkedList = new LinkedList();
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string;
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI() && "flowRegion".equals(string = (element2 = (Element)node).getLocalName())) {
                float f = 0.0f;
                String string2 = element2.getAttribute("vertical-align");
                if (string2 != null && string2.length() > 0) {
                    if ("top".equals(string2)) {
                        f = 0.0f;
                    } else if ("middle".equals(string2)) {
                        f = 0.5f;
                    } else if ("bottom".equals(string2)) {
                        f = 1.0f;
                    }
                }
                this.gatherRegionInfo(bridgeContext, element2, f, linkedList);
            }
            node = node.getNextSibling();
        }
        return linkedList;
    }

    protected void gatherRegionInfo(BridgeContext bridgeContext, Element element, float f, List list) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && node.getNamespaceURI() == this.getNamespaceURI()) {
                UnitProcessor.Context context;
                RegionInfo regionInfo;
                Element element2 = (Element)node;
                String string = node.getLocalName();
                if (string.equals("rect") && (regionInfo = this.buildRegion(context = UnitProcessor.createContext((BridgeContext)bridgeContext, (Element)element2), element2, f)) != null) {
                    list.add(regionInfo);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected RegionInfo buildRegion(UnitProcessor.Context context, Element element, float f) {
        String string = element.getAttribute("x");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)string, (String)"x", (UnitProcessor.Context)context);
        }
        string = element.getAttribute("y");
        float f3 = 0.0f;
        if (string.length() != 0) {
            f3 = UnitProcessor.svgVerticalCoordinateToUserSpace((String)string, (String)"y", (UnitProcessor.Context)context);
        }
        if ((string = element.getAttribute("width")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width", string});
        }
        float f4 = UnitProcessor.svgHorizontalLengthToUserSpace((String)string, (String)"width", (UnitProcessor.Context)context);
        if (f4 == 0.0f) {
            return null;
        }
        string = element.getAttribute("height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height", string});
        }
        float f5 = UnitProcessor.svgVerticalLengthToUserSpace((String)string, (String)"height", (UnitProcessor.Context)context);
        if (f5 == 0.0f) {
            return null;
        }
        return new RegionInfo(f2, f3, f4, f5, f);
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, Integer n, SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer, List list) {
        if (!SVGUtilities.matchUserAgent((Element)element, (UserAgent)bridgeContext.getUserAgent())) {
            return;
        }
        String string = XMLSupport.getXMLSpace((Element)element);
        boolean bl2 = string.equals("preserve");
        boolean bl3 = true;
        boolean bl4 = !bl2;
        boolean bl5 = !bl2;
        Element element2 = element;
        Map map = this.getAttributeMap(bridgeContext, element, null, n);
        Object v = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer n2 = n;
        if (v != null) {
            n2 = (Integer)v;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            boolean bl6 = node.getNextSibling() == null;
            int n3 = attributedStringBuffer.getLastChar();
            bl4 = !bl2 && bl3 && (bl || n3 == 32 || n3 == -1);
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Object object2;
                    if (node.getNamespaceURI() != this.getNamespaceURI() && node.getNamespaceURI() != "http://www.w3.org/2000/svg") break;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("flowLine")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n2, attributedStringBuffer, list);
                        list.add(new Integer(attributedStringBuffer.length()));
                        break;
                    }
                    if (string2.equals("flowSpan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n2, attributedStringBuffer, list);
                        break;
                    }
                    if (string2.equals("a")) {
                        if (bridgeContext.isInteractive()) {
                            object2 = (EventTarget)((Object)element2);
                            object = bridgeContext.getUserAgent();
                            object2.addEventListener("click", (EventListener)new SVGAElementBridge.AnchorListener(object), false);
                            object2.addEventListener("mouseover", (EventListener)new SVGAElementBridge.CursorMouseOverListener(object), false);
                            object2.addEventListener("mouseout", (EventListener)new SVGAElementBridge.CursorMouseOutListener(object), false);
                        }
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n2, attributedStringBuffer, list);
                        break;
                    }
                    if (!string2.equals("tref")) break;
                    object2 = XLinkSupport.getXLinkHref((Element)((Element)node));
                    object = bridgeContext.getReferencedElement((Element)node, (String)object2);
                    string = TextUtilities.getElementContent((Element)object);
                    if ((string = this.normalizeString(string, bl2, bl4, bl6 && bl)) == null) break;
                    boolean bl7 = bl5 = !bl2 && string.charAt(0) == ' ';
                    if (bl5 && !attributedStringBuffer.isEmpty()) {
                        attributedStringBuffer.stripLast();
                    }
                    Map map2 = this.getAttributeMap(bridgeContext, element2, null, n);
                    attributedStringBuffer.append(string, map2);
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl4, bl6 && bl);
                    if (string == null) break;
                    boolean bl8 = bl5 = !bl2 && string.charAt(0) == ' ';
                    if (bl5 && !attributedStringBuffer.isEmpty()) {
                        attributedStringBuffer.stripLast();
                    }
                    attributedStringBuffer.append(string, map);
                }
            }
            bl3 = false;
            node = node.getNextSibling();
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n) {
        Map map = super.getAttributeMap(bridgeContext, element, textPath, n);
        String string = element.getAttribute("preformatted");
        if (string.length() != 0 && string.equals("true")) {
            map.put(PREFORMATTED, Boolean.TRUE);
        }
        return map;
    }

    protected void checkMap(Map map) {
        if (map.containsKey(TEXTPATH)) {
            return;
        }
        if (map.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (map.containsKey(LETTER_SPACING)) {
            return;
        }
        if (map.containsKey(WORD_SPACING)) {
            return;
        }
        if (map.containsKey(KERNING)) {
            return;
        }
    }

    public MarginInfo makeMarginInfo(Element element) {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string = element.getAttribute("margin");
        try {
            if (string.length() != 0) {
                f4 = f5 = (f = Float.parseFloat(string));
                f3 = f5;
                f2 = f5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("top-margin");
        try {
            if (string.length() != 0) {
                f2 = f = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("right-margin");
        try {
            if (string.length() != 0) {
                float f6;
                f3 = f6 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("bottom-margin");
        try {
            if (string.length() != 0) {
                float f7;
                f4 = f7 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("left-margin");
        try {
            if (string.length() != 0) {
                float f8;
                f5 = f8 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float f9 = 0.0f;
        string = element.getAttribute("indent");
        try {
            if (string.length() != 0) {
                float f10;
                f9 = f10 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n = 0;
        string = element.getAttribute("justification");
        try {
            if (string.length() != 0) {
                if ("start".equals(string)) {
                    n = 0;
                } else if ("middle".equals(string)) {
                    n = 1;
                } else if ("end".equals(string)) {
                    n = 2;
                } else if ("full".equals(string)) {
                    n = 3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string2 = element.getLocalName();
        boolean bl = string2.equals("flowRegionBreak");
        return new MarginInfo(f2, f3, f4, f5, f9, n, bl);
    }

    public static class LineBreakInfo {
        int breakIdx;
        float lineAdvAdj;
        boolean relative;

        public LineBreakInfo(int n, float f, boolean bl) {
            this.breakIdx = n;
            this.lineAdvAdj = f;
            this.relative = bl;
        }

        public int getBreakIdx() {
            return this.breakIdx;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public float getLineAdvAdj() {
            return this.lineAdvAdj;
        }
    }
}

