/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class JPEGReader
implements ImageReader {
    private static final int MARK = 255;
    private static final int NULL = 0;
    private static final int SOF1 = 192;
    private static final int SOF2 = 193;
    private static final int SOF3 = 194;
    private static final int SOFA = 202;
    private static final int APP0 = 224;
    private static final int APPF = 239;
    private static final int SOS = 218;
    private static final int SOI = 216;
    private static final int JPG_SIG_LENGTH = 2;

    private byte[] getDefaultHeader(InputStream imageStream) throws IOException {
        byte[] header = new byte[2];
        try {
            imageStream.mark(3);
            imageStream.read(header);
            imageStream.reset();
        }
        catch (IOException ex) {
            try {
                imageStream.reset();
            }
            catch (IOException iOException) {}
            throw ex;
        }
        return header;
    }

    /*
     * WARNING - void declaration
     */
    private FopImage.ImageInfo getDimension(InputStream imageStream) throws IOException {
        FopImage.ImageInfo info = new FopImage.ImageInfo();
        try {
            imageStream.mark(imageStream.available());
            int marker = 0;
            block8: while (imageStream.available() > 0) {
                while ((marker = imageStream.read()) != 255) {
                }
                while ((marker = imageStream.read()) == 255) {
                }
                switch (marker) {
                    case 192: 
                    case 193: 
                    case 194: 
                    case 202: {
                        this.skip(imageStream, 3L);
                        info.height = this.read2bytes(imageStream);
                        info.width = this.read2bytes(imageStream);
                        break block8;
                    }
                    default: {
                        long length = this.read2bytes(imageStream);
                        long skipped = this.skip(imageStream, length - 2L);
                        if (skipped != length - 2L) {
                            throw new IOException("Skipping Error");
                        }
                    }
                    case 0: 
                    case 216: {
                        continue block8;
                    }
                }
            }
            imageStream.reset();
        }
        catch (IOException ioe) {
            void marker;
            try {
                imageStream.reset();
            }
            catch (IOException iOException) {}
            throw marker;
        }
        return info;
    }

    public String getMimeType() {
        return "image/jpeg";
    }

    private int read2bytes(InputStream imageStream) throws IOException {
        int byte1 = imageStream.read();
        int byte2 = imageStream.read();
        return byte1 << 8 | byte2;
    }

    private long skip(InputStream imageStream, long n) throws IOException {
        long discarded = 0L;
        while (discarded != n) {
            imageStream.read();
            ++discarded;
        }
        return discarded;
    }

    public FopImage.ImageInfo verifySignature(String uri, InputStream fis, FOUserAgent ua) throws IOException {
        boolean supported;
        byte[] header = this.getDefaultHeader(fis);
        boolean bl = supported = header[0] == -1 && header[1] == -40;
        if (supported) {
            FopImage.ImageInfo info = this.getDimension(fis);
            info.mimeType = this.getMimeType();
            info.inputStream = fis;
            return info;
        }
        return null;
    }
}

