/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFEncryptionParams;

public class PDFEncryptionManager {
    static /* synthetic */ Class class$org$apache$fop$pdf$PDFEncryptionParams;

    public static boolean checkAvailableAlgorithms() {
        if (!PDFEncryptionManager.isJCEAvailable()) {
            return false;
        }
        Provider[] providers = Security.getProviders("Cipher.RC4");
        if (providers == null) {
            return false;
        }
        providers = Security.getProviders("MessageDigest.MD5");
        return providers != null;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static boolean isJCEAvailable() {
        try {
            Class<?> clazz = Class.forName("javax.crypto.Cipher");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static PDFEncryption newInstance(int objnum, PDFEncryptionParams params) {
        try {
            Class<?> clazz = Class.forName("org.apache.fop.pdf.PDFEncryptionJCE");
            Method makeMethod = clazz.getMethod("make", Integer.TYPE, class$org$apache$fop$pdf$PDFEncryptionParams != null ? class$org$apache$fop$pdf$PDFEncryptionParams : (class$org$apache$fop$pdf$PDFEncryptionParams = PDFEncryptionManager.class$("org.apache.fop.pdf.PDFEncryptionParams")));
            Object obj = makeMethod.invoke(null, new Integer(objnum), params);
            return (PDFEncryption)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (PDFEncryptionManager.checkAvailableAlgorithms()) {
                System.out.println("JCE and algorithms available, but the implementation class unavailable. Please do a full rebuild.");
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setupPDFEncryption(FOUserAgent userAgent, PDFDocument pdf, Logger log) {
        if (userAgent == null) {
            throw new NullPointerException("User agent must not be null");
        }
        if (pdf == null) {
            throw new NullPointerException("PDF document must not be null");
        }
        if (userAgent.getPDFEncryptionParams() != null) {
            if (!PDFEncryptionManager.checkAvailableAlgorithms()) {
                if (PDFEncryptionManager.isJCEAvailable()) {
                    log.warn("PDF encryption has been requested, JCE is available but there's no JCE provider available that provides the necessary algorithms. The PDF won't be encrypted.");
                } else {
                    log.warn("PDF encryption has been requested but JCE is unavailable! The PDF won't be encrypted.");
                }
            }
            pdf.setEncryption(userAgent.getPDFEncryptionParams());
        }
    }
}

