/*
 * Decompiled with CFR 0.152.
 */
package de.upb.assocdetection;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.parser.ParserPostProcessor;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.assocdetection.preferences.AssocDetectionPreferences;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessMethodDetector
implements ParserPostProcessor,
PropertyChangeListener {
    private boolean active = AssocDetectionPreferences.get().isAccessMethodDetectionEnabled();
    private String prefixPartOfRegexp;

    public boolean isActive() {
        return this.active;
    }

    public void execute() {
        if (AssocDetectionPreferences.get().getAccessMethodPrefixes().size() > 0) {
            Iterator diagsIter = UMLProject.get().iteratorOfDiags();
            while (diagsIter.hasNext()) {
                ASGDiagram asgDiagram = (ASGDiagram)diagsIter.next();
                if (!(asgDiagram instanceof UMLClassDiagram)) continue;
                UMLClassDiagram classDiagram = (UMLClassDiagram)asgDiagram;
                Iterator elementsIter = classDiagram.iteratorOfElements();
                while (elementsIter.hasNext()) {
                    UMLClass umlClass;
                    UMLDiagramItem umlDiagramItem = (UMLDiagramItem)elementsIter.next();
                    if (!(umlDiagramItem instanceof UMLClass) || !(umlClass = (UMLClass)umlDiagramItem).isParsed() || umlClass.sizeOfAttrs() <= 0) continue;
                    Pattern pattern = this.createPattern(umlClass);
                    Iterator methodIter = umlClass.iteratorOfMethods();
                    while (methodIter.hasNext()) {
                        UMLMethod umlMethod = (UMLMethod)methodIter.next();
                        if (!umlMethod.isParsed()) continue;
                        this.checkForAccessMethod(umlMethod, pattern);
                    }
                }
            }
        }
    }

    public String getName() {
        return "Access Method Detection";
    }

    private String createPrefixPartOfRegexp() {
        if (this.prefixPartOfRegexp == null) {
            StringBuffer buffer = new StringBuffer("(");
            boolean first = true;
            Iterator iter = AssocDetectionPreferences.get().getAccessMethodPrefixes().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    buffer.append("|");
                } else {
                    first = false;
                }
                buffer.append((String)iter.next());
            }
            buffer.append(")");
            this.prefixPartOfRegexp = buffer.toString();
        }
        return this.prefixPartOfRegexp;
    }

    private Pattern createPattern(UMLClass umlClass) {
        StringBuffer patternBuffer = new StringBuffer(this.createPrefixPartOfRegexp());
        patternBuffer.append("(");
        boolean first = true;
        Iterator iter = umlClass.iteratorOfAttrs();
        while (iter.hasNext()) {
            UMLAttr umlAttr = (UMLAttr)iter.next();
            if (!first) {
                patternBuffer.append("|");
            } else {
                first = false;
            }
            patternBuffer.append(umlAttr.getName());
        }
        patternBuffer.append(")");
        return Pattern.compile(patternBuffer.toString(), 2);
    }

    private void checkForAccessMethod(UMLMethod umlMethod, Pattern pattern) {
        String methodName = umlMethod.getName();
        Matcher matcher = pattern.matcher(methodName);
        if (matcher.matches()) {
            umlMethod.setDisplayLevel(0);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("AssocDetection.AccessMethodDetectionEnabled")) {
            this.active = Boolean.valueOf((String)event.getNewValue());
        }
    }
}

