/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.ant;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.actions.RestoreAction;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * convert cxr-projectfile <code>cxrFileName</code> to
 * fpr-projectfile <code>fprFileName</code> .
 *
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.1.2.3 $
 */
public class Cxr2FprTask extends Task
{

   /**
    * the cxr file name
    */
   private String cxrFileName = null;

   /**
    * the fpr file name
    */
   private String fprFileName = null;


   public Cxr2FprTask()
   {
      super();
   }


   /**
    * @see                    org.apache.tools.ant.Task#execute()
    * @throws BuildException
    */
   public void execute() throws BuildException
   {
      // load the cxr project
      UMLProject umlProject = loadCxrProject();

      // save the project in fpr format
      saveProjectAsFpr (umlProject, fprFileName);
   }


   private void saveProjectAsFpr (UMLProject umlProject, String umlFprFileName)
   {
      File projectFile = new File (umlFprFileName);

      umlProject.saveProject (projectFile);

   }


   private UMLProject loadCxrProject()
   {
      new RestoreAction().restore (getCxrFileName());

      UMLProject cxrProject = FujabaChangeManager.getUMLProject();
      UMLProject.setNewProject (cxrProject);

      return cxrProject;
   }


   /**
    * @return   Returns the cxrFileName.
    */
   public String getCxrFileName()
   {
      return this.cxrFileName;
   }


   /**
    * @param cxrFileName  The cxrFileName to set.
    */
   public void setCxrFileName (String cxrFileName)
   {
      if (this.cxrFileName != cxrFileName)
      {
         this.cxrFileName = cxrFileName;
      }
   }


   /**
    * @return   Returns the fprFileName.
    */
   public String getFprFileName()
   {
      return this.fprFileName;
   }


   /**
    * @param fprFileName  The fprFileName to set.
    */
   public void setFprFileName (String fprFileName)
   {
      if (this.fprFileName != fprFileName)
      {
         this.fprFileName = fprFileName;
      }
   }

}

/*
 * $Log: Cxr2FprTask.java,v $
 * Revision 1.1.2.3  2006/05/01 16:52:21  mksoft
 * remove java5 override annotation
 *
 */
