/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.ant;

import java.io.File;
import java.io.IOException;

import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

import de.tu_bs.coobra.LocalRepository;
import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.actions.CheckoutAction;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * generate source code for input cxrfile to destination directory.
 * <p>
 *
 * @author    $Author$
 * @version   $Revision$
 */
public class CxrCheckoutGenTask extends AbstractGenTask
{

   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (CxrCheckoutGenTask.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String repName = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String ior;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String login = "guest";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String password = "guest";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String nameServer = "www.se.eecs.uni-kassel.de";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String nameServerPort = "1900";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean lightweight = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String cxrFilename = null;



   /**
    * try to generate code for <code>cxrFilename</code> to directory <code>destDirname</code> .
    */
   protected void executeImpl()
   {
      // and now ???
      try
      {
         new CheckoutAction().connect (repName, ior, login, password, nameServer, nameServerPort, lightweight);
      }
      catch (Throwable t)
      {
         log.error (t.getMessage(), t);
         t.printStackTrace();
         throw new BuildException ("Checkout was not successful (ERROR: \"" + t.getMessage() + "\")!", t);
      }

      UMLProject cxrProject = FujabaChangeManager.getUMLProject();
      UMLProject.setNewProject (cxrProject);

      if (cxrFilename != null)
      {
         if (cxrFilename.endsWith ("fpr.gz") || cxrFilename.endsWith ("fpr"))
         {
            File fileProject = new File (cxrFilename);
            try
            {
               UMLProject.get().saveProject (fileProject);
            }
            catch (Exception tmpException)
            {
               tmpException.printStackTrace();
            } // end of catch
         }
         else
         {
            LocalRepository repo = FujabaChangeManager.getVMRepository();
            repo.compact();
            try
            {
               repo.store (cxrFilename, true);
            }
            catch (IOException e)
            {
               e.printStackTrace();
            }
         }
      }

      if (getDestDirname() != null)
      {
         File destDir = new File (getDestDirname());

         // set new destination directory
         cxrProject.setRootDir (destDir.getAbsolutePath());

         // generate complete project
         CodeGenFactory.get().generateFProject (cxrProject);
      }
   }


   /**
    * Sets the ior attribute of the CxrCheckoutGenTask object
    *
    * @param ior  The new ior value
    */
   public void setIor (String ior)
   {
      this.ior = ior;
   }


   /**
    * Sets the lightweight attribute of the CxrCheckoutGenTask object
    *
    * @param lightweight  The new lightweight value
    */
   public void setLightweight (boolean lightweight)
   {
      this.lightweight = lightweight;
   }


   /**
    * Sets the login attribute of the CxrCheckoutGenTask object
    *
    * @param login  The new login value
    */
   public void setLogin (String login)
   {
      this.login = login;
   }


   /**
    * Sets the nameServer attribute of the CxrCheckoutGenTask object
    *
    * @param nameServer  The new nameServer value
    */
   public void setNameServer (String nameServer)
   {
      this.nameServer = nameServer;
   }


   /**
    * Sets the nameServerPort attribute of the CxrCheckoutGenTask object
    *
    * @param nameServerPort  The new nameServerPort value
    */
   public void setNameServerPort (String nameServerPort)
   {
      this.nameServerPort = nameServerPort;
   }


   /**
    * Sets the password attribute of the CxrCheckoutGenTask object
    *
    * @param password  The new password value
    */
   public void setPassword (String password)
   {
      this.password = password;
   }


   /**
    * Sets the repName attribute of the CxrCheckoutGenTask object
    *
    * @param repName  The new repName value
    */
   public void setRepName (String repName)
   {
      this.repName = repName;
   }


   /**
    * Sets the cxrFilename attribute of the CxrCheckoutGenTask object
    *
    * @param cxrFilename  The new cxrFilename value
    */
   public void setCxrFilename (String cxrFilename)
   {
      this.cxrFilename = cxrFilename;
   }

}

/*
 * $Log$
 * Revision 1.1.2.5  2006/03/24 13:02:28  l3_g5
 * bugfix for ant task; added exceptions in story diags
 *
 * Revision 1.1.2.4  2006/03/14 13:27:00  l3_g5
 * bugfix
 *
 */
