/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import java.awt.*;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JEgg.EggMouseListener;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * The about box of Fujaba.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.59 $
 */
public class AboutBox extends JDialog
{
   /**
    * Constructor for class AboutBox
    *
    * @param parent        No description provided
    * @param splashscreen  No description provided
    */
   public AboutBox (JFrame parent, boolean splashscreen)
   {
      super (parent, "About Fujaba Tool Suite");
      setUndecorated (splashscreen);

      Container contentPane = getContentPane();
      contentPane.setLayout (new BorderLayout());

      ImageIcon image = createImage();
      JLabel label = new JLabel (image);
      contentPane.add (label, BorderLayout.CENTER);

      if (!splashscreen)
      {

         contentPane.add (new ScrollPanel (image.getIconWidth(), 150, 40, "de/uni_paderborn/fujaba/app/fujaba.who"), BorderLayout.SOUTH);
         label.addMouseListener (new EggMouseListener());
      }

      pack();
      centerDialog();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private ImageIcon createImage()
   {
      ImageIcon image = ImageResourceManager.get().getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/Splashscreen.gif");
      String versionText = "Version " + Version.get().toString();

      int width = image.getIconWidth();
      int height = image.getIconHeight();

      BufferedImage bufferedImage = new BufferedImage (width, height, BufferedImage.TYPE_INT_RGB);
      Graphics2D graphics = bufferedImage.createGraphics();
      graphics.drawImage (image.getImage(), 0, 0, null);

      graphics.setColor (Color.black);
      Font font = graphics.getFont();
      Rectangle2D rectangle = font.getStringBounds (versionText, graphics.getFontRenderContext());

      float stringWidth = new Double (rectangle.getWidth()).floatValue();
      float stringHeight = new Double (rectangle.getHeight()).floatValue();

      graphics.drawString (versionText, width - stringWidth - 20, height - stringHeight - 3);

      return new ImageIcon (bufferedImage);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void centerDialog()
   {
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension size = this.getSize();
      setLocation (screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
   }
}

/*
 * $Log: AboutBox.java,v $
 * Revision 1.59  2004/10/20 17:49:22  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
