/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.text.JTextComponent;

import de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Options panel for the project.
 *
 * @author    $Author: zuendorf $
 * @version   $Revision: 1.22.2.2 $
 */
public class OptionsPanelProject extends PreferencesPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textFieldProjectName = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textFieldProjectRootDir = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textFieldAdditionalClassPath = null;


   /**
    * Constructor for class OptionsPanelProject
    */
   public OptionsPanelProject()
   {
      setLayout (new PanelColumnLayout());

      textFieldProjectName = new JTextField (30);
      add (new JLabel ("Name of the current project:"));
      add (textFieldProjectName);

      textFieldProjectRootDir = new JTextField (30);
      add (new JLabel ("Name of the output root directory:"));
      add (textFieldProjectRootDir);

      textFieldAdditionalClassPath = new JTextField (30);
      add (new JLabel ("Additional classpath:"));
      add (textFieldAdditionalClassPath);

      textFieldProjectName.addFocusListener (new SelectAllFocusListener());
      textFieldProjectRootDir.addFocusListener (new SelectAllFocusListener());
      textFieldAdditionalClassPath.addFocusListener (new SelectAllFocusListener());

   } // constructor


   /**
    * Returns the preferred name of a tab for this panel
    *
    * @return   The preferredTabName value
    */
   public String getPreferredTabName()
   {
      return  ("Project");
   } // getPreferredTabName


   /**
    * Set all options to default values.
    */
   public void setDefaults()
   {
   } // setDefaults


   /**
    * Set the options in the panel, because the options can have changed elsewhere.
    */
   public void setPreferences()
   {
      UMLProject theProject = UMLProject.get();

      textFieldProjectName.setText (theProject.getName());
      textFieldProjectRootDir.setText (theProject.getRootDir());
      textFieldAdditionalClassPath.setText (theProject.getAdditionalClassPath());
   } // setOptions


   /**
    * Get all the options from the panel and set the real options.
    */
   public void okPressed()
   {
      UMLProject theProject = UMLProject.get();

      theProject.setName (textFieldProjectName.getText());
      theProject.setRootDir (textFieldProjectRootDir.getText());
      theProject.setAdditionalClassPath (textFieldAdditionalClassPath.getText());
   } // okPressed



   /**
    * Returns the current String written in the TextField 'Project Name'.
    *
    * @return   The projectName value
    */
   public String getProjectName()
   {
      return textFieldProjectName.getText();
   }


   /**
    * Returns the current String written in the TextField 'Root Directory'.
    *
    * @return   The rootDir value
    */
   public String getRootDir()
   {
      return textFieldProjectRootDir.getText();
   }


   /**
    * Sets the value in the TextField 'Project Name'.
    *
    * @param name  The new projectName value
    */
   public void setProjectName (String name)
   {
      if (name != null)
      {
         textFieldProjectName.setText (name);
      }
   }


   /**
    * Sets the value in the TextField 'Root Directory'.
    *
    * @param value  The new rootDir value
    */
   public void setRootDir (String value)
   {
      if (value != null)
      {
         textFieldProjectRootDir.setText (value);
      }
   }


   /**
    * When requesting focus for this Panel, it is transferred to the <code>textFieldProjectName</code>
    * .
    */
   public void requestFocus()
   {
      textFieldProjectName.requestFocus();
   }


   /**
    * This method adds an ActionListener to this OptionsPanelProject. That means the listener
    * is added to both the textFieldProjectName and the textFieldProjedctRootDir.
    *
    * @param al  The object added.
    */
   public void addActionListener (ActionListener al)
   {
      textFieldProjectRootDir.addActionListener (al);
      textFieldProjectName.addActionListener (al);
      textFieldAdditionalClassPath.addActionListener (al);
   }

} // OptionsPanelProject


/**
 * This Listener is designed for TextFields and TextAreas and will select all the text when
 * gaining focus.
 *
 * @author    $Author: zuendorf $
 * @version   $Revision: 1.22.2.2 $
 */
class SelectAllFocusListener extends FocusAdapter
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void focusGained (FocusEvent e)
   {
      Component c = e.getComponent();

      if (c instanceof TextComponent)
      {
          ((TextComponent) c).selectAll();
      }
      else
         if (c instanceof JTextComponent)
      {
          ((JTextComponent) c).selectAll();
      }
   }
}

/*
 * $Log: OptionsPanelProject.java,v $
 * Revision 1.22.2.2  2005/07/29 13:41:48  zuendorf
 * Renamed additionalClassPath Option
 * Some mnemonics for some dialogs.
 * Selection managment for Link editor adjusted. Objects are shown in the dialog in order of selection now.
 *
 */
