/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;


/**
 * A progress bar with detailed information.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.25 $
 */
public class ProgressBar extends JDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JButton cancel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int maxNr;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   int actNr;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean aborted;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel container = new JPanel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JLabel labelInfo = new JLabel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JLabel labelNr = new JLabel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JProgressBar progressBar = new JProgressBar();


   /**
    * Constructor for class ProgressBar
    *
    * @param f      No description provided
    * @param maxNr  No description provided
    * @param title  No description provided
    */
   public ProgressBar (JFrame f, int maxNr, String title)
   {
      super (f, title);

      this.maxNr = maxNr;

      setResizable (false);

      container.setBorder (new EmptyBorder (new Insets (15, 20, 20, 30)));
      container.setLayout (new BoxLayout (container, BoxLayout.Y_AXIS));

      JPanel cont = new JPanel();
      cont.setLayout (new BoxLayout (cont, BoxLayout.X_AXIS));
      cont.setAlignmentX (CENTER_ALIGNMENT);
      Dimension d = new Dimension (400, 20);
      cont.setMaximumSize (d);
      cont.setPreferredSize (d);

      d = new Dimension (300, 20);
      labelInfo.setPreferredSize (d);
      labelInfo.setMaximumSize (d);
      cont.add (labelInfo);

      d = new Dimension (100, 20);
      labelNr.setPreferredSize (d);
      labelNr.setMaximumSize (d);
      labelNr.setHorizontalAlignment (SwingConstants.RIGHT);
      cont.add (labelNr);

      container.add (cont);

      progressBar.setAlignmentX (CENTER_ALIGNMENT);
      progressBar.setMinimum (0);
      progressBar.setMaximum (maxNr);
      container.add (progressBar);

      JPanel buttonPanel = new JPanel();
      buttonPanel.setBorder (new EmptyBorder (new Insets (15, 0, 0, 0)));
      buttonPanel.setLayout (new FlowLayout (FlowLayout.CENTER));

      cancel = new JButton ("Cancel");
      cancel.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               invokeCancelPressed();
            }
         }
         );

      addWindowListener (
         new WindowAdapter()
         {
            public void windowClosing (WindowEvent e)
            {
               invokeCancelPressed();
            }
         }
         );

      buttonPanel.add (cancel);
      getRootPane().setDefaultButton (cancel);

      container.add (buttonPanel, BorderLayout.SOUTH);

      getContentPane().add (container);

      actNr = -1;
      increment ("Please wait...");

      pack();
      centerDialog();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void centerDialog()
   {
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      Dimension size = this.getSize();
      setLocation (screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param info  No description provided
    */
   public void increment (final String info)
   {
      Runnable doSetProgressBarValue =
         new Runnable()
         {
            public void run()
            {
               progressBar.setValue (++actNr);

               labelInfo.setText (info);
               labelNr.setText (String.valueOf (actNr) + " / " + String.valueOf (maxNr));
            }
         };

      SwingUtilities.invokeLater (doSetProgressBarValue);
   }


   /**
    * Get the aborted attribute of the ProgressBar object
    *
    * @return   The aborted value
    */
   public synchronized boolean isAborted()
   {
      return aborted;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   synchronized void invokeCancelPressed()
   {
      aborted = true;
   }
}

/*
 * $Log: ProgressBar.java,v $
 * Revision 1.25  2004/10/20 17:49:23  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
