/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Singleton ProgressBarWrapper gives a more comfortable access to the progress bar class,
 * in the future this two classes should be merged.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.17 $
 */
public class ProgressBarWrapper
{
   // We want a Progress Bar for some purpose
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ProgressBar myProgress = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JFrame frame;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int max;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String title;


   /**
    * The constructor.
    *
    * @param frame  No description provided
    * @param title  No description provided
    * @param max    No description provided
    */
   public ProgressBarWrapper (JFrame frame, String title, int max)
   {
      if (frame == null)
      {
         try
         {
            frame = UMLProject.get().getGui().getFrame();
         }
         catch (Exception e)
         {
            // if get fails, we generate a Frame
            frame = new JFrame();
         }
      }

      this.frame = frame;
      this.max = max;
      this.title = title;

      myProgress = null;
   }


   /**
    * With this function you can open a Progress Bar window for showing the current whatsoever
    * status.
    */
   public void openWindow()
   {
      myProgress = new ProgressBar (frame, max, title);
      myProgress.pack();
      myProgress.centerDialog();
      myProgress.show();
      myProgress.setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));
      myProgress.cancel.setCursor (Cursor.getPredefinedCursor (Cursor.DEFAULT_CURSOR));

      frame.setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));

      // lets wait for the painting a little bit
      try
      {
         Thread.sleep (100);
      }
      catch (InterruptedException e)
      {
      }
   } // initProgressWindow


   /**
    * This Function increments the progress of an initialized progress bar by one.
    *
    * @param statusText  No description provided
    */
   public void increment (String statusText)
   {
      // only do something, if progress bar window is initialized
      if (myProgress != null)
      {
         myProgress.increment (statusText);

         // lets wait for the painting a little bit
         try
         {
            Thread.sleep (100);
            // doesn't work in Java2: myProgress.paint (myProgress.getGraphics ());
            // doesn't work in Java2: myProgress.paintComponents (myProgress.getGraphics ());
         }
         catch (InterruptedException e)
         {
         }
      }
   } // setProgress


   /**
    * Get the aborted attribute of the ProgressBarWrapper object
    *
    * @return   The aborted value
    */
   public boolean isAborted()
   {
      return  (myProgress == null) || myProgress.isAborted();
   }


   /**
    * Finally close the progress bar window. Please invoke this method in a try-finally-block
    * to reset the cursor.
    */
   public void closeWindow()
   {
      frame.setCursor (Cursor.getPredefinedCursor (Cursor.DEFAULT_CURSOR));

      // only do something, if progress bar window is initialized
      if (myProgress != null)
      {
         // close
         myProgress.setCursor (Cursor.getPredefinedCursor (Cursor.DEFAULT_CURSOR));
         myProgress.setVisible (false);
      }
   } // closeProgressWindow

}

/*
 * $Log: ProgressBarWrapper.java,v $
 * Revision 1.17  2004/10/20 17:49:24  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
