/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.app.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.basic.FileHistory;
import de.upb.lib.userinterface.ElementInitializer;


/**
 * Open recent project from filelist
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
public class OpenRecentProjectAction extends ProjectNotSavedAction implements ElementInitializer
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (OpenRecentProjectAction.class);

   /**
    * File to be opened with this Action
    */
   private File file = null;

   /**
    * putValue doesn't work well for other attribs than name, so this is a fix...
    */

   private JMenuItem menuItem = null;


   /**
    * Sets the file attribute of the OpenRecentProjectAction object
    *
    * @param file  The new file value
    */
   public void setFile (File file)
   {
      if (this.file != file && file != null)
      {
         this.file = file;
         try
         {
            putValue (NAME, file.getName());
            putValue (SHORT_DESCRIPTION, file.getCanonicalPath());
            putValue (LONG_DESCRIPTION,
               "Loads the project file " + file.getCanonicalPath());
            putValue ("visible", Boolean.valueOf (false));

            if (menuItem != null)
            {
               menuItem.setToolTipText ("Open " + file.getCanonicalPath());
               menuItem.setVisible (true);
            }
         }
         catch (IOException e)
         {
            log.error ("OpenRecentProjectAction.setFile: Couldn't fetch data from file");
            putValue (NAME, "[unassigned fileHistory]");
            putValue (SHORT_DESCRIPTION, "");
            putValue (LONG_DESCRIPTION, "");
            putValue ("visible", Boolean.valueOf (false));

            if (menuItem != null)
            {
               menuItem.setToolTipText ("[unassigned fileHistory]");
               menuItem.setVisible (false);
            }
         }
      }
      else if (file == null)
      {
         putValue (NAME, "[unused fileHistory]");
         putValue (SHORT_DESCRIPTION, "");
         putValue (LONG_DESCRIPTION, "");
         putValue ("visible", Boolean.valueOf (false));

         if (menuItem != null)
         {
            menuItem.setToolTipText ("[unused fileHistory]");
            menuItem.setVisible (false);
         }
      }
   }


   /**
    * Get the file attribute of the OpenRecentProjectAction object
    *
    * @return   The file value
    */
   public File getFile()
   {
      return this.file;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      FrameMain myFrame = FrameMain.get();

      if (file == null)
      {
         log.error ("OpenRecentProjectAction.actionPerformed: This fileHistory item should not be visible, no file bound!");
         log.error ("Action called by " + e.getID() + "\n" + e.getSource());
         return;
      }

      if (confirmDialog() == JOptionPane.OK_OPTION)
      {
         if (this.file.exists() && this.file.isFile())
         {
            try
            {
               myFrame.setCursorWait();
               try
               {
                  myFrame.openFile (this.file);
               }
               finally
               {
                  myFrame.setCursorDefault();
               }
            }
            catch (Exception except)
            {
               except.printStackTrace();
               JOptionPane.showMessageDialog (myFrame.getFrame(),
                  "Loading of project failed: \n" + except.getMessage(),
                  "Load Project", JOptionPane.ERROR_MESSAGE);
               //This might cause access to removable drives! Floppy: "Grrrrt Grrrrt!" :(
               FileHistory.get().removeNotExistingFiles();
               FileHistory.get().updateActions();
            }
         }
         else
         {
            JOptionPane.showMessageDialog (myFrame.getFrame(),
               "Fujaba project file not found.",
               "Load project", JOptionPane.WARNING_MESSAGE);
            //This might cause access to removable drives! Floppy: "Grrrrt Grrrrt!" :(
            FileHistory.get().removeNotExistingFiles();
            FileHistory.get().updateActions();
         }
      }
   } // actionPerformed


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item    No description provided
    * @param source  No description provided
    */
   public void initialize (JComponent item, Object source)
   {
      putValue (Action.NAME, "[fileHistory]");

      //For some unknown reason, the following lines have no effect on JMenuItem...
      putValue (Action.SHORT_DESCRIPTION, "");
      putValue (Action.LONG_DESCRIPTION, "");
      putValue ("visible", Boolean.valueOf (false));

      if (item instanceof JMenuItem)
      {
         this.menuItem = (JMenuItem) item;
         //menuItem = new JMenuItem(menuItem.getIcon());
         this.menuItem.setText ("[fileHistory]"); //for debug only
         this.menuItem.setEnabled (true);
         this.menuItem.setVisible (false);
      }
   }
}

/*
 * $Log: OpenRecentProjectAction.java,v $
 * Revision 1.9  2004/10/20 17:49:25  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
