/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import java.util.Hashtable;

import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * This class caches class.forName calls, since these calls seem to be expensive.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.20 $
 */
public class ClassMap
{
   /**
    * The singleton instance.
    */
   private static ClassMap theInstance = null;


   /**
    * Default Constructor
    */
   private ClassMap() { }


   /**
    * Get and init the Singleton instance.
    *
    * @return   the Singleton instance
    */
   public static ClassMap get()
   {
      if (theInstance == null)
      {
         theInstance = new ClassMap();
         theInstance.init();
      }

      return theInstance;
   }


   /**
    * Fill classes with java basetypes (boolean, byte, char, short, int, long, float, and double).
    */
   private void init()
   {
      map.put ("boolean", Boolean.TYPE);
      map.put ("byte", Byte.TYPE);
      map.put ("char", Character.TYPE);
      map.put ("short", Short.TYPE);
      map.put ("int", Integer.TYPE);
      map.put ("long", Long.TYPE);
      map.put ("float", Float.TYPE);
      map.put ("double", Double.TYPE);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static Hashtable map = new Hashtable (128);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param name                     No description provided
    * @return                         No description provided
    * @throws ClassNotFoundException  Exception description not provided
    */
   public Class forName (String name) throws ClassNotFoundException
   {
      Class clazz = null;

      if (name != null && !name.equals ("null"))
      {
         clazz = (Class) map.get (name);

         if (clazz == null)
         {
            try
            {
               clazz = Thread.currentThread().getContextClassLoader().loadClass (name);
            }
            catch (Throwable t)
            {
               clazz = Class.forName (name, true, UPBClassLoader.get());
            }
            map.put (name, clazz);
         }
      }

      return clazz;
   } // forName


   /**
    * Try to find class 'name'.
    *
    * @param name  the name of class
    * @return      the class with class.getName() == 'name' or null , if class not found
    */
   public Class getClass (String name)
   {
      Class theClazz = null;

      try
      {
         theClazz = forName (name);
      }
      catch (ClassNotFoundException exception)
      {
         FujabaDebug.println ("ClassMap.get().getClass ( " + name + " ) \n" + exception);

         // safety first
         theClazz = null;
      }

      return theClazz;
   } // getClass

}

/*
 * $Log: ClassMap.java,v $
 * Revision 1.20  2004/10/20 17:49:27  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
