/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import java.awt.*;

import de.uni_paderborn.fujaba.asg.ASGElement;


/**
 * @author       $Author: trinet $
 * @version      $Revision: 1.13 $
 * @deprecated   replaced by {@link de.uni_paderborn.fujaba.asg.ASGUnparseInformation}
 */
public class PointIncrement extends BasicIncrement
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int x = Integer.MAX_VALUE;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int y = Integer.MAX_VALUE;


   /**
    * Constructor for loading
    */
   public PointIncrement()
   {
      this (null);
   }


   /**
    * Constructor for class PointIncrement
    *
    * @param value  No description provided
    */
   public PointIncrement (Point value)
   {
      setPoint (value);
   }


   /**
    * Sets the point attribute of the PointIncrement object
    *
    * @param value  The new point value
    */
   private void setPoint (Point value)
   {
      if (value == null)
      {
         x = Integer.MAX_VALUE;
         y = Integer.MAX_VALUE;
      }
      else
      {
         x = value.x;
         y = value.y;
      }

      if (notifyUponChange != null)
      {
         notifyUponChange.addPointToUnparseInformation (notifyUponChangeParent, notifyUponChangeProperty, getPoint());
      }
   }


   /**
    * setter for property x (for recognize change on load, do not remove!)
    *
    * @param x  new value for x
    */
   private void setX (int x)
   {
      setPoint (new Point (x, y));
   }


   /**
    * setter for property y (for recognize change on load, do not remove!)
    *
    * @param y  new value for y
    */
   private void setY (int y)
   {
      setPoint (new Point (x, y));
   }


   /**
    * Get the point attribute of the PointIncrement object
    *
    * @return   The point value
    */
   public Point getPoint()
   {
      Point result = null;
      if (! (x == Integer.MAX_VALUE && y == Integer.MAX_VALUE))
      {
         result = new Point (x, y);
      }
      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      return  ("PointIncrement [" + x + "," + y + "]");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      super.removeYou();
      x = Integer.MAX_VALUE;
      y = Integer.MAX_VALUE;
   }


   /**
    * for converting old fprs to new locations (ASGUnparseInformation)
    */
   private ASGElement notifyUponChange;
   /**
    * for converting old fprs to new locations (ASGUnparseInformation)
    */
   private ASGElement notifyUponChangeParent;
   /**
    * for converting old fprs to new locations (ASGUnparseInformation)
    */
   private String notifyUponChangeProperty;


   /**
    * for converting old fprs to new locations (ASGUnparseInformation)
    *
    * @param asgElement
    * @param parent
    * @param property
    */
   public void notifyUponChange (ASGElement asgElement, ASGElement parent, String property)
   {
      notifyUponChange = asgElement;
      notifyUponChangeParent = parent;
      notifyUponChangeProperty = property;
   }
}

/*
 * $Log: PointIncrement.java,v $
 * Revision 1.13  2004/11/08 19:16:11  trinet
 * changed saving of FSAProperties, added String support for Maps in BasicIncrement, some cleanup
 *
 */
