/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.basic;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 * This class is used as a comparator for UMLIncrements to sort them by name.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class TreeNodeComparator extends IncrementComparator
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param o1  No description provided
    * @param o2  No description provided
    * @return    No description provided
    */
   public int compare (Object o1, Object o2)
   {
      if (o1 instanceof DefaultMutableTreeNode &&
         o2 instanceof DefaultMutableTreeNode)
      {
         Object userO1 =  ((DefaultMutableTreeNode) o1).getUserObject();
         Object userO2 =  ((DefaultMutableTreeNode) o2).getUserObject();

         if ( (userO1 instanceof String) &&  (userO2 instanceof String))
         {
            return  ((String) userO1).compareTo ((String) userO2);
         } // end of if ()
         else
         {
            return super.compare (userO1, userO2);
         } // end of else

      } // end of if ()

      return o1.hashCode() - o2.hashCode();
   } // compare
}

/*
 * $Log: TreeNodeComparator.java,v $
 * Revision 1.11  2004/10/20 17:49:29  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
