/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLLink;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class LinkSearchToSetTopOOFunction
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.20.2.1 $
 */
public class LinkSearchToSetTopOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (LinkSearchToSetTopOOFunction.class);


   /**
    * Default Constructor
    */
   public LinkSearchToSetTopOOFunction() { }


   /**
    * Get the responsible attribute of the LinkSearchToSetTopOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.LINK_SEARCH_TO_SET_TOP.equals (methodName);
   }


   /**
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement asgElement, String methodName, Object param[])
   {
      UMLLink umlLink = (UMLLink) asgElement;
      UMLObject sourceObject = umlLink.getSource();
      UMLObject targetObject = umlLink.getTarget();

      // the target object must be the set
      if (!targetObject.isSet())
      {
         // swap source and target
         UMLObject tmpObject = sourceObject;
         sourceObject = targetObject;
         targetObject = tmpObject;
      }

      String sourceObjectName = sourceObject.getObjectName();
      String sourceObjectType = sourceObject.getObjectType();
      FType targetObjectType = targetObject.getInstanceOf();
      String targetObjectTypeStr = targetObject.getObjectType();
      String targetRoleName = umlLink.getCorrespondingRole (targetObject).getName();

      if (log.isDebugEnabled())
      {
         log.debug (this + ".linkSearchToSetTop(" + umlLink + ")");
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment ("linkSearchToSetTop"));

      String setName = CGU.downFirstChar (targetObject.getObjectName());
      OOVariable iterVar = OO.variable (CGU.upFirstChar (setName), OOVariableType.iFujabaIter);
      OOVariable tmpVar = OO.variable (targetObjectTypeStr, OOVariableType.iFujabaTmpObject);

      OOContainerType tmpContainerType = OO.containerType (OOCollectionEnum.HASHTABLE,
         OO.type (sourceObjectType, true));

      // define a new empty treeset.
      OOStatement.add (statements, OO.varDecl (tmpContainerType,
         OO.variable (setName),
         OO.newObject (tmpContainerType)));

      // temporary iterator declaration.
      OOStatement.add (statements, OO.varDecl ("FWIterator",
         iterVar,
         OO.call (sourceObjectName,
         OO.method (targetRoleName, OOMethodType.ITERATOR_OF_METHOD))));

      // begin while loop
      OOStatement.add (statements, OO.whileStat (OO.iterHasNext (iterVar, sourceObjectName,
         OO.type (sourceObjectType), true)));
      OOStatement.add (statements, OO.startBlock());

      // begin try block
      OOStatement.add (statements, new OOTryStatement());
      OOStatement.add (statements, OO.startBlock());

      // get next element of the iterator.
      OOStatement.add (statements, OO.varDecl (OO.type ("Object"), OO.variable (OOVariableType.iFujabaTmpObject), OO.iterGet (iterVar)));

      // ensure type
      OOStatement.add (statements, OO.ensure (new OOObjectOfTypeExpr (OOVariableType.iFujabaTmpObject, targetObjectTypeStr)));

      // cast
      OOLocalVarDeclStatement targetObjectVar = targetObjectType == null ?
         OO.varDecl (targetObjectTypeStr, tmpVar, OO.typeCast (targetObjectType, OOVariableType.iFujabaTmpObject)) :
         OO.varDecl (targetObjectType, tmpVar, OO.typeCast (targetObjectType, OOVariableType.iFujabaTmpObject));
      OOStatement.add (statements, targetObjectVar);

      OOStatement.add (statements, OO.emptyLine());

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "LinkSearchToSetTopOOFunction[]";
   }
}

/*
 * $Log: LinkSearchToSetTopOOFunction.java,v $
 * Revision 1.20.2.1  2005/07/13 11:24:50  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
