/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class MultiLinkSearchBoundToUnBoundOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14.2.2 $
 */
public class MultiLinkSearchBoundToUnBoundOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (MultiLinkSearchBoundToUnBoundOOFunction.class);


   /**
    * Default Constructor
    */
   public MultiLinkSearchBoundToUnBoundOOFunction() { }


   /**
    * Get the responsible attribute of the MultiLinkSearchBoundToUnBoundOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.MULTILINK_SEARCH_BOUND_TO_UNBOUND.equals (methodName);
   }


   /**
    * Bound -> UnBound MultiLink Search for direct, index multilinks and normal, optional objects
    * Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr,
                                     String methodName,
                                     Object param[])
   {
      String sourceObjectName;
      int umlSourceType;
      String targetObjectName;
      int umlTargetType;
      String objectType;
      String containerObjectName;
      String containerName;
      int multiLinkType;
      int index;
      String className;

      try
      {
         sourceObjectName = (String) param[0];
         umlSourceType =  ((Integer) param[1]).intValue();
         targetObjectName = (String) param[2];
         umlTargetType =  ((Integer) param[3]).intValue();
         objectType = (String) param[4];
         containerObjectName = (String) param[5];
         containerName = (String) param[6];
         multiLinkType =  ((Integer) param[7]).intValue();
         index =  ((Integer) param[8]).intValue();
         className = (String) param[9];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" + Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".multiLinkSearchBoundToUnBound("
            + "sourceObjectName=" + sourceObjectName
            + ",umlSourceType=" + umlSourceType
            + ",targetObjectName=" + targetObjectName
            + ",umlTargetType=" + umlTargetType
            + ",objectType=" + objectType
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            + ",multiLinkType=" + multiLinkType
            + ",index=" + index
            + ",className=" + className
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" multiLink bind " + targetObjectName +
         " : " + objectType + " multiLinkSearchBoundToUnBound"));

      OOVariable tmpObjectVar = OO.variable (OOVariableType.iFujabaTmpObject);
      OOVariable targetName = null;
      String methodObjectName = null;
      OOMethod accessMethod = null;
      OOCallMethodExpr theMethod = null;

      if (umlSourceType == UMLObject.OPTIONAL)
      {
         OOStatement.add (statements, OO.ifStat (OO.notNullExpr (sourceObjectName)));
         OOStatement.add (statements, OO.startBlock());
      }

      boolean typeCastNeeded = !objectType.equals (className);

      if (!typeCastNeeded)
      {
         //   result.append (newLine ()).append (targetObjectName);
         //  	 result.append (" = ").append ("(" + objectType + ")").append (containerObjectName).append (".");
         targetName = OO.variable (targetObjectName);
         methodObjectName = containerObjectName;
      }
      else
      {
         //   result.append (newLine ()).append (getIntVarName (iFujabaTmpObject));
         //  	 result.append (" = ").append (containerName).append (".");
         targetName = OO.variable (OOVariableType.iFujabaTmpObject);
         methodObjectName = containerName;

      }

      if (multiLinkType == UMLMultiLink.INDEX)
      {
         //   result.append (factory.getAccessMethodName (containerName, factory.GET_NEXT_INDEX_OF_METHOD)).append (" (");
         //  	 result.append (sourceObjectName).append (", ").append (index).append (")").append (";\n\n");
         accessMethod = OO.method (containerName, OOMethodType.GET_NEXT_INDEX_OF_METHOD);
         theMethod = OO.call (methodObjectName, accessMethod);
         theMethod.addToParameter (OO.identifier (sourceObjectName));
         theMethod.addToParameter (OO.identifier (Integer.toString (index)));
      }
      else
      {
         //   result.append (factory.getAccessMethodName (containerName, factory.GET_NEXT_OF_METHOD));
         //  	 result.append (" (").append (sourceObjectName).append (")").append (";\n\n");
         accessMethod = OO.method (containerName, OOMethodType.GET_NEXT_OF_METHOD);
         theMethod = OO.call (methodObjectName, accessMethod, OO.identifier (sourceObjectName));
      }

      if (!typeCastNeeded)
      {
         OOStatement.add (statements, OO.varDecl (objectType,
            targetName,
            OO.typeCast (objectType,
            theMethod)));
      }
      else
      {
         OOStatement.add (statements, OO.assignStat (targetName, theMethod));
      }

      if (umlTargetType == UMLObject.NORM)
      {
         if (typeCastNeeded)
         {
            //     result.append (newLine ()).append ("JavaSDM.ensure (");
            //  	    result.append (getIntVarName (iFujabaTmpObject)).append (" != null && ");
            //  	    result.append (getIntVarName (iFujabaTmpObject)).append (" instanceof ").append (objectType);
            //  	    result.append (");\n");
            OOStatement.add (statements, OO.ensure (OO.infixOp (OO.notNullExpr (tmpObjectVar),
               OOInfixOp.AND_OP,
               new OOObjectOfTypeExpr (tmpObjectVar,
               objectType))));

            //    result.append (newLine ()).append (targetObjectName).append (" = ").append ("(" + objectType + ")");
            //  	    result.append (getIntVarName (iFujabaTmpObject));
            //  	    result.append (";\n");
            OOStatement.add (statements, OO.assignStat (targetObjectName,
               OO.typeCast (objectType, tmpObjectVar)));
         }
         else
         {
            //    result.append (newLine ()).append ("JavaSDM.ensure (");
            //  	    result.append (targetObjectName).append (" != null").append (");\n\n");
            OOStatement.add (statements, OO.ensure (OO.notNullExpr (targetObjectName)));
            OOStatement.add (statements, OO.emptyLine());
         }
      }
      else if (umlTargetType == UMLObject.OPTIONAL && typeCastNeeded)
      {
         //   result.append (newLine ()).append ("if(").append (getIntVarName (iFujabaTmpObject)).append (" != null && ");
         //  	 result.append (getIntVarName (iFujabaTmpObject)).append (" instanceof ").append (objectType).append (")");
         OOStatement.add (statements, OO.ifStat (OO.infixOp (OO.notNullExpr (tmpObjectVar),
            OOInfixOp.AND_OP,
            new OOObjectOfTypeExpr (tmpObjectVar,
            objectType))));
         //  	 result.append (openBlockBracket ());
         //  	 incIndent ();
         OOStatement.add (statements, OO.startBlock());

         //   result.append (newLine ()).append (targetObjectName).append (" = ").append ("(" + objectType + ")");
         //  	 result.append (getIntVarName (iFujabaTmpObject));
         //  	 result.append (";\n");
         OOStatement.add (statements, OO.assignStat (targetObjectName,
            OO.typeCast (objectType, tmpObjectVar)));
         //   decIndent ();
         //  	 result.append (closeBlockBracket ("fi"));
         OOStatement.add (statements, OO.endBlock ("if"));
      }

      if (umlSourceType == UMLObject.OPTIONAL)
      {
         //   decIndent ();
         //  	 result.append (closeBlockBracket ("fi"));
         OOStatement.add (statements, OO.endBlock ("if"));
      }

//      for (int i = 0; i < umlAttrValuePairs.length; i++)
//      {
//         //   StringTokenizer token = new StringTokenizer (umlAttrValuePairs[i], "\n");
//         //  	 while (token.hasMoreTokens ())
//         //  	 {
//         //  	    result.append (newLine ()).append (token.nextToken ()).append ("\n");
//         //  	 }
//         OOStatement.add (statements, OO.exprStat (umlAttrValuePairs[i]));
//      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "MultiLinkSearchBoundToUnBoundOOFunction[]";
   }
}

/*
 * $Log: MultiLinkSearchBoundToUnBoundOOFunction.java,v $
 * Revision 1.14.2.2  2005/12/15 16:20:41  lowende
 * Removed a few compile warnings.
 *
 */
