/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLMultiLink;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * Class MultiLinkSearchUnBoundToBoundOOFunction
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16.2.5 $
 */
public class MultiLinkSearchUnBoundToBoundOOFunction extends OOGenFunction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (MultiLinkSearchUnBoundToBoundOOFunction.class);


   /**
    * Default Constructor
    */
   public MultiLinkSearchUnBoundToBoundOOFunction() { }


   /**
    * Get the responsible attribute of the MultiLinkSearchUnBoundToBoundOOFunction object
    *
    * @param methodName  No description provided
    * @return            The responsible value
    */
   public final boolean isResponsible (String methodName)
   {
      return OOGenStrategyHandler.MULTILINK_SEARCH_UNBOUND_TO_BOUND.equals (methodName);
   }


   /**
    * UnBound -> Bound MultiLink Search ** for direct, index multilinks and normal, optional
    * objects Describe <code>generateOOCode</code> method here.
    *
    * @param methodName  a <code>String</code> value
    * @param incr        No description provided
    * @param param       No description provided
    * @return            an <code>LinkedList[OOStatement]</code> value
    */
   public final Object generateCode (FElement incr, String methodName, Object param[])
   {
      String sourceObjectName;
      int umlSourceType;
      String targetObjectName;
      int umlTargetType;
      FType objectType;
      String objectTypeStr;
      String containerObjectName;
      String containerName;
      int multiLinkType;
      int index;
      String className;

      // parse param
      try
      {
         sourceObjectName = (String) param[0];
         umlSourceType =  ((Integer) param[1]).intValue();
         targetObjectName = (String) param[2];
         umlTargetType =  ((Integer) param[3]).intValue();
         objectType = (FType) param[4];
         objectTypeStr = (String) param[5];
         containerObjectName = (String) param[6];
         containerName = (String) param[7];
         multiLinkType =  ((Integer) param[8]).intValue();
         index =  ((Integer) param[9]).intValue();
         className = (String) param[10];
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" +
            Arrays.asList (param));
      }

      if (log.isDebugEnabled())
      {
         log.debug (this + ".multiLinkSearchUnboundToBound("
            + "sourceObjectName=" + sourceObjectName
            + ",umlSourceType=" + umlSourceType
            + ",targetObjectName=" + targetObjectName
            + ",umlTargetType=" + umlTargetType
            + ",objectType=" + objectType
            + ",containerObjectName=" + containerObjectName
            + ",containerName=" + containerName
            + ",multiLinkType=" + multiLinkType
            + ",index=" + index
            + ",className=" + className
            );
      }

      LinkedList statements = new LinkedList();

      OOStatement.add (statements, OO.lineComment (" multiLink bind " + sourceObjectName +
         " : " + objectType + " multiLinkSearchUnboundToBound"));

      int i;
      OOIdentifierExpr methodParameter[] = null;
      OOCallMethodExpr callMethod = null;
      OOMethod method = null;

      if (umlTargetType == UMLObject.OPTIONAL)
      {
         OOStatement.add (statements, OO.ifStat (OO.notNullExpr (targetObjectName)));
      }

      boolean typeCastNeeded = !objectType.getName().equals (className);

      if (multiLinkType == UMLMultiLink.INDEX)
      {
         method = OO.method (containerName, OOMethodType.GET_PREVIOUS_INDEX_OF_METHOD);
         methodParameter = new OOIdentifierExpr[]
            {OO.identifier (targetObjectName),
            OO.identifier (Integer.toString (index))};
      }
      else
      {
         method = OO.method (containerName, OOMethodType.GET_PREVIOUS_OF_METHOD);
         methodParameter = new OOIdentifierExpr[]
            {OO.identifier (targetObjectName)};
      }

      if (!typeCastNeeded)
      {
         callMethod = OO.call (containerObjectName,
            method);
         for (i = 0; i < methodParameter.length; i++)
         {
            callMethod.addToParameter (methodParameter[i]);
         }
         OOLocalVarDeclStatement objectVar = objectType == null ?
            OO.varDecl (objectTypeStr,
            sourceObjectName,
            OO.typeCast (objectType,
            callMethod)) :
            OO.varDecl (objectType,
            sourceObjectName,
            OO.typeCast (objectType,
            callMethod));
         OOStatement.add (statements, objectVar);
      }
      else
      {
         callMethod = OO.call (containerObjectName,
            method);
         for (i = 0; i < methodParameter.length; i++)
         {
            callMethod.addToParameter (methodParameter[i]);
         }
         OOStatement.add (statements, OO.assignStat (OOVariable.FUJABA_TMP_OBJECT,
            callMethod));

      }

      OOStatement.add (statements, OO.emptyLine());

      if (umlTargetType == UMLObject.NORM)
      {
         if (typeCastNeeded)
         {
            OOStatement.add (statements,
               OO.ensure (OO.infixOp (OO.notNullExpr (OOVariable.FUJABA_TMP_OBJECT),
               OOInfixOp.AND_OP,
               new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT,
               objectTypeStr))));

            OOStatement.add (statements, OO.varDecl (objectType, sourceObjectName,
               OO.typeCast (objectType, OOVariable.FUJABA_TMP_OBJECT)));
         }
         else
         {
            OOStatement.add (statements, OO.ensure (OO.notNullExpr (sourceObjectName)));
            OOStatement.add (statements, OO.emptyLine());
         }
      }
      else if (umlTargetType == UMLObject.OPTIONAL && typeCastNeeded)
      {
         OOStatement.add (statements, OO.ifStat (OO.infixOp (OO.notNullExpr (OOVariable.FUJABA_TMP_OBJECT),
            OOInfixOp.AND_OP,
            new OOObjectOfTypeExpr (OOVariable.FUJABA_TMP_OBJECT,
            objectTypeStr))));
         OOStatement.add (statements, OO.startBlock());
         OOStatement.add (statements, OO.assignStat (targetObjectName,
            OO.typeCast (objectType, OOVariable.FUJABA_TMP_OBJECT)));
         OOStatement.add (statements, OO.endBlock ("fi"));
      }

      if (umlTargetType == UMLObject.OPTIONAL)
      {
         OOStatement.add (statements, OO.endBlock ("fi"));
      }

//      for (i = 0; i < umlAttrValuePairs.length; i++)
//      {
//         OOStatement.add (statements, OO.exprStat (umlAttrValuePairs[i]));
//      }

      return statements;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "MultiLinkSearchUnBoundToBoundOOFunction[]";
   }
}

/*
 * $Log: MultiLinkSearchUnBoundToBoundOOFunction.java,v $
 * Revision 1.16.2.5  2005/12/15 16:20:42  lowende
 * Removed a few compile warnings.
 *
 */
