/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Iterator;
import java.util.Vector;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Class OO
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.24.2.1 $
 */
public final class OO
{
   /**
    * Default Constructor
    */
   private OO() { }

   // OOAssignment

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param variableName  No description provided
    * @param value         No description provided
    * @return              No description provided
    */
   public static OOAssignExpr assign (OOVariable variableName, OOExpression value)
   {
      return new OOAssignExpr (variableName,
         OOAssignOp.ASSIGNMENT_OP,
         value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param variableName  No description provided
    * @param value         No description provided
    * @return              No description provided
    */
   public static OOAssignExpr assign (OOSingleExpr variableName, OOExpression value)
   {
      return new OOAssignExpr (variableName,
         OOAssignOp.ASSIGNMENT_OP,
         value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param name   No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public static OOAssignExpr assign (String name, OOExpression value)
   {
      return new OOAssignExpr (OO.variable (name),
         OOAssignOp.ASSIGNMENT_OP,
         value);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param nameType  No description provided
    * @param value     No description provided
    * @return          No description provided
    */
   public static OOAssignExpr assign (OOVariableType nameType, OOExpression value)
   {
      return new OOAssignExpr (OO.variable (nameType),
         OOAssignOp.ASSIGNMENT_OP,
         value);
   }


   /**
    * Describe <code>assign</code> method here.
    *
    * @param variableName  an <code>OOVariable</code> value
    * @param value         an <code>OOExpression</code> value
    * @return              an <code>OOStatement</code> value
    */
   public static OOStatement assignStat (OOVariable variableName, OOExpression value)
   {
      return new OOExprStatement (new OOAssignExpr (variableName,
         OOAssignOp.ASSIGNMENT_OP,
         value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param variableName  No description provided
    * @param value         No description provided
    * @return              No description provided
    */
   public static OOStatement assignStat (OOSingleExpr variableName, OOExpression value)
   {
      return new OOExprStatement (new OOAssignExpr (variableName,
         OOAssignOp.ASSIGNMENT_OP,
         value));
   }


   /**
    * Describe <code>assign</code> method here.
    *
    * @param name   a <code>String</code> value
    * @param value  an <code>OOExpression</code> value
    * @return       an <code>OOStatement</code> value
    */
   public static OOStatement assignStat (String name, OOExpression value)
   {
      return new OOExprStatement (new OOAssignExpr (OO.variable (name),
         OOAssignOp.ASSIGNMENT_OP,
         value));
   }


   /**
    * Describe <code>assign</code> method here.
    *
    * @param nameType  an <code>OOVariableType</code> value
    * @param value     an <code>OOExpression</code> value
    * @return          an <code>OOStatement</code> value
    */
   public static OOStatement assignStat (OOVariableType nameType, OOExpression value)
   {
      return new OOExprStatement (new OOAssignExpr (OO.variable (nameType),
         OOAssignOp.ASSIGNMENT_OP,
         value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static OOBeginMethodBodyStatement beginMethodBody()
   {
      return new OOBeginMethodBodyStatement();
   }

   // call attr expr

   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName  an <code>OOVariable</code> value
    * @param attrName    an <code>OOVariable</code> value
    * @return            an <code>OOCallAttrExpr</code> value
    */
   public static OOCallAttrExpr callAttr (OOVariable objectName,
                                          OOVariable attrName)
   {
      return new OOCallAttrExpr (objectName, attrName);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @param attrName    No description provided
    * @param nextCall    No description provided
    * @return            No description provided
    */
   public static OOCallAttrExpr callAttr (OOVariable objectName,
                                          OOVariable attrName,
                                          OOCallExpr nextCall)
   {
      OOCallAttrExpr retExpr = new OOCallAttrExpr (objectName, attrName);

      retExpr.setNextCall (nextCall);

      return retExpr;
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName  an <code>OOVariable</code> value
    * @param attrName    an <code>OOVariable</code> value
    * @return            an <code>OOCallAttrExpr</code> value
    */
   public static OOStatement callAttrStat (OOVariable objectName,
                                           OOVariable attrName)
   {
      return new OOExprStatement (callAttr (objectName, attrName));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @param attrName    No description provided
    * @param nextCall    No description provided
    * @return            No description provided
    */
   public static OOStatement callAttrStat (OOVariable objectName,
                                           OOVariable attrName,
                                           OOCallExpr nextCall)
   {
      return new OOExprStatement (callAttr (objectName, attrName, nextCall));
   }

   // call method expr

   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName    an <code>OOVariable</code> value
    * @param methodName    an <code>OOMethod</code> value
    * @param theParameter  an <code>OOExpression</code> value
    * @return              an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (OOVariable objectName,
                                        OOMethod methodName,
                                        OOExpression theParameter)
   {
      return new OOCallMethodExpr (objectName, methodName, theParameter);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param methodType    an <code>OOMethodType</code> value
    * @param theParameter  an <code>OOExpression</code> value
    * @return              an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (OOMethodType methodType, OOExpression theParameter)
   {
      return new OOCallMethodExpr ((OOVariable) null, OO.method (methodType), theParameter);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param method        No description provided
    * @param theParameter  No description provided
    * @return              No description provided
    */
   public static OOCallMethodExpr call (OOMethod method, OOExpression theParameter)
   {
      return new OOCallMethodExpr ((OOVariable) null, method, theParameter);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param methodName  an <code>OOMethod</code> value
    * @return            an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (OOMethod methodName)
   {
      return new OOCallMethodExpr ((OOVariable) null, methodName, null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param methodType  an <code>OOMethodType</code> value
    * @return            an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (OOMethodType methodType)
   {
      return new OOCallMethodExpr ((OOVariable) null, OO.method (methodType), null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName  a <code>String</code> value
    * @param methodType  an <code>OOMethodType</code> value
    * @return            an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (String objectName, OOMethodType methodType)
   {
      return new OOCallMethodExpr (OO.variable (objectName), OO.method (methodType), null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName  a <code>String</code> value
    * @param method      an <code>OOMethod</code> value
    * @return            an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (String objectName, OOMethod method)
   {
      return new OOCallMethodExpr (OO.variable (objectName), method, null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param theVariable  an <code>OOVariable</code> value
    * @param methodType   an <code>OOMethodType</code> value
    * @return             an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (OOVariable theVariable, OOMethodType methodType)
   {
      return new OOCallMethodExpr (theVariable, OO.method (methodType), null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param theVariable  an <code>OOVariable</code> value
    * @param method       an <code>OOMethod</code> value
    * @return             an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (OOVariable theVariable, OOMethod method)
   {
      return new OOCallMethodExpr (theVariable, method, null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName  a <code>String</code> value
    * @param methodName  a <code>String</code> value
    * @return            an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (String objectName, String methodName)
   {
      return new OOCallMethodExpr (OO.variable (objectName), OO.method (methodName), null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param theVariable  an <code>OOVariable</code> value
    * @param methodName   a <code>String</code> value
    * @return             an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (OOVariable theVariable, String methodName)
   {
      return new OOCallMethodExpr (theVariable, OO.method (methodName), null);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName    a <code>String</code> value
    * @param method        an <code>OOMethod</code> value
    * @param theParameter  an <code>OOExpression</code> value
    * @return              an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (String objectName, OOMethod method, OOExpression theParameter)
   {
      return new OOCallMethodExpr (OO.variable (objectName), method, theParameter);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName    a <code>String</code> value
    * @param method        an <code>String</code> value
    * @param theParameter  an <code>OOExpression</code> value
    * @return              an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (String objectName, String method, OOExpression theParameter)
   {
      return new OOCallMethodExpr (OO.variable (objectName), OO.method (method), theParameter);
   }


   /**
    * Describe <code>call</code> method here.
    *
    * @param objectName    a <code>String</code> value
    * @param methodType    an <code>OOMethodType</code> value
    * @param theParameter  an <code>OOExpression</code> value
    * @return              an <code>OOCallMethodExpr</code> value
    */
   public static OOCallMethodExpr call (String objectName, OOMethodType methodType, OOExpression theParameter)
   {
      return new OOCallMethodExpr (OO.variable (objectName),
         OO.method (methodType),
         theParameter);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName    No description provided
    * @param methodName    No description provided
    * @param theParameter  No description provided
    * @return              No description provided
    */
   public static OOStatement callStat (OOVariable objectName,
                                       OOMethod methodName,
                                       OOExpression theParameter)
   {
      return new OOExprStatement (new OOCallMethodExpr (objectName,
         methodName,
         theParameter));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param methodType    No description provided
    * @param theParameter  No description provided
    * @return              No description provided
    */
   public static OOStatement callStat (OOMethodType methodType,
                                       OOExpression theParameter)
   {
      return new OOExprStatement (new OOCallMethodExpr ((OOVariable) null,
         OO.method (methodType),
         theParameter));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param methodName  No description provided
    * @return            No description provided
    */
   public static OOStatement callStat (OOMethod methodName)
   {
      return new OOExprStatement (new OOCallMethodExpr ((OOVariable) null,
         methodName, null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param methodType  No description provided
    * @return            No description provided
    */
   public static OOStatement callStat (OOMethodType methodType)
   {
      return new OOExprStatement (new OOCallMethodExpr ((OOVariable) null,
         OO.method (methodType),
         null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @param methodType  No description provided
    * @return            No description provided
    */
   public static OOStatement callStat (String objectName,
                                       OOMethodType methodType)
   {
      return new OOExprStatement (new OOCallMethodExpr (OO.variable (objectName),
         OO.method (methodType), null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @param method      No description provided
    * @return            No description provided
    */
   public static OOStatement callStat (String objectName,
                                       OOMethod method)
   {
      return new OOExprStatement (new OOCallMethodExpr (OO.variable (objectName),
         method,
         null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theVariable  No description provided
    * @param methodType   No description provided
    * @return             No description provided
    */
   public static OOStatement callStat (OOVariable theVariable,
                                       OOMethodType methodType)
   {
      return new OOExprStatement (new OOCallMethodExpr (theVariable,
         OO.method (methodType),
         null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theVariable  No description provided
    * @param method       No description provided
    * @return             No description provided
    */
   public static OOStatement callStat (OOVariable theVariable,
                                       OOMethod method)
   {
      return new OOExprStatement (new OOCallMethodExpr (theVariable,
         method,
         null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @param methodName  No description provided
    * @return            No description provided
    */
   public static OOStatement callStat (String objectName,
                                       String methodName)
   {
      return new OOExprStatement (new OOCallMethodExpr (OO.variable (objectName),
         OO.method (methodName),
         null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theVariable  No description provided
    * @param methodName   No description provided
    * @return             No description provided
    */
   public static OOStatement callStat (OOVariable theVariable,
                                       String methodName)
   {
      return new OOExprStatement (new OOCallMethodExpr (theVariable,
         OO.method (methodName),
         null));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName    No description provided
    * @param method        No description provided
    * @param theParameter  No description provided
    * @return              No description provided
    */
   public static OOStatement callStat (String objectName,
                                       OOMethod method,
                                       OOExpression theParameter)
   {
      return new OOExprStatement (new OOCallMethodExpr (OO.variable (objectName),
         method,
         theParameter));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName    No description provided
    * @param method        No description provided
    * @param theParameter  No description provided
    * @return              No description provided
    */
   public static OOStatement callStat (String objectName,
                                       String method,
                                       OOExpression theParameter)
   {
      return new OOExprStatement (new OOCallMethodExpr (OO.variable (objectName),
         OO.method (method),
         theParameter));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName    No description provided
    * @param methodType    No description provided
    * @param theParameter  No description provided
    * @return              No description provided
    */
   public static OOStatement callStat (String objectName,
                                       OOMethodType methodType,
                                       OOExpression theParameter)
   {
      return new OOExprStatement (new OOCallMethodExpr (OO.variable (objectName),
         OO.method (methodType),
         theParameter));
   }

   //OOCaseStatement

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value       No description provided
    * @param statements  No description provided
    * @return            No description provided
    */
   public static OOCaseStatement caseStatement (String value, Vector statements)
   {
      return new OOCaseStatement (value, statements);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param values      No description provided
    * @param statements  No description provided
    * @return            No description provided
    */
   public static OOCaseStatement caseStatement (Iterator values, Vector statements)
   {
      return new OOCaseStatement (values, statements);
   }

   // OOCatchStatement

   /**
    * Describe <code>catchStat</code> method here.
    *
    * @param exceptionType  an <code>OOExceptionExpr</code> value
    * @param exceptionName  an <code>OOVariable</code> value
    * @return               an <code>OOCatchStatement</code> value
    */
   public static OOCatchStatement catchStat (OOExceptionExpr exceptionType, OOVariable exceptionName)
   {
      return new OOCatchStatement (exceptionType, exceptionName);
   }

   // OOClassOfVariableExpr

   /**
    * Describe <code>classOf</code> method here.
    *
    * @param objectName  an <code>OOVariable</code> value
    * @return            an <code>OOClassOfVariableExpr</code> value
    */
   public static OOClassOfVariableExpr classOf (OOVariable objectName)
   {
      return new OOClassOfVariableExpr (objectName);
   }


   /**
    * Describe <code>classOf</code> method here.
    *
    * @param objectName  a <code>String</code> value
    * @return            an <code>OOClassOfVariableExpr</code> value
    */
   public static OOClassOfVariableExpr classOf (String objectName)
   {
      return new OOClassOfVariableExpr (OO.variable (objectName));
   }

   // OOContainerType

   /**
    * Describe <code>containerType</code> method here.
    *
    * @param collectionType  an <code>OOCollectionEnum</code> value
    * @param theParameter    No description provided
    * @return                an <code>OOContainerType</code> value
    */
   public static OOContainerType containerType (OOCollectionEnum collectionType,
                                                OOTypeInterface theParameter[])
   {
      return new OOContainerType (collectionType, theParameter);
   }


   /**
    * Describe <code>containerType</code> method here.
    *
    * @param cType      an <code>OOCollectionEnum</code> value
    * @param parameter  an <code>OOTypeInterface</code> value
    * @return           an <code>OOContainerType</code> value
    */
   public static OOContainerType containerType (OOCollectionEnum cType, OOTypeInterface parameter)
   {
      return new OOContainerType (cType, new OOTypeInterface[]{parameter});
   }


   /**
    * Describe <code>containerType</code> method here.
    *
    * @param cType      an <code>OOCollectionEnum</code> value
    * @param parameter  an <code>FType</code> value
    * @return           an <code>OOContainerType</code> value
    */
   public static OOContainerType containerType (OOCollectionEnum cType, FType parameter)
   {
      return new OOContainerType (cType, new OOTypeInterface[]{OO.type (parameter)});
   }


   /**
    * Describe <code>containerType</code> method here.
    *
    * @param cType      an <code>OOCollectionEnum</code> value
    * @param parameter  No description provided
    * @return           an <code>OOContainerType</code> value
    */
   public static OOContainerType containerType (OOCollectionEnum cType, String parameter[])
   {
      OOType theParameter[] = new OOType[parameter.length];
      int i;
      for (i = 0; i < parameter.length; i++)
      {
         theParameter[i] = OO.type (parameter[i]);
      }

      return new OOContainerType (cType, theParameter);
   }


   /**
    * Describe <code>containerType</code> method here.
    *
    * @param cType      an <code>OOCollectionEnum</code> value
    * @param parameter  No description provided
    * @return           an <code>OOContainerType</code> value
    */
   public static OOContainerType containerType (OOCollectionEnum cType, FType parameter[])
   {
      OOType theParameter[] = new OOType[parameter.length];
      int i;
      for (i = 0; i < parameter.length; i++)
      {
         theParameter[i] = OO.type (parameter[i]);
      }

      return new OOContainerType (cType, theParameter);
   }


   /**
    * Describe <code>containerType</code> method here.
    *
    * @param collectionType  an <code>OOCollectionEnum</code> value
    * @param parameter       a <code>String</code> value
    * @return                an <code>OOContainerType</code> value
    */
   public static OOContainerType containerType (OOCollectionEnum collectionType, String parameter)
   {
      return new OOContainerType (collectionType, new OOType[]{OO.type (parameter)});
   }

   // OOEmptyLineStatement

   /**
    * Describe <code>emptyLine</code> method here.
    *
    * @return   an <code>OOEmptyLineStatement</code> value
    */
   public static OOEmptyLineStatement emptyLine()
   {
      return new OOEmptyLineStatement();
   }

   // oo end block

   /**
    * Describe <code>endBlock</code> method here.
    *
    * @param text  a <code>String</code> value
    * @return      an <code>OOEndBlockStatement</code> value
    */
   public static OOEndBlockStatement endBlock (String text)
   {
      return new OOEndBlockStatement (text);
   }


   /**
    * Describe <code>endBlock</code> method here.
    *
    * @return   an <code>OOEndBlockStatement</code> value
    */
   public static OOEndBlockStatement endBlock()
   {
      return new OOEndBlockStatement (null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static OOEndMethodBodyStatement endMethodBody()
   {
      return new OOEndMethodBodyStatement();
   }

   // OOSDMEnsureStatement

   /**
    * Describe <code>ensure</code> method here.
    *
    * @param condition  an <code>OOExpression</code> value
    * @return           an <code>OOSDMEnsureStatement</code> value
    */
   public static OOSDMEnsureStatement ensure (OOExpression condition)
   {
      return new OOSDMEnsureStatement (condition);
   }


   /**
    * Describe <code>ensure</code> method here.
    *
    * @param condition  a <code>String</code> value
    * @return           an <code>OOSDMEnsureStatement</code> value
    */
   public static OOSDMEnsureStatement ensure (String condition)
   {
      return new OOSDMEnsureStatement (condition);
   }

   // OOUnitAssesrtStatement

   /**
    * Describe <code>ensure</code> method here.
    *
    * @param condition    an <code>OOExpression</code> value
    * @param description  No description provided
    * @return             an <code>OOSDMEnsureStatement</code> value
    */
   public static OOSDMEnsureStatement assertStmt (OOExpression condition, String description)
   {
      return new OOUnitAssertStatement (condition, description);
   }


   /**
    * Describe <code>ensure</code> method here.
    *
    * @param condition    a <code>String</code> value
    * @param description  No description provided
    * @return             an <code>OOSDMEnsureStatement</code> value
    */
   public static OOSDMEnsureStatement assertStmt (String condition, String description)
   {
      return new OOUnitAssertStatement (condition, description);
   }

   // OOExprStatement

   /**
    * Describe <code>expr</code> method here.
    *
    * @param expression  an <code>OOExpression</code> value
    * @return            an <code>OOExprStatement</code> value
    */
   public static OOExprStatement exprStat (OOExpression expression)
   {
      return new OOExprStatement (expression);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param initExpr  No description provided
    * @param endExpr   No description provided
    * @param stepExpr  No description provided
    * @return          No description provided
    */
   public static OOStatement forStat (OOExpression initExpr,
                                      OOExpression endExpr,
                                      OOExpression stepExpr)
   {
      return new OOForStatement (initExpr, endExpr, stepExpr);
   }

   // OOIdentifierExpr

   /**
    * Describe <code>identifier</code> method here.
    *
    * @param variable  an <code>OOVariable</code> value
    * @return          an <code>OOIdentifierExpr</code> value
    */
   public static OOIdentifierExpr identifier (OOVariable variable)
   {
      return new OOIdentifierExpr (variable);
   }


   /**
    * Describe <code>identifier</code> method here.
    *
    * @param variableType  an <code>OOVariableType</code> value
    * @return              an <code>OOIdentifierExpr</code> value
    */
   public static OOIdentifierExpr identifier (OOVariableType variableType)
   {
      return new OOIdentifierExpr (OO.variable (variableType));
   }


   /**
    * Describe <code>identifier</code> method here.
    *
    * @param ident  a <code>String</code> value
    * @return       an <code>OOIdentifierExpr</code> value
    */
   public static OOIdentifierExpr identifier (String ident)
   {
      return new OOIdentifierExpr (OO.variable (ident));
   }

   // OOIfStatement

   /**
    * Describe <code>ifStat</code> method here.
    *
    * @param condition  an <code>OOExpression</code> value
    * @return           an <code>OOIfStatement</code> value
    */
   public static OOIfStatement ifStat (OOExpression condition)
   {
      return new OOIfStatement (condition);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param conditionString  No description provided
    * @return                 No description provided
    */
   public static OOIfStatement ifStat (String conditionString)
   {
      return new OOIfStatement (OO.identifier (conditionString));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param left   No description provided
    * @param theOp  No description provided
    * @param right  No description provided
    * @return       No description provided
    */
   public static OOInfixExprLeft infixOp (OOExpression left, OOInfixOp theOp, OOExpression right)
   {
      OOInfixExprLeft leftExp = new OOInfixExprLeft (left);

      leftExp.setRightExp (new OOInfixExprRight (theOp, right));

      return leftExp;
   }


   /**
    * Get the nullExpr attribute of the OO class
    *
    * @param objectName  No description provided
    * @return            The nullExpr value
    */
   public static OOInfixExprLeft isNullExpr (String objectName)
   {
      return isNullExpr (new OOIdentifierExpr (OO.variable (objectName)));
   }


   /**
    * Get the nullExpr attribute of the OO class
    *
    * @param objectName  No description provided
    * @return            The nullExpr value
    */
   public static OOInfixExprLeft isNullExpr (OOVariable objectName)
   {
      return isNullExpr (new OOIdentifierExpr (objectName));
   }


   /**
    * Get the nullExpr attribute of the OO class
    *
    * @param theExpr  No description provided
    * @return         The nullExpr value
    */
   public static OOInfixExprLeft isNullExpr (OOExpression theExpr)
   {
      return infixOp (theExpr,
         OOInfixOp.EQUAL_OP,
         OOIdentifierExpr.NULL_IDENTIFIER);
   }

   // OOFWIteratorOfExpr

   /**
    * Describe <code>iterOf</code> method here.
    *
    * @param objectName  an <code>OOVariable</code> value
    * @return            an <code>OOFWIteratorOfExpr</code> value
    */
   public static OOFWIteratorOfExpr iterOf (OOVariable objectName)
   {
      return new OOFWIteratorOfExpr (objectName);
   }


   /**
    * Describe <code>iterOf</code> method here.
    *
    * @param objectName  a <code>String</code> value
    * @return            an <code>OOFWIteratorOfExpr</code> value
    */
   public static OOFWIteratorOfExpr iterOf (String objectName)
   {
      return new OOFWIteratorOfExpr (OO.variable (objectName));
   }

   // OOFWIteratorHasNextExpr

   /**
    * Describe <code>iterHasNext</code> method here.
    *
    * @param iterName         an <code>OOVariable</code> value
    * @param objectName       an <code>OOVariable</code> value
    * @param elemType         an <code>OOType</code> value
    * @param useAccessMethod  a <code>boolean</code> value
    * @return                 an <code>OOFWIteratorHasNextExpr</code> value
    */
   public static OOFWIteratorHasNextExpr iterHasNext (OOVariable iterName,
                                                      OOVariable objectName,
                                                      OOType elemType,
                                                      boolean useAccessMethod)
   {
      return new OOFWIteratorHasNextExpr (iterName, objectName, elemType, useAccessMethod);
   }


   /**
    * Describe <code>iterHasNext</code> method here.
    *
    * @param iterName         an <code>OOVariable</code> value
    * @param objectName       a <code>String</code> value
    * @param elemType         an <code>OOType</code> value
    * @param useAccessMethod  a <code>boolean</code> value
    * @return                 an <code>OOFWIteratorHasNextExpr</code> value
    */
   public static OOFWIteratorHasNextExpr iterHasNext (OOVariable iterName,
                                                      String objectName,
                                                      OOType elemType,
                                                      boolean useAccessMethod)
   {
      return new OOFWIteratorHasNextExpr (iterName, OO.variable (objectName), elemType, useAccessMethod);
   }


   /**
    * Describe <code>iterHasNext</code> method here.
    *
    * @param iterName    an <code>OOVariable</code> value
    * @param objectName  an <code>OOVariable</code> value
    * @return            an <code>OOFWIteratorHasNextExpr</code> value
    */
   public static OOFWIteratorHasNextExpr iterHasNext (OOVariable iterName,
                                                      OOVariable objectName)
   {
      return new OOFWIteratorHasNextExpr (iterName, objectName, null, false);
   }


   /**
    * Describe <code>iterHasNext</code> method here.
    *
    * @param iterName    an <code>OOVariable</code> value
    * @param objectName  a <code>String</code> value
    * @return            an <code>OOFWIteratorHasNextExpr</code> value
    */
   public static OOFWIteratorHasNextExpr iterHasNext (OOVariable iterName,
                                                      String objectName)
   {
      return new OOFWIteratorHasNextExpr (iterName, OO.variable (objectName), null, false);
   }

   // OOFWIteratorGetExpr

   /**
    * Describe <code>iterGet</code> method here.
    *
    * @param objectName  an <code>OOVariable</code> value
    * @return            an <code>OOFWIteratorGetExpr</code> value
    */
   public static OOFWIteratorGetExpr iterGet (OOVariable objectName)
   {
      return new OOFWIteratorGetExpr (objectName);
   }


   /**
    * Describe <code>iterGet</code> method here.
    *
    * @param objectName  a <code>String</code> value
    * @return            an <code>OOFWIteratorGetExpr</code> value
    */
   public static OOFWIteratorGetExpr iterGet (String objectName)
   {
      return new OOFWIteratorGetExpr (OO.variable (objectName));
   }

   // OOFWIteratorGotoNextExpr

   /**
    * Describe <code>iterGotoNext</code> method here.
    *
    * @param iterName  an <code>OOVariable</code> value
    * @return          an <code>OOFWIteratorGotoNextExpr</code> value
    */
   public static OOFWIteratorGotoNextExpr iterGotoNext (OOVariable iterName)
   {
      return new OOFWIteratorGotoNextExpr (iterName);
   }

   // OOLineCommentStatement

   /**
    * Describe <code>lineComment</code> method here.
    *
    * @param text  a <code>String</code> value
    * @return      an <code>OOLineCommentStatement</code> value
    */
   public static OOLineCommentStatement lineComment (String text)
   {
      return new OOLineCommentStatement (text);
   }

   // OOMethod

   /**
    * Describe <code>method</code> method here.
    *
    * @param containerName  a <code>String</code> value
    * @param type           an <code>OOMethodType</code> value
    * @return               an <code>OOMethod</code> value
    */
   public static OOMethod method (String containerName, OOMethodType type)
   {
      return new OOMethod (containerName, type);
   }


   /**
    * Describe <code>method</code> method here.
    *
    * @param type  an <code>OOMethodType</code> value
    * @return      an <code>OOMethod</code> value
    */
   public static OOMethod method (OOMethodType type)
   {
      return new OOMethod ("", type);
   }


   /**
    * Describe <code>method</code> method here.
    *
    * @param name  a <code>String</code> value
    * @return      an <code>OOMethod</code> value
    */
   public static OOMethod method (String name)
   {
      return new OOMethod (name, OOMethodType.DEFAULT_METHOD);
   }

   // OONewObjectExpr

   /**
    * Describe <code>newObject</code> method here.
    *
    * @param varType    an <code>OOTypeInterface</code> value
    * @param parameter  an <code>OOExpression</code> value
    * @return           an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (OOTypeInterface varType,
                                            OOExpression parameter)
   {
      return new OONewObjectExpr (varType, parameter);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param typeName   a <code>String</code> value
    * @param parameter  an <code>OOExpression</code> value
    * @return           an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (String typeName, OOExpression parameter)
   {
      return new OONewObjectExpr (OO.type (typeName), parameter);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param type       an <code>FType</code> value
    * @param parameter  an <code>OOExpression</code> value
    * @return           an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (FType type, OOExpression parameter)
   {
      return new OONewObjectExpr (OO.type (type), parameter);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param containerType  an <code>OOCollectionEnum</code> value
    * @param elemType       an <code>FType</code> value
    * @param parameter      an <code>OOExpression</code> value
    * @return               an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (OOCollectionEnum containerType, FType elemType, OOExpression parameter)
   {
      return new OONewObjectExpr (OO.containerType (containerType, elemType), parameter);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param containerType  an <code>OOCollectionEnum</code> value
    * @param elemTypeName   a <code>String</code> value
    * @param parameter      an <code>OOExpression</code> value
    * @return               an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (OOCollectionEnum containerType, String elemTypeName, OOExpression parameter)
   {
      return new OONewObjectExpr (OO.containerType (containerType, elemTypeName), parameter);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param containerType  an <code>OOCollectionEnum</code> value
    * @param elemType       an <code>FType</code> value
    * @return               an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (OOCollectionEnum containerType, FType elemType)
   {
      return new OONewObjectExpr (OO.containerType (containerType, elemType), null);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param containerType  an <code>OOCollectionEnum</code> value
    * @param elemTypeName   a <code>String</code> value
    * @return               an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (OOCollectionEnum containerType, String elemTypeName)
   {
      return new OONewObjectExpr (OO.containerType (containerType, elemTypeName), null);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param type  an <code>OOTypeInterface</code> value
    * @return      an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (OOTypeInterface type)
   {
      return new OONewObjectExpr (type, null);
   }


   /**
    * Describe <code>newObject</code> method here.
    *
    * @param typeName  a <code>String</code> value
    * @return          an <code>OONewObjectExpr</code> value
    */
   public static OONewObjectExpr newObject (String typeName)
   {
      return new OONewObjectExpr (OO.type (typeName), null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type  No description provided
    * @return      No description provided
    */
   public static OONewObjectExpr newObject (FType type)
   {
      return new OONewObjectExpr (OO.type (type), null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elementType  No description provided
    * @param size         No description provided
    * @return             No description provided
    */
   public static OONewArrayExpr newArray (FType elementType, OOExpression size)
   {
      return new OONewArrayExpr (OO.type (elementType), size);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param arrayType  No description provided
    * @param size       No description provided
    * @return           No description provided
    */
   public static OONewArrayExpr newArray (FArray arrayType, OOExpression size)
   {
      return new OONewArrayExpr (OO.type (arrayType.getFArrayType()), size);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elementType  No description provided
    * @param size         No description provided
    * @return             No description provided
    */
   public static OONewArrayExpr newArray (String elementType, OOExpression size)
   {
      return new OONewArrayExpr (OO.type (elementType), size);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theExpr  No description provided
    * @return         No description provided
    */
   public static OOPrefixExpr not (OOExpression theExpr)
   {
      return new OOPrefixExpr (OOPrefixOp.NOT_OP, theExpr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param varName  No description provided
    * @return         No description provided
    */
   public static OOPrefixExpr not (OOVariable varName)
   {
      return not (new OOIdentifierExpr (varName));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @return            No description provided
    */
   public static OOInfixExprLeft notNullExpr (String objectName)
   {
      return notNullExpr (new OOIdentifierExpr (OO.variable (objectName)));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectType  No description provided
    * @return            No description provided
    */
   public static OOInfixExprLeft notNullExpr (OOVariableType objectType)
   {
      return notNullExpr (new OOIdentifierExpr (OO.variable (objectType)));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectName  No description provided
    * @return            No description provided
    */
   public static OOInfixExprLeft notNullExpr (OOVariable objectName)
   {
      return notNullExpr (new OOIdentifierExpr (objectName));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theExpr  No description provided
    * @return         No description provided
    */
   public static OOInfixExprLeft notNullExpr (OOExpression theExpr)
   {
      return infixOp (theExpr,
         OOInfixOp.NOT_EQUAL_OP,
         OOIdentifierExpr.NULL_IDENTIFIER);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param op       No description provided
    * @param theExpr  No description provided
    * @return         No description provided
    */
   public static OOPrefixExpr prefixOp (OOPrefixOp op, OOExpression theExpr)
   {
      return new OOPrefixExpr (op, theExpr);
   }

   // OOReturnStatement

   /**
    * Describe <code>returnStat</code> method here.
    *
    * @param returnValueName  a <code>String</code> value
    * @return                 an <code>OOReturnStatement</code> value
    */
   public static OOReturnStatement returnStat (String returnValueName)
   {
      return new OOReturnStatement (returnValueName);
   }


   /**
    * Describe <code>returnStat</code> method here.
    *
    * @param returnValue  an <code>OOExpression</code> value
    * @return             an <code>OOReturnStatement</code> value
    */
   public static OOReturnStatement returnStat (OOExpression returnValue)
   {
      return new OOReturnStatement (returnValue);
   }

   // OOStartBlockStatement

   /**
    * Describe <code>startBlock</code> method here.
    *
    * @return   an <code>OOStartBlockStatement</code> value
    */
   public static OOStartBlockStatement startBlock()
   {
      return new OOStartBlockStatement();
   }


   /**
    * create OOLocalVarDeclStatement with variable OOVariableType.iFujaba
    *
    * @param id  the "assign to" OOIdentifierExpr
    * @return    an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement fujabaSuccess (OOIdentifierExpr id)
   {
      return new OOLocalVarDeclStatement (OO.type (UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN)),
         OOVariable.FUJABA_SUCCESS,
         id);
   }

   //OOSwitchCaseStatement

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param variable  No description provided
    * @param cases     No description provided
    * @return          No description provided
    */
   public static OOSwitchCaseStatement switchCaseStatement (OOVariable variable, Iterator cases)
   {
      return new OOSwitchCaseStatement (variable, cases);
   }

   // OOType

   /**
    * Describe <code>type</code> method here.
    *
    * @param type  an <code>FType</code> value
    * @return      an <code>OOType</code> value
    */
   public static OOType type (FType type)
   {
      return new OOType (type, OOType.EMPTY_TYPENAME, false);
   }


   /**
    * Describe <code>type</code> method here.
    *
    * @param type     an <code>FType</code> value
    * @param pointer  a <code>boolean</code> value
    * @return         an <code>OOType</code> value
    */
   public static OOType type (FType type, boolean pointer)
   {
      return new OOType (type, OOType.EMPTY_TYPENAME, pointer);
   }


   /**
    * Describe <code>type</code> method here.
    *
    * @param typeName  a <code>String</code> value
    * @return          an <code>OOType</code> value
    */
   public static OOType type (String typeName)
   {
      return new OOType (OOType.EMPTY_TYPE, typeName, false);
   }


   /**
    * Describe <code>type</code> method here.
    *
    * @param typeName  a <code>String</code> value
    * @param pointer   a <code>boolean</code> value
    * @return          an <code>OOType</code> value
    */
   public static OOType type (String typeName, boolean pointer)
   {
      return new OOType (OOType.EMPTY_TYPE, typeName, pointer);
   }

   // OOExceptionExpr

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type  No description provided
    * @return      No description provided
    */
   public static OOExceptionExpr exception (FType type)
   {
      return new OOExceptionExpr (OO.type (type));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param typeName  No description provided
    * @return          No description provided
    */
   public static OOExceptionExpr exception (String typeName)
   {
      return new OOExceptionExpr (OO.type (typeName));
   }

   // OOObjectOfType

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param object  No description provided
    * @param type    No description provided
    * @return        No description provided
    */
   public static OOObjectOfTypeExpr objectOfType (OOVariable object, FType type)
   {
      return new OOObjectOfTypeExpr (object, OO.type (type));
   }

   // OOTypeCastExpr

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type        No description provided
    * @param castSource  No description provided
    * @return            No description provided
    */
   public static OOTypeCastExpr typeCast (FType type, OOExpression castSource)
   {
      return new OOTypeCastExpr (OO.type (type), castSource);
   }


   /**
    * Describe <code>typeCast</code> method here.
    *
    * @param typeName    a <code>String</code> value
    * @param castSource  an <code>OOExpression</code> value
    * @return            an <code>OOTypeCastExpr</code> value
    */
   public static OOTypeCastExpr typeCast (String typeName, OOExpression castSource)
   {
      return new OOTypeCastExpr (OO.type (typeName), castSource);
   }


   /**
    * Describe <code>typeCast</code> method here.
    *
    * @param typeName    a <code>String</code> value
    * @param castSource  an <code>OOVariable</code> value
    * @return            an <code>OOTypeCastExpr</code> value
    */
   public static OOTypeCastExpr typeCast (String typeName, OOVariable castSource)
   {
      return new OOTypeCastExpr (OO.type (typeName), OO.identifier (castSource));
   }


   /**
    * Describe <code>typeCast</code> method here.
    *
    * @param typeName        a <code>String</code> value
    * @param castSourceType  an <code>OOVariableType</code> value
    * @return                an <code>OOTypeCastExpr</code> value
    */
   public static OOTypeCastExpr typeCast (String typeName, OOVariableType castSourceType)
   {
      return new OOTypeCastExpr (OO.type (typeName), OO.identifier (castSourceType));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param typeName        No description provided
    * @param castSourceType  No description provided
    * @return                No description provided
    */
   public static OOTypeCastExpr typeCast (FType typeName, OOVariableType castSourceType)
   {
      return new OOTypeCastExpr (OO.type (typeName), OO.identifier (castSourceType));
   }
   // OOLocalVarDeclStatement

   /**
    * Describe <code>varDecl</code> method here.
    *
    * @param varType     an <code>OOTypeInterface</code> value
    * @param objectName  an <code>OOVariable</code> value
    * @param initExpr    an <code>OOExpression</code> value
    * @return            an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement varDecl (OOTypeInterface varType,
                                                  OOVariable objectName,
                                                  OOExpression initExpr)
   {
      return new OOLocalVarDeclStatement (varType, objectName, initExpr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param varType     No description provided
    * @param objectName  No description provided
    * @return            No description provided
    */
   public static OOLocalVarDeclStatement varDecl (OOTypeInterface varType,
                                                  OOVariable objectName)
   {
      return new OOLocalVarDeclStatement (varType, objectName, null);
   }


   /**
    * Describe <code>varDecl</code> method here.
    *
    * @param objectTypeName  a <code>String</code> value
    * @param objectName      an <code>OOVariable</code> value
    * @param initExpr        an <code>OOExpression</code> value
    * @return                an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement varDecl (String objectTypeName,
                                                  OOVariable objectName,
                                                  OOExpression initExpr)
   {
      return new OOLocalVarDeclStatement (OO.type (objectTypeName), objectName, initExpr);
   }


   /**
    * Describe <code>varDecl</code> method here.
    *
    * @param objectType  an <code>FType</code> value
    * @param objectName  an <code>OOVariable</code> value
    * @param initExpr    an <code>OOExpression</code> value
    * @return            an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement varDecl (FType objectType,
                                                  OOVariable objectName,
                                                  OOExpression initExpr)
   {
      return new OOLocalVarDeclStatement (OO.type (objectType), objectName, initExpr);
   }


   /**
    * Describe <code>varDecl</code> method here.
    *
    * @param theOther  an <code>OOLocalVarDeclStatement</code> value
    * @return          an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement varDecl (OOLocalVarDeclStatement theOther)
   {
      return new OOLocalVarDeclStatement (theOther.getVarType(),
         theOther.getObjectName(),
         theOther.getInitExpr());
   }


   /**
    * Describe <code>varDecl</code> method here.
    *
    * @param objectTypeName  a <code>String</code> value
    * @param objectName      a <code>String</code> value
    * @param initExpr        an <code>OOExpression</code> value
    * @return                an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement varDecl (String objectTypeName,
                                                  String objectName,
                                                  OOExpression initExpr)
   {
      return new OOLocalVarDeclStatement (OO.type (objectTypeName), OO.variable (objectName), initExpr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param objectType  No description provided
    * @param objectName  No description provided
    * @param initExpr    No description provided
    * @return            No description provided
    */
   public static OOLocalVarDeclStatement varDecl (FType objectType,
                                                  String objectName,
                                                  OOExpression initExpr)
   {
      return new OOLocalVarDeclStatement (OO.type (objectType), OO.variable (objectName), initExpr);
   }


   /**
    * Describe <code>varDecl</code> method here.
    *
    * @param containerType  an <code>OOCollectionEnum</code> value
    * @param objectType     an <code>FType</code> value
    * @param objectName     a <code>String</code> value
    * @param initExpr       an <code>OOExpression</code> value
    * @return               an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement varDecl (OOCollectionEnum containerType,
                                                  FType objectType,
                                                  String objectName,
                                                  OOExpression initExpr)
   {
      return new OOLocalVarDeclStatement (OO.containerType (containerType, objectType),
         OO.variable (objectName),
         initExpr);
   }


   /**
    * Describe <code>varDecl</code> method here.
    *
    * @param containerType   an <code>OOCollectionEnum</code> value
    * @param objectTypeName  a <code>String</code> value
    * @param objectName      an <code>OOVariable</code> value
    * @param initExpr        an <code>OOExpression</code> value
    * @return                an <code>OOLocalVarDeclStatement</code> value
    */
   public static OOLocalVarDeclStatement varDecl (OOCollectionEnum containerType,
                                                  String objectTypeName,
                                                  OOVariable objectName,
                                                  OOExpression initExpr)
   {
      return new OOLocalVarDeclStatement (OO.containerType (containerType, objectTypeName),
         objectName,
         initExpr);
   }


   // OOVariable
   /**
    * create an instance of OOVariable (firstName="", type=OOVariableType.iFujabaOrig, secondName="")
    * ;
    *
    * @param firstName   a <code>String</code> value
    * @param type        an <code>OOVariableType</code> value
    * @param secondName  a <code>String</code> value
    * @return            an <code>OOVariable</code> value
    */
   public static OOVariable variable (String firstName, OOVariableType type, String secondName)
   {
      return new OOVariable (firstName, type, secondName);
   }


   /**
    * Describe <code>variable</code> method here.
    *
    * @param type  an <code>OOVariableType</code> value
    * @return      an <code>OOVariable</code> value
    */
   public static OOVariable variable (OOVariableType type)
   {
      return new OOVariable ("", type, "");
   }


   /**
    * Describe <code>variable</code> method here.
    *
    * @param firstName  a <code>String</code> value
    * @return           an <code>OOVariable</code> value
    */
   public static OOVariable variable (String firstName)
   {
      return new OOVariable (firstName, OOVariableType.iFujabaOrig, "");
   }


   /**
    * Describe <code>variable</code> method here.
    *
    * @param firstName  a <code>String</code> value
    * @param type       an <code>OOVariableType</code> value
    * @return           an <code>OOVariable</code> value
    */
   public static OOVariable variable (String firstName, OOVariableType type)
   {
      return new OOVariable (firstName, type, "");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param type        No description provided
    * @param secondName  No description provided
    * @return            No description provided
    */
   public static OOVariable variable (OOVariableType type, String secondName)
   {
      return new OOVariable ("", type, secondName);
   }

   // OOWhileStatement

   /**
    * Describe <code>whileStat</code> method here.
    *
    * @param condition  an <code>OOExpression</code> value
    * @return           an <code>OOWhileStatement</code> value
    */
   public static OOWhileStatement whileStat (OOExpression condition)
   {
      return new OOWhileStatement (condition, false);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param conditionString  No description provided
    * @return                 No description provided
    */
   public static OOWhileStatement whileStat (String conditionString)
   {
      return new OOWhileStatement (OO.identifier (conditionString), false);
   }


   /**
    * Describe <code>whileStat</code> method here.
    *
    * @param condition  an <code>OOExpression</code> value
    * @param foot       a <code>boolean</code> value
    * @return           an <code>OOWhileStatement</code> value
    */
   public static OOWhileStatement whileStat (OOExpression condition, boolean foot)
   {
      return new OOWhileStatement (condition, foot);
   }


   /**
    * Describe <code>toString</code> method here.
    *
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOF[]";
   }
}

/*
 * $Log: OO.java,v $
 * Revision 1.24.2.1  2005/07/13 11:24:50  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
