/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * Class OOFWIteratorHasNextExpr
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class OOFWIteratorHasNextExpr
    extends OOSingleExpr
{
   /**
    * Default Constructor
    */
   private OOFWIteratorHasNextExpr() { }


   /**
    * Constructor for class OOFWIteratorHasNextExpr
    *
    * @param iterName         No description provided
    * @param objectName       No description provided
    * @param elemType         No description provided
    * @param useAccessMethod  No description provided
    */
   public OOFWIteratorHasNextExpr (OOVariable iterName,
                                   OOVariable objectName,
                                   OOType elemType,
                                   boolean useAccessMethod)
   {
      this.iterName = iterName;
      this.objectName = objectName;
      this.elemType = elemType;
      this.useAccessMethod = useAccessMethod;
   }


   /**
    * UMLAttribute : 'elemType : OOType '
    */
   private OOType elemType;


   /**
    * Get the value of elemType.
    *
    * @return   Value of elemType.
    */
   public OOType getElemType()
   {
      return this.elemType;
   }


   /**
    * UMLAttribute : 'useAccessMethod : Boolean '
    */
   private boolean useAccessMethod;


   /**
    * Get the value of useAccessMethod.
    *
    * @return   Value of useAccessMethod.
    */
   public boolean isUseAccessMethod()
   {
      return this.useAccessMethod;
   }


   /**
    * UMLAttribute : 'objectName : OOVariable '
    */
   private OOVariable objectName;


   /**
    * Get the value of objectName.
    *
    * @return   Value of objectName.
    */
   public OOVariable getObjectName()
   {
      return this.objectName;
   }


   /**
    * UMLAttribute : 'iterName : OOVariable '
    */
   private OOVariable iterName;


   /**
    * Get the value of iterName.
    *
    * @return   Value of iterName.
    */
   public OOVariable getIterName()
   {
      return this.iterName;
   }


   /**
    * Get the sourceCode attribute of the OOFWIteratorHasNextExpr object
    *
    * @param visitor  No description provided
    * @return         The sourceCode value
    */
   public String getSourceCode (OOGenVisitor visitor)
   {
      return visitor.getSourceCode (this);
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOFWIteratorHasNextExpr[" + this.useAccessMethod + "," + this.elemType +
         "," + this.iterName + "," + this.objectName + "]";
   }
}

/*
 * $Log: OOFWIteratorHasNextExpr.java,v $
 * Revision 1.11  2004/10/20 17:49:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
