/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.uml.UMLAttrExprPair;


/**
 * Class OOInfixOp
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class OOInfixOp
{
   // unkown operation (operation,qualifier)
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp UNKNOWN_OP = new OOInfixOp (-1);

   // assignment op
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp ASSIGNMENT_OP = new OOInfixOp (UNKNOWN_OP);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp AND_OP = new OOInfixOp (ASSIGNMENT_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp OR_OP = new OOInfixOp (AND_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp EQUAL_OP = new OOInfixOp (OR_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp NOT_EQUAL_OP = new OOInfixOp (EQUAL_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp LESS_OP = new OOInfixOp (NOT_EQUAL_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp GREATER_OP = new OOInfixOp (LESS_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp LESS_EQUAL_OP = new OOInfixOp (GREATER_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp GREATER_EQUAL_OP = new OOInfixOp (LESS_EQUAL_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp ADD_OP = new OOInfixOp (GREATER_EQUAL_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp SUB_OP = new OOInfixOp (ADD_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp MUL_OP = new OOInfixOp (SUB_OP);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOInfixOp DIV_OP = new OOInfixOp (MUL_OP);

   // internal number
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int nr = 0;


   /**
    * Default Constructor
    */
   private OOInfixOp() { }


   /**
    * Constructor for class OOInfixOp
    *
    * @param nr  No description provided
    */
   private OOInfixOp (int nr)
   {
      this.nr = nr;
   }


   /**
    * Constructor for class OOInfixOp
    *
    * @param prev  No description provided
    */
   private OOInfixOp (OOInfixOp prev)
   {
      this.nr = prev.nr + 1;
   }


   /**
    * get OOInfixOp for given UMLAttrExprPair.operation and UMLAttrExprPair.qualifier
    *
    * @param operation  the UMLAttrExprPair.operation value
    * @param qualifier  the UMLAttrExprPair.qualifier value
    * @return           the corresponding <code>OOInfixOp</code> value
    */
   public static OOInfixOp get (int operation, int qualifier)
   {
      OOInfixOp result = null;

      switch (operation)
      {
         case UMLAttrExprPair.EQUAL:
            if (qualifier == UMLAttrExprPair.PRE)
            {
               result = EQUAL_OP;
            }
            else
            {
               result = ASSIGNMENT_OP;
            }
            break;
         case UMLAttrExprPair.NOTEQUAL:
            result = NOT_EQUAL_OP;
            break;
         case UMLAttrExprPair.LESS:
            result = LESS_OP;
            break;
         case UMLAttrExprPair.GREATER:
            result = GREATER_OP;
            break;
         case UMLAttrExprPair.LESSEQUAL:
            result = LESS_EQUAL_OP;
            break;
         case UMLAttrExprPair.GREATEREQUAL:
            result = GREATER_EQUAL_OP;
            break;
         default:
            result = UNKNOWN_OP;
      }

      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public boolean equals (Object other)
   {
      if (other == null || ! (other instanceof OOInfixOp))
      {
         return false;
      }

      return this.nr ==  ((OOInfixOp) other).nr;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOInfixOp[" + this.nr + "]";
   }
}

/*
 * $Log: OOInfixOp.java,v $
 * Revision 1.11  2004/10/20 17:49:34  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
