/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;



/**
 * Class OOMethod
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.16.2.1 $
 */
public final class OOMethod
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethod EQUALS_METHOD = new OOMethod ("equals", OOMethodType.EQUALS_METHOD);

   // container methods
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethod ADD_TO_SET_METHOD = new OOMethod ("add", OOMethodType.ADD_TO_SET_METHOD);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethod SET_CONTAINS_METHOD = new OOMethod ("contains", OOMethodType.SET_CONTAINS_METHOD);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethod CHECK_REG_EXPRESSION = new OOMethod ("Pattern.matches", OOMethodType.DEFAULT_METHOD);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethod TO_STRING_METHOD = new OOMethod ("toString", OOMethodType.DEFAULT_METHOD);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethod STRING_COMPARE_METHOD = new OOMethod ("JavaSDM.stringCompare", OOMethodType.DEFAULT_METHOD);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static OOMethod TO_ARRAY_METHOD = new OOMethod ("JavaSDM.toArray", OOMethodType.DEFAULT_METHOD);


   /**
    * Default Constructor
    *
    * @param name  No description provided
    * @param type  No description provided
    */
   public OOMethod (String name, OOMethodType type)
   {
      this.name = name;
      this.type = type;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name = null;


   /**
    * Get the name attribute of the OOMethod object
    *
    * @return   The name value
    */
   public String getName()
   {
      return this.name;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private OOMethodType type;


   /**
    * Get the type attribute of the OOMethod object
    *
    * @return   The type value
    */
   public OOMethodType getType()
   {
      return this.type;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public boolean equals (Object other)
   {
      if (other == null ||
         ! (other instanceof OOMethod))
      {
         return false;
      }

      OOMethod otherMethod = (OOMethod) other;

      return  (this.getName().equals (otherMethod.getName()) &&
         this.getType().equals (otherMethod.getType()));
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOMethod[" + this.name + "," + this.type + "]";
   }
}

/*
 * $Log: OOMethod.java,v $
 * Revision 1.16.2.1  2005/05/02 11:51:03  creckord
 * Fix for Multilinks
 * Small change in CoObRA change filtering
 *
 */
