/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FType;


/**
 * Class OOType
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.19.2.1 $
 */
public class OOType implements OOTypeInterface
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static FType EMPTY_TYPE = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String EMPTY_TYPENAME = "";


   /**
    * Default Constructor
    */
   protected OOType() { }


   /**
    * Constructor for class OOType
    *
    * @param umlType   No description provided
    * @param typeName  No description provided
    * @param pointer   No description provided
    */
   public OOType (FType umlType,
                  String typeName,
                  boolean pointer)
   {
      this.umlType = umlType;
      this.typeName = typeName;
      this.pointer = pointer;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FType umlType;


   /**
    * Get the value of umlType.
    *
    * @return   Value of umlType.
    */
   public FType getUmlType()
   {
      return this.umlType;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String typeName;


   /**
    * Get the typeName attribute of the OOType object
    *
    * @return   The typeName value
    */
   public String getTypeName()
   {
      return this.typeName;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean pointer;


   /**
    * Get the pointer attribute of the OOType object
    *
    * @return   The pointer value
    */
   public boolean isPointer()
   {
      return this.pointer;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public boolean equals (Object other)
   {
      return  (this.compareTo (other) == 0);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param other  No description provided
    * @return       No description provided
    */
   public int compareTo (Object other)
   {
      if (! (other instanceof OOType))
      {
         return -1;
      }

      OOType otherType = (OOType) other;

      String tmpName =  (getUmlType() == null ?
         getTypeName() : getNameForFType (getUmlType()));
      String otherName =  (otherType.getUmlType() == null ?
         otherType.getTypeName() : getNameForFType (otherType.getUmlType()));

      String tmpShortName = getShortName (tmpName);
      String otherShortName = getShortName (otherName);

      int result = tmpShortName.compareTo (otherShortName);

      if (result != 0 ||  (result == 0 &&  (tmpShortName.equals (tmpName) || otherShortName.equals (otherName))))
      {
         return result;
      }
      else
      {
         result = tmpName.compareTo (otherName);
         if (result != 0)
         {
            return result;
         }
      }

      if (isPointer() && !otherType.isPointer())
      {
         return -1;
      }
      if (!isPointer() && otherType.isPointer())
      {
         return 1;
      }

      return 0;
   }


   /**
    * Get the shortName attribute of the OOType object
    *
    * @param tmpName  No description provided
    * @return         The shortName value
    */
   private String getShortName (String tmpName)
   {
      int dot = tmpName.lastIndexOf ('.');
      if (dot > -1)
      {
         return tmpName.substring (dot + 1);
      }
      return tmpName;
   }


   /**
    * Get the nameForFType attribute of the OOType object
    *
    * @param umlType  No description provided
    * @return         The nameForFType value
    */
   private String getNameForFType (FType umlType)
   {
      if (umlType instanceof FClass)
      {
         return  ((FClass) umlType).getFullClassName();
      }
      return umlType.getName();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "OOType[" + this.umlType + "," + this.typeName + "," + this.pointer + "]";
   }
}

/*
 * $Log: OOType.java,v $
 * Revision 1.19.2.1  2005/07/13 11:24:49  creckord
 * Fixed problem with objects of classes with same name but different packages
 *
 */
