/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.*;

import de.uni_paderborn.fujaba.metamodel.*;


/**
 * @author    <a href="mailto:creckord@upb.de">Carsten Reckord</a>
 * @version   $Revision: 1.6 $
 */

public class UMLClassBodyRolesStrategy extends UMLClassBodyStrategy
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlClass  No description provided
    */
   public void createContents (FClass umlClass)
   {
      //FIXME: We need to implement roles of implemented interfaces, too
      SortedSet roles = getRoles (umlClass);
      Iterator rolesIter = roles.iterator();
      while (rolesIter.hasNext())
      {
         FRole currentRole = (FRole) rolesIter.next();
         generateFRole (currentRole);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param role  No description provided
    */
   protected void generateFRole (FRole role)
   {
      if (role != null)
      {
         FRole partnerRole = role.getFPartnerRole();
         getClassHandler().generateFRole (partnerRole);
      }
   }


   /**
    * Get the roles attribute of the UMLClassBodyRolesStrategy object
    *
    * @param umlClass  No description provided
    * @return          The roles value
    */
   protected SortedSet getRoles (FClass umlClass)
   {
      TreeSet roles = new TreeSet (new RoleComparator());
      Iterator rolesIter = umlClass.iteratorOfRoles();
      while (rolesIter.hasNext())
      {
         FRole currentRole = (FRole) rolesIter.next();

         //sanity check
         FAssoc assoc = currentRole.getFAssoc();
         if (assoc == null)
         {
            currentRole.removeYou();
            continue;
         }
         FRole partnerRole = currentRole.getFPartnerRole();
         if (partnerRole == null)
         {
            currentRole.removeYou();
            assoc.removeYou();
            continue;
         }

         roles.add (partnerRole);
      }
      return roles;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.6 $ $Date: 2004/10/20 17:49:37 $
    */
   public static class RoleComparator implements Comparator
   {
      /**
       * @param o1  No description provided
       * @param o2  No description provided
       * @return    No description provided
       * @see       java.util.Comparator#compare(java.lang.Object, java.lang.Object)
       */
      public int compare (Object o1, Object o2)
      {
         FRole umlRole1 = (FRole) o1;
         FRole umlRole2 = (FRole) o2;
         if ( (umlRole1 == null) ||  (umlRole1.getName() == null))
         {
            if ( (umlRole2 == null) ||  (umlRole2.getName() == null))
            {
               return 0;
            }
            return -1;
         }
         if ( (umlRole2 == null) ||  (umlRole2.getName() == null))
         {
            return 1;
         }

         return umlRole1.getName().compareTo (umlRole2.getName());
      }
   }
}

/*
 * $Log: UMLClassBodyRolesStrategy.java,v $
 * Revision 1.6  2004/10/20 17:49:37  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
