/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Class UMLMultiLinkOOHandler
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.20.2.6 $
 */
public class UMLMultiLinkOOHandler extends OOGenStrategyHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLMultiLinkOOHandler.class);


   /**
    * Default Constructor
    */
   public UMLMultiLinkOOHandler() { }


   /**
    * Get the responsible attribute of the UMLMultiLinkOOHandler object
    *
    * @param incr  No description provided
    * @return      The responsible value
    */
   public boolean isResponsible (FElement incr)
   {
      return  (incr instanceof UMLMultiLink);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public final boolean needToken()
   {
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr       No description provided
    * @param prevToken  No description provided
    * @param param      No description provided
    * @return           No description provided
    */
   public OOGenToken generateSourceCode (FElement incr,
                                         OOGenToken prevToken,
                                         Object param[])
   {
      UMLMultiLink theUMLMultiLink = (UMLMultiLink) incr;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(theUMLMultiLink=" +
            theUMLMultiLink + "param=" + Arrays.asList (param) + ")");
      }

      HashMap boundObjects;
      LinkedList availableLinks;
      HashMap fixedLinks;
      int mode;
      boolean isForEach;

      // parse param
      try
      {
         boundObjects = (HashMap) param[0];
         availableLinks = (LinkedList) param[1];
         fixedLinks = (HashMap) param[2];
         mode =  ((Integer) param[3]).intValue();
         isForEach =  ((Boolean) param[4]).booleanValue();
      }
      catch (Exception exception)
      {
         throw new IllegalArgumentException ("param=" +
            Arrays.asList (param));
      }

      // OOGenStrategyClient client = (OOGenStrategyClient) getClientOfChain();

      // MODE SEARCH
      if (mode == UMLMultiLink.MULTILINK_SEARCH)
      {

         //ksw err
         //log.error ("generate code for MultiLink: " + this.getName () + "\n   Priorit�t: " + getPriority (boundObjects));
         //log.error ("   paht: " + path + "   bind Optional and Set: " + bindOptionalAndSet);

         // check if MultiLink has been already generated
         if (fixedLinks.get (theUMLMultiLink.getID()) != null)
         {
            return prevToken;
         }

         UMLObject sourceObject = theUMLMultiLink.getSourceObject();
         UMLObject targetObject = theUMLMultiLink.getTargetObject();

         boolean sourceHasCreateModifier =  (sourceObject.getModifier() == UMLObject.CREATE) ||  (theUMLMultiLink.getSourceLink().getModifier() == UMLLink.CREATE);
         boolean targetHasCreateModifier =  (targetObject.getModifier() == UMLObject.CREATE) ||  (theUMLMultiLink.getTargetLink().getModifier() == UMLLink.CREATE);

         //sourceBound is true if source is bound or source has a create modifier
         boolean sourceBound =  (boundObjects.get (sourceObject.getID()) != null) || sourceHasCreateModifier;
         //targetBound is true if target is bound or target has a create modifier
         boolean targetBound =  (boundObjects.get (targetObject.getID()) != null) || targetHasCreateModifier;

         // *** CHECK LINKS ***
         if ( (theUMLMultiLink.getType() == UMLMultiLink.FIRST) && targetBound && !targetHasCreateModifier)
         {
            prevToken = prevToken.insertNewToken ("MultiLinkCheckFirst");
            prevToken.appendStatement (generateCode (theUMLMultiLink,
               MULTILINK_CHECK_FIRST,
               new Object[]{
               targetObject.getObjectName(),
               targetObject.getObjectType(),
               theUMLMultiLink.getContainerObject().getObjectName(),
               theUMLMultiLink.getContainerName()
               }
               ));

            fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
         }
         else if ( (theUMLMultiLink.getType() == UMLMultiLink.LAST) && sourceBound && !sourceHasCreateModifier)
         {
            prevToken = prevToken.insertNewToken ("MultiLinkCheckLast");
            prevToken.appendStatement (generateCode (theUMLMultiLink,
               MULTILINK_CHECK_LAST,
               new Object[]{
               sourceObject.getObjectName(),
               sourceObject.getObjectType(),
               theUMLMultiLink.getContainerObject().getObjectName(),
               theUMLMultiLink.getContainerName()
               }
               ));

            fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
         }
         else if (sourceBound && targetBound && !sourceHasCreateModifier && !targetHasCreateModifier)
         {
            prevToken = prevToken.insertNewToken ("MultiLinkCheck");
            prevToken.appendStatement (generateCode (theUMLMultiLink,
               MULTILINK_CHECK,
               new Object[]{
               sourceObject.getObjectName(),
               new Integer (sourceObject.getType()),
               targetObject.getObjectName(),
               new Integer (targetObject.getType()),
               targetObject.getObjectType(),
               theUMLMultiLink.getContainerObject().getObjectName(),
               theUMLMultiLink.getContainerName(),
               new Integer (theUMLMultiLink.getType()),
               new Integer (theUMLMultiLink.getIndex())
               }
               ));

            fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
         }
         // *** FIRST ***
         else if ( (theUMLMultiLink.getType() == UMLMultiLink.FIRST) && !targetHasCreateModifier)
         {
            prevToken = prevToken.insertNewToken ("MultiLinkSearchFirst");
            prevToken.appendStatement (generateCode (theUMLMultiLink,
               MULTILINK_SEARCH_FIRST,
               new Object[]{
               targetObject.getObjectName(),
               targetObject.getInstanceOf(),
               targetObject.getObjectType(),
               theUMLMultiLink.getContainerObject().getObjectName(),
               theUMLMultiLink.getContainerName(),
               theUMLMultiLink.getCorrespondingRole (targetObject).getTarget().getName(),
               generateCodeForAttrValuePairs (targetObject)
               }
               ));

            availableLinks.remove (theUMLMultiLink.getTargetLink());
            fixedLinks.put (theUMLMultiLink.getTargetLink().getID(), theUMLMultiLink.getTargetLink());
            fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
         }
         // *** LAST ***
         else if ( (theUMLMultiLink.getType() == UMLMultiLink.LAST) && !sourceHasCreateModifier)
         {
            prevToken = prevToken.insertNewToken ("MultiLinkSearchLast");
            prevToken.appendStatement (generateCode (theUMLMultiLink,
               MULTILINK_SEARCH_LAST,
               new Object[]{
               sourceObject.getObjectName(),
               sourceObject.getInstanceOf(),
               sourceObject.getObjectType(),
               theUMLMultiLink.getContainerObject().getObjectName(),
               theUMLMultiLink.getContainerName(),
               theUMLMultiLink.getCorrespondingRole (sourceObject).getTarget().getName(),
               generateCodeForAttrValuePairs (sourceObject)
               }
               ));

            availableLinks.remove (theUMLMultiLink.getSourceLink());
            fixedLinks.put (theUMLMultiLink.getSourceLink().getID(), theUMLMultiLink.getSourceLink());
            fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
         }
         // *** NORM -> NORM (ONE OBJECT BOUND) ***
         else if ( (theUMLMultiLink.getType() != UMLMultiLink.INDIRECT) && !sourceHasCreateModifier && !targetHasCreateModifier &&
             (sourceBound || targetBound) &&  (sourceObject.getType() == UMLMultiLink.NORMAL) &&  (targetObject.getType() == UMLMultiLink.NORMAL))
         {
            if (sourceBound)
            {
               prevToken = prevToken.insertNewToken ("MultiLinkSearchBoundToUnBound");
               prevToken.appendStatement (generateCode (theUMLMultiLink,
                  MULTILINK_SEARCH_BOUND_TO_UNBOUND,
                  new Object[]{
                  sourceObject.getObjectName(),
                  new Integer (sourceObject.getType()),
                  targetObject.getObjectName(),
                  new Integer (targetObject.getType()),
                  targetObject.getObjectType(),
                  theUMLMultiLink.getContainerObject().getObjectName(),
                  theUMLMultiLink.getContainerName(),
                  new Integer (theUMLMultiLink.getType()),
                  new Integer (theUMLMultiLink.getIndex()),
                  theUMLMultiLink.getCorrespondingRole (targetObject).getTarget().getName(),
                  generateCodeForAttrValuePairs (targetObject)
                  }
                  ));

               fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
               fixedLinks.put (theUMLMultiLink.getTargetLink().getID(), theUMLMultiLink.getTargetLink());
               availableLinks.remove (theUMLMultiLink.getTargetLink());
            }
            else if (targetBound)
            {
               prevToken = prevToken.insertNewToken ("MultiLinkSearchUnBoundToBound");
               prevToken.appendStatement (generateCode (theUMLMultiLink,
                  MULTILINK_SEARCH_UNBOUND_TO_BOUND,
                  new Object[]{
                  sourceObject.getObjectName(),
                  new Integer (sourceObject.getType()),
                  targetObject.getObjectName(),
                  new Integer (targetObject.getType()),
                  sourceObject.getInstanceOf(),
                  sourceObject.getObjectType(),
                  theUMLMultiLink.getContainerObject().getObjectName(),
                  theUMLMultiLink.getContainerName(),
                  new Integer (theUMLMultiLink.getType()),
                  new Integer (theUMLMultiLink.getIndex()),
                  theUMLMultiLink.getCorrespondingRole (sourceObject).getTarget().getName(),
                  generateCodeForAttrValuePairs (sourceObject)
                  }
                  ));

               fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
               fixedLinks.put (theUMLMultiLink.getSourceLink().getID(), theUMLMultiLink.getSourceLink());
               availableLinks.remove (theUMLMultiLink.getSourceLink());
            }
         }
         // *** BOUND ONLY NORM OBJECT ***
         else if ( (theUMLMultiLink.getBindOptionalAndSet() == false) &&  ( (sourceObject.getType() == UMLMultiLink.NORMAL) ||  (targetObject.getType() == UMLMultiLink.NORMAL)))
         {
            // bind source
            boolean generateLowerBoundName;
            if (!sourceBound && !sourceHasCreateModifier &&  (sourceObject.getType() == UMLMultiLink.NORMAL))
            {
               generateLowerBoundName = false;
               String lowerBoundName = theUMLMultiLink.findLowerBound (sourceObject);
               String upperBoundName = theUMLMultiLink.findUpperBoundForNormal (sourceObject, boundObjects);

               String section = prevToken.insertTopAndBottomToken ("iMultiLinkSearchNorm");
               prevToken = prevToken.getTopToken (section);
               OOGenToken bottomToken = prevToken.getBottomToken (section);

               prevToken.appendStatement (generateCode (theUMLMultiLink,
                  I_MULTILINK_SEARCH_NORM_TOP,
                  new Object[]{
                  sourceObject.getObjectName(),
                  sourceObject.getInstanceOf(),
                  sourceObject.getObjectType(),
                  lowerBoundName,
                  upperBoundName,
                  theUMLMultiLink.getContainerObject().getObjectName(),
                  theUMLMultiLink.getContainerName(),
                  Boolean.valueOf (generateLowerBoundName),
                  theUMLMultiLink.getCorrespondingRole (sourceObject).getTarget().getName(),
                  generateCodeForAttrValuePairs (sourceObject),
                  Boolean.valueOf (isForEach)
                  }
                  ));

               bottomToken.appendStatement (generateCode (theUMLMultiLink,
                  I_MULTILINK_SEARCH_NORM_BOTTOM,
                  new Object[]{
                  sourceObject.getObjectName()
                  }
                  ));

               fixedLinks.put (theUMLMultiLink.getSourceLink().getID(), theUMLMultiLink.getSourceLink());
               availableLinks.remove (theUMLMultiLink.getSourceLink());
            }
            // bind target
            else if (!targetBound && !targetHasCreateModifier &&  (targetObject.getType() == UMLMultiLink.NORMAL))
            {
               generateLowerBoundName = false;
               String lowerBoundName = theUMLMultiLink.findLowerBound (targetObject);
               String upperBoundName = theUMLMultiLink.findUpperBoundForNormal (targetObject, boundObjects);

               String section = prevToken.insertTopAndBottomToken ("iMultiLinkSearchNorm");
               prevToken = prevToken.getTopToken (section);
               OOGenToken bottomToken = prevToken.getBottomToken (section);

               prevToken.appendStatement (generateCode (theUMLMultiLink,
                  I_MULTILINK_SEARCH_NORM_TOP,
                  new Object[]{
                  targetObject.getObjectName(),
                  targetObject.getInstanceOf(),
                  targetObject.getObjectType(),
                  lowerBoundName,
                  upperBoundName,
                  theUMLMultiLink.getContainerObject().getObjectName(),
                  theUMLMultiLink.getContainerName(),
                  Boolean.valueOf (generateLowerBoundName),
                  theUMLMultiLink.getCorrespondingRole (targetObject).getTarget().getName(),
                  generateCodeForAttrValuePairs (targetObject),
                  Boolean.valueOf (isForEach)
                  }
                  ));

               bottomToken.appendStatement (generateCode (theUMLMultiLink,
                  I_MULTILINK_SEARCH_NORM_BOTTOM,
                  new Object[]{
                  targetObject.getObjectName()
                  }
                  ));

               fixedLinks.put (theUMLMultiLink.getTargetLink().getID(), theUMLMultiLink.getTargetLink());
               availableLinks.remove (theUMLMultiLink.getTargetLink());

               if (sourceBound)
               {
                  fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
               }
            }
         }
         // *** BINDOPTIONALANDSET ***
         else if (theUMLMultiLink.getBindOptionalAndSet() == true)
         {
            // all direct multilinks
            if ( (theUMLMultiLink.getType() == UMLMultiLink.DIRECT) && !sourceHasCreateModifier && !targetHasCreateModifier &&  (sourceBound || targetBound))
            {
               if (sourceBound)
               {
                  prevToken = prevToken.insertNewToken ("MultiLinkSearchBoundToUnBound");
                  prevToken.appendStatement (generateCode (theUMLMultiLink,
                     MULTILINK_SEARCH_BOUND_TO_UNBOUND,
                     new Object[]{
                     sourceObject.getObjectName(),
                     new Integer (sourceObject.getType()),
                     targetObject.getObjectName(),
                     new Integer (targetObject.getType()),
                     targetObject.getObjectType(),
                     theUMLMultiLink.getContainerObject().getObjectName(),
                     theUMLMultiLink.getContainerName(),
                     new Integer (theUMLMultiLink.getType()),
                     new Integer (theUMLMultiLink.getIndex()),
                     theUMLMultiLink.getCorrespondingRole (targetObject).getTarget().getName(),
                     generateCodeForAttrValuePairs (targetObject)
                     }
                     ));

                  fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
                  fixedLinks.put (theUMLMultiLink.getTargetLink().getID(), theUMLMultiLink.getTargetLink());
                  availableLinks.remove (theUMLMultiLink.getTargetLink());
               }
               else if (targetBound)
               {
                  prevToken = prevToken.insertNewToken ("MultiLinkSearchUnBoundToBound");

                  prevToken.appendStatement (generateCode (theUMLMultiLink,
                     MULTILINK_SEARCH_UNBOUND_TO_BOUND,
                     new Object[]{
                     sourceObject.getObjectName(),
                     new Integer (sourceObject.getType()),
                     targetObject.getObjectName(),
                     new Integer (targetObject.getType()),
                     targetObject.getObjectType(),
                     theUMLMultiLink.getContainerObject().getObjectName(),
                     theUMLMultiLink.getContainerName(),
                     new Integer (theUMLMultiLink.getType()),
                     new Integer (theUMLMultiLink.getIndex()),
                     theUMLMultiLink.getCorrespondingRole (sourceObject).getTarget().getName(),
                     generateCodeForAttrValuePairs (sourceObject)
                     }
                     ));

                  fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
                  fixedLinks.put (theUMLMultiLink.getSourceLink().getID(), theUMLMultiLink.getSourceLink());
                  availableLinks.remove (theUMLMultiLink.getSourceLink());
               }
            }
            // all the other mutilinks
            else
            {
               // SOURCE_BOUND
               if (sourceBound)
               {
                  // Bound_Object ... Unbound_Optional_Object
                  if ( (targetObject.getType() == UMLMultiLink.OPTIONAL) && !targetHasCreateModifier)
                  {
                     String lowerBoundName;
                     boolean generateLowerBoundName;
                     boolean
                        isEntry;

                     if (theUMLMultiLink.isEntry() && !theUMLMultiLink.hasAnyLowerBound (targetObject))
                     {
                        lowerBoundName = null;
                        generateLowerBoundName = false;
                        isEntry = true;
                     }
                     else if (theUMLMultiLink.findNextNormalLowerBound (targetObject) != null)
                     {
                        lowerBoundName = theUMLMultiLink.findNextNormalLowerBound (targetObject);
                        generateLowerBoundName = false;
                        isEntry = false;
                     }
                     else
                     {
                        lowerBoundName = "lowerBound";
                        generateLowerBoundName = true;
                        isEntry = false;
                        prevToken = generateCodeForLowerBound (theUMLMultiLink, prevToken, targetObject, lowerBoundName);
                     }

                     String upperBoundName = theUMLMultiLink.findUpperBoundForOptional (targetObject, boundObjects);

                     String section = prevToken.insertTopAndBottomToken ("iMultiLinkSearchOptional");
                     prevToken = prevToken.getTopToken (section);
                     OOGenToken bottomToken = prevToken.getBottomToken (section);

                     prevToken.appendStatement (generateCode (theUMLMultiLink,
                        I_MULTILINK_SEARCH_OPTIONAL_TOP,
                        new Object[]{
                        targetObject.getObjectName(),
                        targetObject.getObjectType(),
                        targetObject.getInstanceOf(),
                        lowerBoundName,
                        upperBoundName,
                        theUMLMultiLink.getContainerObject().getObjectName(),
                        theUMLMultiLink.getContainerName(),
                        Boolean.valueOf (generateLowerBoundName),
                        Boolean.valueOf (isEntry),
                        theUMLMultiLink.getCorrespondingRole (targetObject).getTarget().getName(),
                        generateCodeForAttrValuePairs (targetObject)
                        }
                        ));

                     bottomToken.appendStatement (generateCode (theUMLMultiLink,
                        I_MULTILINK_SEARCH_OPTIONAL_BOTTOM,
                        new Object[]{
                        targetObject.getObjectName(),
                        upperBoundName,
                        Boolean.valueOf (isForEach)
                        }
                        ));

                     fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
                     fixedLinks.put (theUMLMultiLink.getTargetLink().getID(), theUMLMultiLink.getTargetLink());
                     availableLinks.remove (theUMLMultiLink.getTargetLink());
                  }
                  // Bound_Object ... Unbound_Set_Object
                  else if ( (targetObject.getType() == UMLMultiLink.SET) && !targetHasCreateModifier)
                  {
                     String lowerBoundName;
                     boolean generateLowerBoundName;
                     boolean
                        isEntry;

                     if (theUMLMultiLink.isEntry() && !theUMLMultiLink.hasAnyLowerBound (targetObject))
                     {
                        lowerBoundName = null;
                        generateLowerBoundName = false;
                        isEntry = true;
                     }
                     else if (theUMLMultiLink.findNextNormalLowerBound (targetObject) != null)
                     {
                        lowerBoundName = theUMLMultiLink.findNextNormalLowerBound (targetObject);
                        generateLowerBoundName = false;
                        isEntry = false;
                     }
                     else
                     {
                        lowerBoundName = "lowerBound";
                        generateLowerBoundName = true;
                        isEntry = false;
                        prevToken = generateCodeForLowerBound (theUMLMultiLink, prevToken, targetObject, lowerBoundName);
                     }

                     String upperBoundName = theUMLMultiLink.findUpperBoundForOptional (targetObject, boundObjects);

                     prevToken = prevToken.insertNewToken (I_MULTILINK_SEARCH_SET);
                     prevToken.appendStatement (generateCode (theUMLMultiLink,
                        I_MULTILINK_SEARCH_SET,
                        new Object[]{
                        targetObject.getObjectName(),
                        targetObject.getObjectType(),
                        lowerBoundName,
                        upperBoundName,
                        theUMLMultiLink.getContainerObject().getObjectName(),
                        theUMLMultiLink.getContainerName(),
                        Boolean.valueOf (generateLowerBoundName),
                        Boolean.valueOf (isEntry),
                        theUMLMultiLink.getCorrespondingRole (targetObject).getTarget(),
                        theUMLMultiLink.getCorrespondingRole (targetObject).getTarget().getName(),
                        generateCodeForAttrValuePairs (targetObject)
                        }
                        ));

                     fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
                     fixedLinks.put (theUMLMultiLink.getTargetLink().getID(), theUMLMultiLink.getTargetLink());
                     availableLinks.remove (theUMLMultiLink.getTargetLink());
                  }
               }
               // SOURCE NOT BOUND
               else if (!sourceBound)
               {
                  // Unbound_Optional_Object ... Bound_Object (Entry Point)
                  if ( (sourceObject.getType() == UMLMultiLink.OPTIONAL) && !sourceHasCreateModifier)
                  {
                     boolean generateLowerBoundName;
                     boolean
                        isEntry;
                     String lowerBoundName;

                     if (theUMLMultiLink.isEntry())
                     {
                        lowerBoundName = null;
                        generateLowerBoundName = false;
                        isEntry = true;
                     }
                     else
                     {
                        lowerBoundName = null;
                        generateLowerBoundName = false;
                        isEntry = true;
                     }

                     String upperBoundName = theUMLMultiLink.findUpperBoundForOptional (sourceObject, boundObjects);

                     String section = prevToken.insertTopAndBottomToken ("iMultiLinkSearchOptional");
                     prevToken = prevToken.getTopToken (section);
                     OOGenToken bottomToken = prevToken.getBottomToken (section);

                     prevToken.appendStatement (generateCode (theUMLMultiLink,
                        I_MULTILINK_SEARCH_OPTIONAL_TOP,
                        new Object[]{
                        sourceObject.getObjectName(),
                        targetObject.getInstanceOf(),
                        sourceObject.getObjectType(),
                        lowerBoundName,
                        upperBoundName,
                        theUMLMultiLink.getContainerObject().getObjectName(),
                        theUMLMultiLink.getContainerName(),
                        Boolean.valueOf (generateLowerBoundName),
                        Boolean.valueOf (isEntry),
                        theUMLMultiLink.getCorrespondingRole (sourceObject).getTarget().getName(),
                        generateCodeForAttrValuePairs (sourceObject)
                        }
                        ));

                     bottomToken.appendStatement (generateCode (theUMLMultiLink,
                        I_MULTILINK_SEARCH_OPTIONAL_BOTTOM,
                        new Object[]{
                        sourceObject.getObjectName(),
                        upperBoundName,
                        Boolean.valueOf (isForEach)
                        }
                        ));

                     if (targetBound)
                     {
                        fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
                     }
                     fixedLinks.put (theUMLMultiLink.getSourceLink().getID(), theUMLMultiLink.getSourceLink());
                     availableLinks.remove (theUMLMultiLink.getSourceLink());
                  }
                  // Unbound_Set_Object ... Bound_Object (Entry Point)
                  else if ( (sourceObject.getType() == UMLMultiLink.SET) && !sourceHasCreateModifier)
                  {
                     boolean generateLowerBoundName;
                     String lowerBoundName;

                     if (theUMLMultiLink.isEntry())
                     {
                        lowerBoundName = null;
                        generateLowerBoundName = false;
                     }
                     else
                     {
                        lowerBoundName = null;
                        generateLowerBoundName = false;
                     }

                     String upperBoundName = theUMLMultiLink.findUpperBoundForOptional (sourceObject, boundObjects);

                     prevToken = prevToken.insertNewToken (I_MULTILINK_SEARCH_SET);
                     prevToken.appendStatement (generateCode (theUMLMultiLink,
                        I_MULTILINK_SEARCH_SET,
                        new Object[]{
                        sourceObject.getObjectName(),
                        sourceObject.getObjectType(),
                        lowerBoundName,
                        upperBoundName,
                        theUMLMultiLink.getContainerObject().getObjectName(),
                        theUMLMultiLink.getContainerName(),
                        Boolean.valueOf (generateLowerBoundName),
                        Boolean.valueOf (theUMLMultiLink.isEntry()),
                        theUMLMultiLink.getCorrespondingRole (sourceObject).getTarget().getName(),
                        generateCodeForAttrValuePairs (sourceObject)
                        }
                        ));

                     if (targetBound)
                     {
                        fixedLinks.put (theUMLMultiLink.getID(), theUMLMultiLink);
                     }
                     fixedLinks.put (theUMLMultiLink.getSourceLink().getID(), theUMLMultiLink.getSourceLink());
                     availableLinks.remove (theUMLMultiLink.getSourceLink());
                  }
               }
            }
         }
         else
         {
            //ksw err
            //log.error("   " + theUMLMultiLink.getName() + " DO NOTHING");
         }
      }
      // *** MODE CREATE *** MODE CREATE *** MODE CREATE *** MODE CREATE ***
      else if (mode == UMLMultiLink.MULTILINK_CREATE)
      {
         UMLObject sourceObject = theUMLMultiLink.getSourceObject();
         UMLObject targetObject = theUMLMultiLink.getTargetObject();

         UMLObject leftObject;
         UMLObject rightObject;
         UMLLink leftLink;
         UMLLink rightLink;

         int context;

         boolean sourceHasCreateModifier = sourceObject.getModifier() == UMLObject.CREATE;
         boolean targetHasCreateModifier = targetObject.getModifier() == UMLObject.CREATE;

         boolean sourceLinkHasCreateModifier = theUMLMultiLink.getSourceLink().getModifier() == UMLLink.CREATE;
         boolean targetLinkHasCreateModifier = theUMLMultiLink.getTargetLink().getModifier() == UMLLink.CREATE;

         if ( (theUMLMultiLink.getPreviousMultiLink() == null) ||  (theUMLMultiLink.getPreviousMultiLink().getType() == UMLMultiLink.FIRST))
         {
            if (sourceHasCreateModifier || sourceLinkHasCreateModifier)
            {
               rightObject = targetObject;
               rightLink = theUMLMultiLink.getTargetLink();

               context = theUMLMultiLink.getContext (null, rightObject, null, rightLink);

               prevToken = prevToken.insertNewToken ("MultiLinkInsertObject");
               prevToken.appendStatement (generateCode (theUMLMultiLink,
                  MULTILINK_INSERT_OBJECT,
                  new Object[]{
                  sourceObject.getObjectName(),
                  sourceObject.getObjectType(),
                  null,
                  rightObject != null ? rightObject.getObjectName() : null,
                  Boolean.valueOf (sourceHasCreateModifier),
                  new Integer (context),
                  theUMLMultiLink.getContainerObject().getObjectName(),
                  theUMLMultiLink.getContainerName()
                  }
                  ));
            }
            else if (targetHasCreateModifier || targetLinkHasCreateModifier)
            {
               rightObject = sourceObject;
               rightLink = theUMLMultiLink.getSourceLink();

               context = theUMLMultiLink.getContext (rightObject, null, rightLink, null);

               prevToken = prevToken.insertNewToken ("MultiLinkInsertObject");
               prevToken.appendStatement (generateCode (theUMLMultiLink,
                  MULTILINK_INSERT_OBJECT,
                  new Object[]{
                  targetObject.getObjectName(),
                  targetObject.getObjectType(),
                  rightObject != null ? rightObject.getObjectName() : null,
                  null,
                  Boolean.valueOf (targetHasCreateModifier),
                  new Integer (context),
                  theUMLMultiLink.getContainerObject().getObjectName(),
                  theUMLMultiLink.getContainerName()
                  }
                  ));
            }
         }

         if ( (targetHasCreateModifier || targetLinkHasCreateModifier) &&  (theUMLMultiLink.getPreviousMultiLink() != null))
         {
            leftObject = sourceObject;
            leftLink = theUMLMultiLink.getSourceLink();

            rightObject =  (theUMLMultiLink.getNextMultiLink() != null) ? theUMLMultiLink.getNextMultiLink().getTargetObject() : null;
            rightLink =  (theUMLMultiLink.getNextMultiLink() != null) ? theUMLMultiLink.getNextMultiLink().getTargetLink() : null;

            context = theUMLMultiLink.getContext (leftObject, rightObject, leftLink, rightLink);

            prevToken = prevToken.insertNewToken ("MultiLinkInsertObject");
            prevToken.appendStatement (generateCode (theUMLMultiLink,
               MULTILINK_INSERT_OBJECT,
               new Object[]{
               targetObject.getObjectName(),
               targetObject.getObjectType(),
               leftObject != null ? leftObject.getObjectName() : null,
               rightObject != null ? rightObject.getObjectName() : null,
               Boolean.valueOf (targetHasCreateModifier),
               new Integer (context),
               theUMLMultiLink.getContainerObject().getObjectName(),
               theUMLMultiLink.getContainerName()
               }
               ));
         }
      }

      return prevToken;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param object  No description provided
    * @return        No description provided
    * @deprecated    not used any more
    */
   private OOExpression[] generateCodeForAttrValuePairs (UMLObject object)
   {
      Vector aep = new Vector();

      /*
       *  Iterator attrExprIter = object.iteratorOfAttrs();
       *  while (attrExprIter.hasNext())
       *  {
       *  UMLAttrExprPair umlAttrExprPair = (UMLAttrExprPair) attrExprIter.next();
       *  if (umlAttrExprPair.getQualifier() != UMLAttrExprPair.POST)
       *  {
       *  OOExpression expression = (OOExpression) generateCode (umlAttrExprPair, UML_ATTR_EXPR_PAIR,
       *  new Object[]{Boolean.valueOf (umlAttrExprPair.getRevAttrs().isSet())});
       *  /aep.add (expression);
       *  }
       *  }
       */
      return OOExpression.toArray (aep);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param theMultiLink    No description provided
    * @param prevToken       No description provided
    * @param object          No description provided
    * @param lowerBoundName  No description provided
    * @return                No description provided
    */
   private OOGenToken generateCodeForLowerBound (UMLMultiLink theMultiLink,
                                                 OOGenToken prevToken,
                                                 UMLObject object, String lowerBoundName)
   {
      UMLObject toCheckObject;
      UMLMultiLink tmpMultiLink;

      boolean found = false;
      boolean hasCreateModifier = false;
      boolean ifClauseGenerated = false;
      int type = -1;

      if (object == theMultiLink.getSourceObject())
      {
         tmpMultiLink = theMultiLink.getPreviousMultiLink();
         toCheckObject =  (tmpMultiLink != null) ? tmpMultiLink.getSourceObject() : null;
      }
      else
      {
         tmpMultiLink = theMultiLink;
         toCheckObject = tmpMultiLink.getSourceObject();
      }

      if (toCheckObject != null)
      {
         type = toCheckObject.getType();
         hasCreateModifier =  (toCheckObject.getModifier() == UMLObject.CREATE) ||  (tmpMultiLink.getSourceLink().getModifier() == UMLLink.CREATE);
      }

      while (!found &&  (tmpMultiLink != null) &&  (tmpMultiLink.getType() != UMLMultiLink.FIRST))
      {
         // if-clause
         if (!ifClauseGenerated && !hasCreateModifier &&  (type != UMLObject.NORM))
         {
            ifClauseGenerated = true;

            prevToken = prevToken.insertNewToken ("FindLowerBoundIfClause");
            prevToken.appendStatement (generateCode (theMultiLink,
               FIND_LOWER_BOUND_IF_CLAUSE,
               new Object[]{
               object.getObjectName(),
               object.getInstanceOf(),
               object.getObjectType(),
               toCheckObject.getObjectName(),
               new Integer (toCheckObject.getType()),
               lowerBoundName
               }
               )
               );
            if (tmpMultiLink.getPreviousMultiLink() == null)
            {
               prevToken = prevToken.insertNewToken ("empty row");
               //               prevToken.setText ("\n");
            }
         }
         else if (ifClauseGenerated && !hasCreateModifier &&  (type != UMLObject.NORM))
         {
            // else-if-clause
            prevToken = prevToken.insertNewToken ("FindLowerBoundElseIfClause");
            prevToken.appendStatement (generateCode (theMultiLink,
               FIND_LOWER_BOUND_ELSE_IF_CLAUSE,
               new Object[]{
               object.getObjectName(),
               object.getObjectType(),
               toCheckObject.getObjectName(),
               new Integer (toCheckObject.getType()),
               lowerBoundName
               }
               )
               );
         }
         else if (ifClauseGenerated && !hasCreateModifier &&  (type == UMLObject.NORM))
         {
            // else-clause
            prevToken = prevToken.insertNewToken ("FindLowerBoundElseClause");
            prevToken.appendStatement (generateCode (theMultiLink,
               FIND_LOWER_BOUND_ELSE_CLAUSE,
               new Object[]{
               object.getObjectName(),
               object.getObjectType(),
               toCheckObject.getObjectName(),
               new Integer (toCheckObject.getType()),
               lowerBoundName
               }
               )
               );
            found = true;
         }

         tmpMultiLink = tmpMultiLink.getPreviousMultiLink();
         if (tmpMultiLink != null)
         {
            toCheckObject = tmpMultiLink.getSourceObject();
            type = toCheckObject.getType();
            hasCreateModifier =  (toCheckObject.getModifier() == UMLObject.CREATE) ||  (tmpMultiLink.getSourceLink().getModifier() == UMLLink.CREATE);
         }
      }

      return prevToken;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLMultiLinkOOHandler[]";
   }
}

/*
 * $Log: UMLMultiLinkOOHandler.java,v $
 * Revision 1.20.2.6  2005/11/18 10:57:49  l3_g5
 * attribute assertions for multilinks work
 *
 */
