/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.uml.UMLPath;



/**
 * Class UMLPathOOHandler
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.2 $
 */
public class UMLPathOOHandler extends OOGenStrategyHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLPathOOHandler.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PATH_SEARCH_TOP = "pathSearchTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PATH_SEARCH_TO_SET_TOP = "pathSearchToSetTop";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PATH_SEARCH_BOTTOM = "pathSearchBottom";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PATH_SEARCH_TO_SET_BOTTOM = "pathSearchToSetBottom";


   /**
    * Default Constructor
    */
   public UMLPathOOHandler() { }


   /**
    * Get the responsible attribute of the UMLPathOOHandler object
    *
    * @param incr  No description provided
    * @return      The responsible value
    */
   public boolean isResponsible (FElement incr)
   {
      return  (incr.getClass().equals (UMLPath.class));
   }


   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    *
    * @return   No description provided
    */
   public final boolean needToken()
   {
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to ensure improve documentation.
    *
    * @param prevToken   No description provided
    * @param param       No description provided
    * @param asgElement  No description provided
    * @return            No description provided
    */
   public OOGenToken generateSourceCode (FElement asgElement, OOGenToken prevToken, Object param[])
   {
      UMLPath umlPath = (UMLPath) asgElement;

      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode (umlPath=" + umlPath + ")");
      }

      // create code for the path
      String section = prevToken.insertTopAndBottomToken ("PathSearchToMany");

      prevToken = prevToken.getTopToken (section);

      if (umlPath.getTarget().isSet())
      {
         prevToken.appendStatement (generateCode (umlPath, PATH_SEARCH_TO_SET_TOP, new Object[]{}));
      }
      else
      {
         prevToken.appendStatement (generateCode (umlPath, PATH_SEARCH_TOP, new Object[]{}));
      }

      OOGenToken bottomToken = prevToken.getBottomToken (section);

      if (umlPath.getTarget().isSet())
      {
         bottomToken.appendStatement (generateCode (umlPath, PATH_SEARCH_TO_SET_BOTTOM, new Object[]{}));
      }
      else
      {
         bottomToken.appendStatement (generateCode (umlPath, PATH_SEARCH_BOTTOM, new Object[]{}));
      }

      return prevToken;
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLPathOOHandler[]";
   }
}

/*
 * $Log: UMLPathOOHandler.java,v $
 * Revision 1.2  2004/10/20 17:49:36  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
