/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Set;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler.MethodDescription;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FHashMap;


/**
 * @author    Carsten Reckord
 * @version   $Revision: 1.4 $
 */
public class UMLRoleOOHandlerInternalQualifiedToOneStrategy extends UMLRoleOOHandlerQualifiedToOneStrategy
{

   /**
    * Get the responsible attribute of the UMLRoleOOHandlerInternalQualifiedToOneStrategy object
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The responsible value
    */
   public boolean isResponsible (FRole umlRole, FRole partnerRole)
   {
      return  (umlRole != null && partnerRole != null &&
         getCardinality (partnerRole) == 1 &&
         umlRole.getFQualifier() != null && !umlRole.getFQualifier().isExternalQualifier());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                             FHashMap templateParameters, Set accessMethods)
   {
      super.generateReadAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);

      MethodDescription accessMethod;

      accessMethod = createGetKeyForMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateWriteAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                              FHashMap templateParameters, Set accessMethods)
   {
      super.generateWriteAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);

      MethodDescription accessMethod;

      accessMethod = createInternalQualifiedAddToMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createKeyChangedInMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createInternalQualifiedAddToMethod (FRole umlRole, FRole partnerRole,
                                                                   FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.ADD_METHOD;
      String blockName = "assoc-addTo-v2";

      return createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType, false);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createAddToMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                  FHashMap templateParameters)
   {
      return reduceVisibility (super.createAddToMethod (umlRole, partnerRole, attr,
         templateParameters));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createAddToMapEntryMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return reduceVisibility (super.createAddToMapEntryMethod (umlRole, partnerRole, attr,
         templateParameters));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createHasKeyValueInMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                          FHashMap templateParameters)
   {
      return reduceVisibility (super.createHasKeyValueInMethod (umlRole, partnerRole, attr,
         templateParameters));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createHasValueInMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters)
   {
      return createHasInMethod (umlRole, partnerRole, attr, templateParameters, "assoc-hasIn-v2");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createRemoveKeyValueFromMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                               FHashMap templateParameters)
   {
      return reduceVisibility (super.createRemoveKeyValueFromMethod (umlRole, partnerRole, attr,
         templateParameters));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createRemoveValueFromMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                            FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_METHOD;
      String blockName = "assoc-removeFrom-v2";

      return createRemoveMethod (umlRole, partnerRole, attr, templateParameters, blockName, methodType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createGetKeyForMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                      FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.GET_KEY_FOR_METHOD;
      String blockName = "assoc-getKeyFor";

      FType returnType = umlRole.getFQualifier().getFType();
      FParam valueParam = createParam ("value", partnerRole.getFTarget().getFRealType());

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{valueParam});
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createKeyChangedInMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                         FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.KEY_CHANGED_IN_METHOD;
      String blockName = "assoc-keyChangedIn-one";

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.VOID);

      FParam keyParam = createParam ("oldKey", umlRole.getFQualifier().getFType());
      FParam valueParam = createParam ("value", partnerRole.getFTarget().getFRealType());

      String remove = getPartnerAccessMethod (umlRole, partnerRole, SourceCodeFactory.REMOVE_METHOD);
      templateParameters.put ("$REMOVE$", remove);

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{keyParam, valueParam});
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param description  No description provided
    * @return             No description provided
    */
   protected MethodDescription reduceVisibility (MethodDescription description)
   {
      FMethod method = description.getMethodSignature();
      if (method.getVisibility() == FDeclaration.PUBLIC)
      {
         method.setVisibility (FDeclaration.PROTECTED);
      }
      return description;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected FHashMap setupTemplateParameters (FRole umlRole, FRole partnerRole)
   {
      FHashMap templateParameters = super.setupTemplateParameters (umlRole, partnerRole);

      SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
      String qualifierName = umlRole.getFQualifier().getName();
      templateParameters.put ("$GETKEY$",
         factory.getAccessMethodName (qualifierName, SourceCodeFactory.GET_METHOD));

      return templateParameters;
   }
}

/*
 * $Log: UMLRoleOOHandlerInternalQualifiedToOneStrategy.java,v $
 * Revision 1.4  2004/10/20 17:49:37  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
