/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Set;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler.MethodDescription;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FHashMap;


/**
 * @author    Carsten Reckord
 * @version   $Revision: 1.8.2.1 $
 */
public class UMLRoleOOHandlerOrderedToManyStrategy extends UMLRoleOOHandlerToManyStrategy
{
   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The responsible value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#isResponsible(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   public boolean isResponsible (FRole umlRole, FRole partnerRole)
   {
      return  (umlRole != null && partnerRole != null &&
         getCardinality (partnerRole) > 1 && !isSorted (partnerRole) && isOrdered (partnerRole) &&
         umlRole.getFQualifier() == null);
   }


   /**
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                             FHashMap templateParameters, Set accessMethods)
   {
      super.generateReadAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);
      generateFirstLastReadAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);
      generateOrderedReadAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateWriteAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                              FHashMap templateParameters, Set accessMethods)
   {
      super.generateWriteAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);
      generateOrderedWriteAccessMethods (umlRole, partnerRole, attr, templateParameters, accessMethods);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateOrderedReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                                    FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createLastIndexOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      //accessMethod = createIndexedLastIndexOfMethod (umlRole, partnerRole, attr,
      //   (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIndexOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      //accessMethod = createIndexedIndexOfMethod (umlRole, partnerRole, attr,
      //   (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);

      accessMethod = createMLIteratorOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIndexedIteratorOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);

      accessMethod = createIsBeforeOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIsAfterOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);

      accessMethod = createGetFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createGetNextOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIndexedGetNextOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createGetPreviousOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIndexedGetPreviousOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateOrderedWriteAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                                     FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createSetInMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIndexedAddToMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);

      accessMethod = createAddBeforeOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createAddAfterOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);

      accessMethod = createRemoveIndexFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIndexedRemoveFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createAddBeforeOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                        FHashMap templateParameters)
   {
      return insertRefObject (createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-addBeforeOf", SourceCodeFactory.ADD_BEFORE_OF_METHOD), partnerRole);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createSetInMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                  FHashMap templateParameters)
   {
      return insertIndex (createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-setIn", SourceCodeFactory.SET_IN_METHOD), partnerRole);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexedAddToMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                         FHashMap templateParameters)
   {
      return insertIndex (createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-addTo-Index", SourceCodeFactory.ADD_METHOD), partnerRole);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                    FHashMap templateParameters)
   {
      return insertRefObject (createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-addBeforeOf", SourceCodeFactory.ADD_BEFORE_OF_METHOD), partnerRole);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createAddAfterOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters)
   {
      return insertRefObject (createInsertMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-addAfterOf", SourceCodeFactory.ADD_AFTER_OF_METHOD), partnerRole);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createLastIndexOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                        FHashMap templateParameters)
   {
      return createIndexOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-lastIndexOf", SourceCodeFactory.LAST_INDEX_OF_METHOD);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexedIndexOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                           FHashMap templateParameters)
   {
      return createIndexedIndexOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-indexOf-Index", SourceCodeFactory.INDEX_OF_METHOD);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexedLastIndexOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                               FHashMap templateParameters)
   {
      return createIndexedIndexOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-lastIndexOf-Index", SourceCodeFactory.LAST_INDEX_OF_METHOD);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                    FHashMap templateParameters, String blockName, int methodType)
   {
      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.INTEGER);

      // Generate the method parameter.
      FParam newParam = createParam ("value", partnerRole.getFTarget().getFRealType());

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{newParam});
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexedIndexOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                           FHashMap templateParameters, String blockName, int methodType)
   {
      return appendIndex (createIndexOfMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIteratorOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                       FHashMap templateParameters, String blockName)
   {
      return super.createIteratorOfMethod (umlRole, partnerRole, attr, templateParameters, blockName + "-List");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createMLIteratorOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                         FHashMap templateParameters)
   {
      MethodDescription description = createIteratorOfMethod (umlRole, partnerRole, attr,
         templateParameters, "assoc-iteratorOf-Ml");

      FMethod method = description.getMethodSignature();
      FParam boundParam = createParam ("lowerBound",
         partnerRole.getFTarget().getFRealType());
      method.addToParam (boundParam);

      return description;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexedIteratorOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                              FHashMap templateParameters)
   {
      return appendIndex (createIteratorOfMethod (umlRole, partnerRole, attr,
         templateParameters, "assoc-iteratorOf-Index"));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIsBeforeOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.IS_BEFORE_OF_METHOD;
      String blockName = "assoc-isBeforeOf";

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN);

      // Generate the method parameter.
      FParam param1 = createParam ("leftObject", partnerRole.getFTarget().getFRealType());
      FParam param2 = createParam ("rightObject", partnerRole.getFTarget().getFRealType());

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{param1, param2});
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createIsAfterOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.IS_AFTER_OF_METHOD;
      String blockName = "assoc-isAfterOf";

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.BOOLEAN);

      // Generate the method parameter.
      FParam param1 = createParam ("leftObject", partnerRole.getFTarget().getFRealType());
      FParam param2 = createParam ("rightObject", partnerRole.getFTarget().getFRealType());

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{param1, param2});
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createGetFromMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.GET_AT_METHOD;
      String blockName = "assoc-getAt";

      FType returnType = partnerRole.getFTarget().getFRealType();

      // Generate the method parameter.
      FParam newParam = createParam ("index", UMLProject.get().getFromBaseTypes (FBaseTypes.INTEGER));

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{newParam});
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createGetNextOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                      FHashMap templateParameters)
   {
      return createPreviousOrNextOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-getNextOf", SourceCodeFactory.GET_NEXT_OF_METHOD);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createIndexedGetNextOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return createIndexedPreviousOrNextOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-getNextOf-Index", SourceCodeFactory.GET_NEXT_INDEX_OF_METHOD);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createGetPreviousOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return createPreviousOrNextOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-getPreviousOf", SourceCodeFactory.GET_PREVIOUS_OF_METHOD);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createIndexedGetPreviousOfMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return createIndexedPreviousOrNextOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-getPreviousOf-Index", SourceCodeFactory.GET_PREVIOUS_INDEX_OF_METHOD);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @return                    No description provided
    */
   protected MethodDescription createPreviousOrNextOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                             FHashMap templateParameters, String blockName,
                                                             int methodType)
   {
      FType returnType = partnerRole.getFTarget().getFRealType();

      // Generate the method parameter.
      FParam newParam = createParam ("object", partnerRole.getFTarget().getFRealType());

      return createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, new FParam[]{newParam});
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param blockName           No description provided
    * @param methodType          No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexedPreviousOrNextOfMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                                    FHashMap templateParameters, String blockName,
                                                                    int methodType)
   {
      return appendIndex (createPreviousOrNextOfMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected FHashMap setupTemplateParameters (FRole umlRole, FRole partnerRole)
   {
      FHashMap templateParameters = super.setupTemplateParameters (umlRole, partnerRole);

      SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
      String linkedListCode = " && !" + factory.getFullAccessMethodName (
         partnerRole.getAttrName(), "value", SourceCodeFactory.HAS_IN_METHOD);
      templateParameters.put ("$LINKLISTCODE$", linkedListCode);

      return templateParameters;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIndexedRemoveFromMethod (FRole umlRole, FRole partnerRole,
                                                              FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_METHOD;
      String blockName = "assoc-removeFrom-List-v2";

      return insertIndex (createRemoveMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType), partnerRole);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createRemoveIndexFromMethod (FRole umlRole, FRole partnerRole,
                                                            FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_METHOD;
      String blockName = "assoc-removeFrom-List-v1";

      return createRemoveMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType, "index",
         UMLProject.get().getFromBaseTypes (FBaseTypes.INTEGER));
   }


   /**
    * Get the containerType attribute of the UMLRoleOOHandlerOrderedToManyStrategy object
    *
    * @return   The containerType value
    */
   protected OOCollectionEnum getContainerType()
   {
      return OOCollectionEnum.LIST;
   }


   /**
    * Get the iteratorType attribute of the UMLRoleOOHandlerOrderedToManyStrategy object
    *
    * @param valueType  No description provided
    * @return           The iteratorType value
    */
   protected String getIteratorType (FType valueType)
   {
      return getListIteratorType (valueType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param description  No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected MethodDescription insertIndex (MethodDescription description, FRole partnerRole)
   {
      FMethod method = description.getMethodSignature();
      FParam indexParam = createParam ("index",
         UMLProject.get().getFromBaseTypes (FBaseTypes.INTEGER));
      int insertPos = 0;
      if (getExternalQualifierType (partnerRole) != null)
      {
         insertPos++;
      }
      method.addToParam (insertPos, indexParam);

      return description;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param description  No description provided
    * @param partnerRole  No description provided
    * @return             No description provided
    */
   protected MethodDescription insertRefObject (MethodDescription description, FRole partnerRole)
   {
      FMethod method = description.getMethodSignature();
      FParam indexParam = createParam ("refObject", partnerRole.getFTarget());
      int insertPos = 0;
      if (getExternalQualifierType (partnerRole) != null)
      {
         insertPos++;
      }
      method.addToParam (insertPos, indexParam);

      return description;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param description  No description provided
    * @return             No description provided
    */
   protected MethodDescription appendIndex (MethodDescription description)
   {
      FMethod method = description.getMethodSignature();
      FParam indexParam = createParam ("index",
         UMLProject.get().getFromBaseTypes (FBaseTypes.INTEGER));
      method.addToParam (indexParam);

      return description;
   }


   /**
    * Get the listIteratorType attribute of the UMLRoleOOHandlerOrderedToManyStrategy class
    *
    * @param valueType  No description provided
    * @return           The listIteratorType value
    */
   protected final static String getListIteratorType (FType valueType)
   {
      OOGenVisitor visitor = CodeGenFactory.get().getCurrentOOVisitor();
      return visitor.getOOTypeAsString (
         OO.containerType (OOCollectionEnum.LIST_ITERATOR, OO.type (valueType,  (valueType instanceof FBaseTypes)))
         , false);
   }
}

/*
 * $Log: UMLRoleOOHandlerOrderedToManyStrategy.java,v $
 * Revision 1.8.2.1  2005/11/18 10:57:48  l3_g5
 * attribute assertions for multilinks work
 *
 */
