/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.Set;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler.MethodDescription;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FHashMap;


/**
 * @author    Carsten Reckord
 * @version   $Revision: 1.5 $
 */
public class UMLRoleOOHandlerQualifiedToManyStrategy extends UMLRoleOOHandlerQualifiedStrategy
{

   /**
    * @param umlRole      No description provided
    * @param partnerRole  No description provided
    * @return             The responsible value
    * @see                de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy#isResponsible(de.uni_paderborn.fujaba.metamodel.FRole,
    *      de.uni_paderborn.fujaba.metamodel.FRole)
    */
   public boolean isResponsible (FRole umlRole, FRole partnerRole)
   {
      return  (umlRole != null && partnerRole != null &&
         getCardinality (partnerRole) > 1 &&
         umlRole.getFQualifier() != null && umlRole.getFQualifier().isExternalQualifier());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateReadAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                             FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createHasValueInMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createHasKeyValueInMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createHasKeyInMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIteratorOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createIteratorOfKeyMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createKeysOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createEntriesOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createSizeOfMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createSizeOfKeyMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @param accessMethods       No description provided
    */
   protected void generateWriteAccessMethods (FRole umlRole, FRole partnerRole, FAttr attr,
                                              FHashMap templateParameters, Set accessMethods)
   {
      MethodDescription accessMethod;

      accessMethod = createAddToMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createAddToMapEntryMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createRemoveValueFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createRemoveKeyValueFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createRemoveKeyFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
      accessMethod = createRemoveAllFromMethod (umlRole, partnerRole, attr,
         (FHashMap) templateParameters.clone());
      accessMethods.add (accessMethod);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createHasKeyValueInMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      MethodDescription description = createHasInMethod (umlRole, partnerRole, attr,
         templateParameters, "assoc-hasIn-v5");

      FMethod method = description.getMethodSignature();
      FParam keyParam = createParam ("key", umlRole.getFQualifier().getFType());
      method.addToParam (0, keyParam);

      return description;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createIteratorOfKeyMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      return addQualifier (umlRole, partnerRole, createIteratorOfMethod (umlRole, partnerRole, attr, templateParameters,
         "assoc-iteratorOf-v3"));
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createRemoveKeyValueFromMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_METHOD;
      String blockName = "assoc-removeFrom-v6";

      return addQualifier (createRemoveMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType), umlRole.getFQualifier().getFType(),
         false);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlRole             No description provided
    * @param partnerRole         No description provided
    * @param attr                No description provided
    * @param templateParameters  No description provided
    * @return                    No description provided
    */
   protected MethodDescription createSizeOfKeyMethod (FRole umlRole, FRole partnerRole, FAttr attr,
                                                      FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.SIZE_OF_METHOD;
      String blockName = "assoc-sizeOf-v2";

      FType returnType = UMLProject.get().getFromBaseTypes (FBaseTypes.INTEGER);

      return addQualifier (createAccessMethod (umlRole, partnerRole, attr, methodType, blockName,
         templateParameters, returnType, null), umlRole.getFQualifier().getFType(),
         false);
   }


   /**
    * @param umlRole
    * @param partnerRole
    * @param attr
    * @param templateParameters
    * @return                    No description provided
    */
   protected MethodDescription createRemoveKeyFromMethod (FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters)
   {
      int methodType = SourceCodeFactory.REMOVE_KEY_FROM_METHOD;
      String blockName = "assoc-removeKeyFrom-v2";

      return createRemoveMethod (umlRole, partnerRole, attr, templateParameters,
         blockName, methodType, "key", umlRole.getFQualifier().getFType());
   }


   /**
    * Get the containerType attribute of the UMLRoleOOHandlerQualifiedToManyStrategy object
    *
    * @return   The containerType value
    */
   protected OOCollectionEnum getContainerType()
   {
      return OOCollectionEnum.MULTI_MAP;
   }
}

/*
 * $Log: UMLRoleOOHandlerQualifiedToManyStrategy.java,v $
 * Revision 1.5  2004/11/22 19:04:49  lowende
 * Some javadoc corrections.
 *
 */
