/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.event.ActionEvent;

import javax.swing.*;

import de.tu_bs.coobra.errors.RemoteException;
import de.tu_bs.coobra.remote.errors.GeneralException;
import de.tu_bs.coobra.remote.errors.RuntimeGeneralException;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Commit changes in the local repository
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14 $
 */
public class CheckinAction extends AbstractAction
{
   /**
    * Called when Action should be performed
    *
    * @param e  event
    */
   public void actionPerformed (ActionEvent e)
   {
      try
      {
         if (FujabaChangeManager.getVMRepository() != null && FujabaChangeManager.getVMRepository().isConnected())
         {
            try
            {
               if (FujabaChangeManager.getVMRepository().isContainingFilteredServerChanges())
               {
                  int result = JOptionPane.showConfirmDialog (FrameMain.get(),
                     "This will roll back the server and discard all changes newer than the project version you have checked out!\n" +
                     "Do you want to contiue?", "Checkin", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
                  if (result == JOptionPane.YES_OPTION)
                  {
                     FujabaChangeManager.getVMRepository().rollBackServer();
                  }
                  else
                  {
                     return;
                  }
               }
               FujabaChangeManager.getVMRepository().compact();
               FujabaChangeManager.getVMRepository().checkin();
            }
            catch (RemoteException ex)
            {
               Throwable cause = ex.getCause();
               if (cause instanceof GeneralException)
               {
                  GeneralException ge = (GeneralException) cause;
                  String message = ge.getMessage();
                  if (message != null)
                  {
                     if (message.indexOf (RuntimeGeneralException.MSG_CHECKIN_NOTUPDATED) >= 0)
                     {
                        message = "There are already new changes on the server - run update first.";
                     }
                     else
                     {
                        message = "The server did not accept the changes! Error message: " + message;
                     }
                  }
                  else
                  {
                     message = "The server did not accept the changes for an unknown reason!";
                     ge.printStackTrace();
                  }
                  ex.printStackTrace();
                  JOptionPane.showMessageDialog (FrameMain.get(), message, "Checkin", JOptionPane.ERROR_MESSAGE);
                  FrameMain.get().setStatusLabel ("checkin failed: " + ge.getMessage());
                  return;
               }
               throw ex;
            }
            FrameMain.get().setStatusLabel ("checkin succeeded");
            UMLProject.get().setSaved (true);
         }
         else
         {

            JOptionPane.showMessageDialog (FrameMain.get(), "Not connected to a server!", "Checkin", JOptionPane.ERROR_MESSAGE);
         }
      }
      catch (RuntimeException ex)
      {
         String message = "An error occurred while checkin in - checkin failed! Error message: " + ex.getMessage();
         JOptionPane.showMessageDialog (FrameMain.get(), message, "Checkin", JOptionPane.ERROR_MESSAGE);
         FrameMain.get().setStatusLabel ("checkin failed: " + ex.getMessage());
         throw ex;
      }
   }
}

/*
 * $Log: CheckinAction.java,v $
 * Revision 1.14  2004/10/29 13:46:53  lowende
 * Some improvements for parsed code
 *
 */
