/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.event.ActionEvent;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.swing.JOptionPane;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ServerObjectChange;
import de.uni_paderborn.fujaba.app.action.NewProjectAction;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;


/**
 * Displays a dialog to let the user select a project version to be checked out
 *
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.6.2.4 $
 */
public class CheckoutVersionAction extends CheckoutAction
{
   /**
    * Perform the action
    *
    * @param event  the ActionEvent for performing the action
    */
   public void actionPerformed (ActionEvent event)
   {
      if (new NewProjectAction().confirmDialog() == JOptionPane.OK_OPTION)
      {
         // FujabaChangeManager.setVMRepository (null);
         // UMLProject.createPlainProject();
         try
         {
            super.actionPerformed (event);
         }
         finally
         {
            if (FujabaChangeManager.getVMRepository() != null)
            {
               FujabaChangeManager.getVMRepository().setUpdateFilter (null);
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean patch = false;

   /**
    * dialog for choosing the project version
    */
   CheckoutVersionChooser versionChooser;

   /**
    * version filter
    */
   LocalRepository.UpdateFilter filter =
      new LocalRepository.UpdateFilter()
      {
         private BigInteger filterLargestSN;

         private BigInteger filterSmallestSN;


         public boolean receivedChanges (Iterator serverChangesIterator)
         {
            Map versions = new HashMap();
            List sortedVersions = new LinkedList();
            while (serverChangesIterator.hasNext())
            {
               ServerObjectChange change = (ServerObjectChange) serverChangesIterator.next();
               Object value = versions.get (change.getCause());
               if (value == null || change.getSequenceNumber().compareTo ((BigInteger) value) > 0)
               {
                  versions.put (change.getCause(), change.getServerSequenceNumber());
                  if (value != null && sortedVersions.get (sortedVersions.size() - 1) != change.getCause())
                  {
                     sortedVersions.remove (change.getCause());
                     sortedVersions.add (change.getCause());
                  }
                  else if (value == null)
                  {
                     sortedVersions.add (change.getCause());
                  }
               }
            }
            if (versionChooser == null)
            {
               versionChooser = createVersionChooser();
            }
            versionChooser.chooseFromVersions (sortedVersions);
            Object versionCause = versionChooser.getLargestChosenVersion();
            BigInteger sequenceNumber = (BigInteger) versions.get (versionCause);
            if (sequenceNumber == null)
            {
               sequenceNumber = new BigInteger ("-1");
            }
            filterLargestSN = sequenceNumber;

            versionCause = versionChooser.getSmallestChosenVersion();
            sequenceNumber = (BigInteger) versions.get (versionCause);
            if (sequenceNumber == null)
            {
               sequenceNumber = new BigInteger ("-1");
            }
            filterSmallestSN = sequenceNumber;

            return true;
         }


         public boolean accept (ServerObjectChange change)
         {
            BigInteger sn = change.getServerSequenceNumber();
            return  (sn.compareTo (filterLargestSN) <= 0) &&
                (sn.compareTo (filterSmallestSN) > 0);
         }


         public boolean isPatch()
         {
            return patch;
         }
      };


   /**
    * @return   new LocalRepository()
    */
   protected LocalRepository createRepository()
   {
      LocalRepository repository = super.createRepository();
      repository.setUpdateFilter (filter);
      return repository;
   }


   /**
    * @return
    */
   protected CheckoutVersionChooser createVersionChooser()
   {
      return new CheckoutVersionChooser();
   }


   /**
    * Get the filter attribute of the CheckoutVersionAction object
    *
    * @return   The filter value
    */
   protected LocalRepository.UpdateFilter getFilter()
   {
      return filter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected boolean shouldConnectOnly()
   {
      return false;
   }


   /**
    * Get the patch attribute of the CheckoutVersionAction object
    *
    * @return   The patch value
    */
   public boolean isPatch()
   {
      return patch;
   }


   /**
    * Sets the patch attribute of the CheckoutVersionAction object
    *
    * @param patch  The new patch value
    */
   public void setPatch (boolean patch)
   {
      this.patch = patch;
   }
}

/*
 * $Log: CheckoutVersionAction.java,v $
 * Revision 1.6.2.4  2006/03/13 13:12:04  lowende
 * Compile warnings removed.
 *
 */
