/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.zip.GZIPInputStream;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ObjectChange;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.util.ExtensionFileFilter;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Restore all changes from file
 *
 * @author    $Author: zuendorf $
 * @version   $Revision: 1.22.2.1 $
 */
public class RestoreAction extends AbstractAction implements LocalRepository.ProgressCallback
{
   /**
    * dialog for displaying progress
    */
   ProgressDialog progress = new ProgressDialog (FrameMain.get());


   /**
    * called when update/restore/store progress
    *
    * @param percent  progress percentage
    */
   public void progress (final int percent)
   {
      if (progress != null)
      {
         //progress.setVisible( percent > 0 && percent < 100 );
         progress.setPercentage (percent);
      }
   }


   /**
    * For choosing the filename to restore to
    */
   JFileChooser chooser;


   /**
    * Perform the action
    *
    * @param event  the ActionEvent for performing the action
    */
   public void actionPerformed (ActionEvent event)
   {
      //ask where to load from
      if (chooser == null)
      {
         chooser = new JFileChooser (".");
         ExtensionFileFilter filter = new ExtensionFileFilter();
         filter.addExtension ("cxr");
         filter.addExtension ("cxr.gz");
         filter.setDescription ("CoObRA XML Repository");
         chooser.setFileFilter (filter);
      }
      int result = chooser.showOpenDialog (FrameMain.get());

      if (result == JFileChooser.APPROVE_OPTION)
      {
         restoreWithProgressDialog (chooser.getSelectedFile().getPath());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: zuendorf $
    * @version   $Revision: 1.22.2.1 $ $Date: 2005/03/24 16:15:32 $
    */
   private class WorkThread extends Thread
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      String filename;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      RuntimeException exception;


      /**
       * Constructor for class WorkThread
       *
       * @param filename  No description provided
       */
      public WorkThread (String filename)
      {
         this.filename = filename;
      }


      /**
       * @see   Runnable#run()
       */
      public void run()
      {
         while (!progress.isVisible())
         {
            try
            {
               Thread.sleep (10);
            }
            catch (InterruptedException e)
            {
            }
         }
         try
         {
            try
            {
               restore (filename);
            }
            catch (RuntimeException e)
            {
               e.printStackTrace();
               exception = e;
            }
         }
         finally
         {
            progress.hide();
         }
      }
   }


   /**
    * restore CoObRA repository while diaplying a progress dialog
    *
    * @param filename  where to load from
    */
   public void restoreWithProgressDialog (final String filename)
   {
      progress.setTitle ("Load Project");
      WorkThread thread = new WorkThread (filename);
      thread.start();
      progress.setVisible (true);

      if (thread.exception == null)
      {
         UMLProject newProject = FujabaChangeManager.getUMLProject();
         UMLProject.setNewProject (newProject);
         if (newProject != null)
         {
            //newProject.getStereotypeManager().initDefaultStereotypes();
         }

         ObjectChange.pushCause (LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
         try
         {
            FrameMain.get().setUMLProject (newProject);
            if (newProject != null)
            {
               newProject.refreshDisplay();
            }
         }
         finally
         {
            ObjectChange.popCause (LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
         }

         if (newProject == null)
         {
            throw new RuntimeException ("No UMLProject found in restored objects!");
         }
      }
      else
      {
         throw thread.exception;
      }
   }


   /**
    * restore a repository from file
    * for internal use only
    *
    * @param filename  where to load from
    */
   public void restore (String filename)
   {
      LocalRepository oldRepo = FujabaChangeManager.getVMRepository();
      if (filename != null &&  (filename.length() > 0))
      {
         try
         {
            ObjectChange.pushCause (LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
            try
            {
               UMLProject.setNewProject (null);
               if (oldRepo != null)
               {
                  oldRepo.removeYou();
               }
               FujabaChangeManager.setVMRepository (new LocalRepository());
               BufferedInputStream fio;
               try
               {
                  fio = new BufferedInputStream (new GZIPInputStream (new FileInputStream (filename)));
               }
               catch (Exception e)
               {
                  fio = new BufferedInputStream (new FileInputStream (filename));
               }
               FujabaChangeManager.getVMRepository().restore (fio, filename.indexOf (".cxri") >= 0, this);

               //test (FujabaChangeManager.getVMRepository());
            }
            finally
            {
               ObjectChange.popCause (LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
            }
         }
         catch (Exception e)
         {
            throw new RuntimeException (e);
         }
      }
   }
}

/*
 * $Log: RestoreAction.java,v $
 * Revision 1.22.2.1  2005/03/24 16:15:32  zuendorf
 * Some bug fixes for ordered assocs and multilinks
 *
 */
