/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.coobra.actions;

import java.awt.event.ActionEvent;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;


/**
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.4 $
 */
public class ShowPropertyEditorAction extends AbstractAction
{
   /**
    * Invoked when an action occurs.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      PreferencesProperties props = PreferencesProperties.get ("PropertyEditor");

      boolean activated = isPropertyEditorActivated();
      activated = !activated;
      props.putSetting ("activated", "" + activated);
      props.save();
      FrameMain.get().showPropertyEditor (activated);
   }


   /**
    * @return   true when the property editor is currently activated
    */
   public static boolean isPropertyEditorActivated()
   {
      PreferencesProperties props = PreferencesProperties.get ("PropertyEditor");

      boolean activated = false;
      try
      {
         String value = props.getSetting ("activated");
         activated = Boolean.valueOf (value).booleanValue();
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }
      return activated;
   }
}

/*
 * $Log: ShowPropertyEditorAction.java,v $
 * Revision 1.4  2004/10/20 17:49:39  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
