/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import java.awt.Point;
import java.util.Iterator;

import javax.swing.JComponent;

import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * fsa object for JBend
 *
 *
 * @author    $Author: joerg $
 * @version   $Revision: 1.18 $
 */
public class FSABend extends FSAContainer
{
   /**
    * Constructor for class FSABend
    *
    *
    * @param incr                 No description provided
    * @param propName             No description provided
    */
   public FSABend (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * Constructor for class FSABend
    *
    *
    * @param incr                 No description provided
    * @param propName             No description provided
    * @param parent               No description provided
    */
   public FSABend (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Constructor for class FSABend
    *
    *
    * @param incr                     No description provided
    * @param propName                 No description provided
    * @param parent                   No description provided
    * @param myJComponent             No description provided
    */
   public FSABend (LogicUnparseInterface incr, String propName, JComponent parent,
                   JComponent myJComponent)
   {
      super (incr, propName, parent, myJComponent);
   }


   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JBend bend = new JBend();
      bend.setUI ((BendUI) DefaultBendUI.createUI (bend));
      //bend.setVisible (false);

      return  (bend);
   }


   /**
    * Sets the uI attribute of the FSABend object
    *
    *
    * @param ui             The new uI value
    */
   public void setUI (BendUI ui)
   {
      JBend bend = (JBend) getJComponent();

      bend.setUI (ui);
   }


   /**
    * Get the uI attribute of the FSABend object
    *
    *
    * @return   The uI value
    */
   public BendUI getUI()
   {
      JBend bend = (JBend) getJComponent();

      return  (bend == null ? null : (BendUI) bend.getUI());
   }


   /**
    * Get the point attribute of the FSABend object
    *
    *
    * @return   The point value
    */
   public Point getPoint()
   {
      return  ((JBend) getJComponent()).getPoint();
   }


   /**
    * Sets the point attribute of the FSABend object
    *
    *
    * @param point             The new point value
    */
   public void setPoint (Point point)
   {
       ((JBend) getJComponent()).setPoint (point);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      JBend bend = (JBend) this.getJComponent();
      // FIX ME: PolyLine: removing bends only works through BendLine methods,
      // not Bend methods
      Iterator iter = bend.iteratorOfIncomingLines();
      while (iter.hasNext())
      {
         JBendLine line = (JBendLine) iter.next();
         if (line instanceof JPolyLine.LineSegment)
         {
            JPolyLine.LineSegment segment = (JPolyLine.LineSegment) line;
            JPolyLine polyLine = segment.getPolyLine();

            if (polyLine != null)
            {
               polyLine.removeFromBends (bend);
            }
            else
            {
               segment.setStartBend (null);
            }
         }
         else
         {
            line.setEndBend (null);
         }
      }
      iter = bend.iteratorOfOutgoingLines();
      while (iter.hasNext())
      {
         JBendLine line = (JBendLine) iter.next();
         if (line instanceof JPolyLine.LineSegment)
         {
            JPolyLine.LineSegment segment = (JPolyLine.LineSegment) line;
            JPolyLine polyLine = segment.getPolyLine();
            if (polyLine != null)
            {
               polyLine.removeFromBends (bend);
            }
            else
            {
               segment.setStartBend (null);
            }
         }
         else
         {
            line.setStartBend (null);
         }
      }
      super.removeYou();
   }
}

/*
 * $Log: FSABend.java,v $
 * Revision 1.18  2005/01/24 12:30:50  joerg
 * started new layout algoritm for class diagrams
 *
 */
