/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.AbstractJComboBoxLabel;
import de.uni_paderborn.fujaba.fsa.swing.DefaultJComboBoxLabel;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * FSAComboBoxLabel.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.17.2.1 $
 */
public class FSAComboBoxLabel extends FSAObject
{
   /**
    * inherited constructor from FSAObject.
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSAComboBoxLabel (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
   }


   /**
    * inherited constructor from FSAObject.
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAComboBoxLabel (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * inherited constructor from FSAObject.
    *
    * @param incr          No description provided
    * @param propName      No description provided
    * @param parent        No description provided
    * @param myJComponent  No description provided
    */
   public FSAComboBoxLabel (LogicUnparseInterface incr, String propName,
                            JComponent parent, JComponent myJComponent)
   {
      super (incr, propName, parent, myJComponent);
   }


   /**
    * returns "value" as default.
    *
    * @return   The defaultAttrName value
    */
   public String getDefaultAttrName()
   {
      return "value";
   }


   /**
    * Creates a DefaultJComboBoxLabel as inner component.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      AbstractJComboBoxLabel txt = new DefaultJComboBoxLabel();

      txt.setBackground (COLOR_BACKGROUND);
      txt.setForeground (COLOR_FOREGROUND);
      txt.setBorder (null);
      //      txt.setAutoCloaking (true);

      return  (txt);
   }


   /**
    * Delegates the method call to its inner component.
    *
    * @param model  The new model value
    */
   public void setModel (ComboBoxModel model)
   {
       ((AbstractJComboBoxLabel) getJComponent()).setModel (model);
   }


   /**
    * Delegates the method call to its inner component.
    *
    * @param renderer  The new renderer value
    */
   public void setRenderer (ListCellRenderer renderer)
   {
       ((AbstractJComboBoxLabel) getJComponent()).setRenderer (renderer);
   }


   /**
    * Delegates the method call to its inner component.
    *
    * @return   The renderer value
    */
   public ListCellRenderer getRenderer()
   {
      return  ((AbstractJComboBoxLabel) getJComponent()).getRenderer();
   }
}

/*
 * $Log: FSAComboBoxLabel.java,v $
 * Revision 1.17.2.1  2005/06/02 13:53:43  cschneid
 * assoc qualifier selection fixed, new lib
 *
 */
