/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JDirectionIndicator;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * UMLClass: 'FSADirectionIndicator'
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.3 $
 */
public class FSADirectionIndicator extends FSAObject
{
   /**
    * Constructor for class FSADirectionIndicator
    *
    * @param incr  No description provided
    */
   public FSADirectionIndicator (LogicUnparseInterface incr)
   {
      super (incr, null, null);
   }


   /**
    * Constructor for class FSADirectionIndicator
    *
    * @param incr          No description provided
    * @param parent        No description provided
    * @param propertyName  No description provided
    */
   public FSADirectionIndicator (LogicUnparseInterface incr, String propertyName, JComponent parent)
   {
      super (incr, propertyName, parent);
   }


   /**
    * creates a standard JPanel with frame for this FSAFrame UMLMethod: '+ createJComponent
    * () : Void'
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JDirectionIndicator arrow = new JDirectionIndicator();
      arrow.setBackground (FSAObject.COLOR_BACKGROUND);
      arrow.setForeground (FSAObject.COLOR_FOREGROUND);
      return  (arrow);
   }


   /**
    * update the jComponent to reflect this value UMLMethod: '+ setJComponentValue (value :
    * Object) : Void'
    *
    * @param value  The new jComponentValue value
    */
   public void setJComponentValue (Object value) { }


   /**
    * get the value that is currently visualised by the jComponent UMLMethod: '+ getJComponentValue
    * () : Object'
    *
    * @return   The jComponentValue value
    */
   public Object getJComponentValue()
   { // FSAObject

      return null;
   }


   /**
    * Sets the target attribute of the FSADirectionIndicator object
    *
    * @param target  The new target value
    */
   public void setTarget (FSAObject target)
   {
      JDirectionIndicator arrow = (JDirectionIndicator) getJComponent();
      if (arrow != null)
      {
         if (target != null)
         {
            arrow.setTarget (target.getJComponent());
         }
         else
         {
            arrow.setTarget (null);
         }
      }
   }


   /**
    * Get the target attribute of the FSADirectionIndicator object
    *
    * @return   The target value
    */
   public FSAObject getTarget()
   {
      return FSAObject.getFSAObjectFromJComponent ( ((JDirectionIndicator) getJComponent()).getTarget());
   }


   /**
    * Sets the source attribute of the FSADirectionIndicator object
    *
    * @param source  The new source value
    */
   public void setSource (FSAObject source)
   {
      JDirectionIndicator arrow = (JDirectionIndicator) getJComponent();
      if (arrow != null)
      {
         if (source != null)
         {
            arrow.setSource (source.getJComponent());
         }
         else
         {
            arrow.setSource (null);
         }
      }
   }


   /**
    * Get the source attribute of the FSADirectionIndicator object
    *
    * @return   The source value
    */
   public FSAObject getSource()
   {
      return FSAObject.getFSAObjectFromJComponent ( ((JDirectionIndicator) getJComponent()).getSource());
   }

}

/*
 * $Log: FSADirectionIndicator.java,v $
 * Revision 1.3  2004/11/22 20:46:22  lowende
 * Javadoc corrected.
 *
 */
