/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.swing.JCircle;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.uml.UMLStopActivity;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.7 $
 */
public class FSAEntryGrab extends FSAGrab
{
   /**
    * Constructor for class FSAEntryGrab
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSAEntryGrab (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
   }


   /**
    * Sets the target attribute of the FSAEntryGrab object
    *
    * @param obj  The new target value
    * @return     No description provided
    */
   public boolean setTarget (FSAObject obj)
   {
      JGrab grab = (JGrab) getJComponent();

      if (grab == null)
      {
         return false;
      }

      if (obj == null && grab.getTarget() != null)
      {
         grab.setTarget (null);
         return true;
      }
      else if (obj != null && grab.getTarget() != obj.getJComponent())
      {
         LogicUnparseInterface entry = obj.getLogic();
         JComponent comp = obj.getJComponent();
         if (entry instanceof UMLStartActivity)
         {
            comp = (JCircle)  ((JPanel) comp.getComponent (1)).getComponent (0);
         }
         else if (entry instanceof UMLStopActivity)
         {
            comp = (JCircle)  ((JPanel) comp.getComponent (0)).getComponent (0);
         }
         setParentOfJComponent (comp.getParent());
         grab.setTarget (comp);
         return true;
      }
      return false;
   }
}

/*
 * $Log: FSAEntryGrab.java,v $
 * Revision 1.7  2004/11/03 10:17:52  lowende
 * Javadoc warnings removed.
 *
 */
