/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.LogicToFsaUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.21 $
 */
public class FSALabel extends FSAObject
{
   /**
    * Constructor for class FSALabel
    */
   public FSALabel() { }


   /**
    * Constructor for class FSALabel
    *
    * @param incr      No description provided
    * @param propName  No description provided
    */
   public FSALabel (LogicUnparseInterface incr, String propName)
   {
      super (incr, propName);
      setBold (false);
   }


   /**
    * Constructor for class FSALabel
    *
    * @param incr      No description provided
    * @param propName  No description provided
    * @param parent    No description provided
    */
   public FSALabel (LogicUnparseInterface incr, String propName, JComponent parent)
   {
      super (incr, propName, parent);
      setBold (false);
   }


   /**
    * Get the defaultAttrName attribute of the FSALabel object
    *
    * @return   The defaultAttrName value
    */
   public String getDefaultAttrName()
   {
      return "text";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      JLabel txt = new JLabel();
      txt.setBackground (FSAObject.COLOR_BACKGROUND);
      txt.setForeground (FSAObject.COLOR_FOREGROUND);
      txt.setOpaque (false);
      return  (txt);
   }


   /**
    * @return   the text of this label
    * @see      #setText
    * @see      #getText
    */
   public Object getJComponentValue()
   {
      return getText();
   }


   /**
    * class of the AbstractUpdater that usually fits best the jComponent
    *
    * @return   The defaultUpdaterClass value
    */
   public Class getDefaultUpdaterClass()
   {
      return LogicToFsaUpdater.class;
   }


   /**
    * When value is of type icon it is set as the labels icon else value.toString is set as
    * the labels text
    *
    * @param value  The new jComponentValue value
    * @see          #setText
    * @see          #setIcon
    */
   public void setJComponentValue (Object value)
   {
      if (value != null)
      {
         if (value instanceof Icon)
         {
            setIcon ((Icon) value);
         }
         else
         {
            setText (value.toString());
         }
      }
   }


   /**
    * set the text of this label
    *
    * @param text  The new text value
    */
   public void setText (String text)
   {
      JLabel label = (JLabel) getJComponent();

      //FIX ME: Font Style
      //adding html tags for font styles is not a good idea here, since
      //the update mechanism would copy the html text back to the logic fields
      label.setText (
      /*
       *  buildString (text)
       */
         text);
   }


   /**
    * get the text of this label
    *
    * @return   the text of this label
    */
   public String getText()
   {
      JLabel label = (JLabel) getJComponent();

      if (label != null)
      {
         return label.getText();
      }
      else
      {
         return null;
      }
   }


   /**
    * set the icon of this label
    *
    * @param icon  The new icon value
    */
   public void setIcon (Icon icon)
   {
      JLabel label = (JLabel) getJComponent();

      label.setIcon (icon);
   }


   /**
    * get the icon of this label
    *
    * @return   the icon of this label
    */
   public Icon getIcon()
   {
      JLabel label = (JLabel) getJComponent();

      if (label != null)
      {
         return label.getIcon();
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the value of centered.
    *
    * @return   Value of centered.
    */
   public boolean getCentered()
   {
      JLabel txt = (JLabel) getJComponent();

      return  (txt.getHorizontalAlignment() == SwingConstants.CENTER);
   }


   /**
    * Set the value of centered.
    *
    * @param v  Value to assign to centered.
    */
   public void setCentered (boolean v)
   {
      JLabel txt = (JLabel) getJComponent();
      if (v)
      {
         txt.setHorizontalAlignment (SwingConstants.CENTER);
      } // end of if ()
      else
      {
         txt.setHorizontalAlignment (SwingConstants.LEFT);
      } // end of else
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean underscore = false;


   /**
    * Get the value of underscore.
    *
    * @return   Value of underscore.
    */
   public boolean getUnderscore()
   {
      return underscore;
   }


   /**
    * Set the value of underscore.
    *
    * @param v  Value to assign to underscore.
    */
   public void setUnderscore (boolean v)
   {
      this.underscore = v;
   }

}

/*
 * $Log: FSALabel.java,v $
 * Revision 1.21  2004/10/20 17:49:41  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
